/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.Cache3;
import org.apache.juneau.commons.collections.CacheMode;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ElementInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionMap;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class AnnotationProvider {
    private static final CacheMode CACHING_MODE = CacheMode.parse(System.getProperty("juneau.annotationProvider.caching", "FULL"));
    private static final boolean LOG_ON_EXIT = Utils.bool(System.getProperty("juneau.annotationProvider.caching.logOnExit"));
    public static final AnnotationProvider INSTANCE = new AnnotationProvider(AnnotationProvider.create().logOnExit());
    private final Cache<Object, List<AnnotationInfo<Annotation>>> runtimeCache;
    private final Cache3<Class<?>, ElementInfo, AnnotationTraversal[], List> cache;
    private final ReflectionMap<Annotation> annotationMap;

    public static Builder create() {
        return new Builder();
    }

    private static <A extends Annotation> AnnotationInfo<A> ai(Annotatable on, A value) {
        return AnnotationInfo.of(on, value);
    }

    protected AnnotationProvider(Builder builder) {
        this.runtimeCache = Cache.create().supplier(this::load).cacheMode(builder.cacheMode).logOnExit(builder.logOnExit, "AnnotationProvider.runtimeAnnotations").build();
        this.cache = Cache3.create().supplier(this::load).cacheMode(builder.cacheMode).logOnExit(builder.logOnExit, "AnnotationProvider.cache").build();
        this.annotationMap = Utils.opt(builder.runtimeAnnotations).map(x -> x.build()).orElse(null);
    }

    public <A extends Annotation> List<AnnotationInfo<A>> find(Class<A> type, ClassInfo c, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("c", c);
        return this.cache.get(type, c, traversals);
    }

    public <A extends Annotation> List<AnnotationInfo<A>> find(Class<A> type, ConstructorInfo c, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("c", c);
        return this.cache.get(type, c, traversals);
    }

    public <A extends Annotation> List<AnnotationInfo<A>> find(Class<A> type, FieldInfo f, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("f", f);
        return this.cache.get(type, f, traversals);
    }

    public <A extends Annotation> List<AnnotationInfo<A>> find(Class<A> type, MethodInfo m, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("m", m);
        return this.cache.get(type, m, traversals);
    }

    public <A extends Annotation> List<AnnotationInfo<A>> find(Class<A> type, ParameterInfo p, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("type", type);
        AssertionUtils.assertArgNotNull("p", p);
        return this.cache.get(type, p, traversals);
    }

    public List<AnnotationInfo<? extends Annotation>> find(ClassInfo c, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("c", c);
        return this.cache.get(null, c, traversals);
    }

    public List<AnnotationInfo<? extends Annotation>> find(ConstructorInfo c, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("c", c);
        return this.cache.get(null, c, traversals);
    }

    public List<AnnotationInfo<? extends Annotation>> find(FieldInfo f, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("f", f);
        return this.cache.get(null, f, traversals);
    }

    public List<AnnotationInfo<? extends Annotation>> find(MethodInfo m, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("m", m);
        return this.cache.get(null, m, traversals);
    }

    public List<AnnotationInfo<? extends Annotation>> find(ParameterInfo p, AnnotationTraversal ... traversals) {
        AssertionUtils.assertArgNotNull("p", p);
        return this.cache.get(null, p, traversals);
    }

    public <A extends Annotation> boolean has(Class<A> type, ClassInfo c, AnnotationTraversal ... traversals) {
        return !this.find(type, c, traversals).isEmpty();
    }

    public <A extends Annotation> boolean has(Class<A> type, ConstructorInfo c, AnnotationTraversal ... traversals) {
        return !this.find(type, c, traversals).isEmpty();
    }

    public <A extends Annotation> boolean has(Class<A> type, FieldInfo f, AnnotationTraversal ... traversals) {
        return !this.find(type, f, traversals).isEmpty();
    }

    public <A extends Annotation> boolean has(Class<A> type, MethodInfo m, AnnotationTraversal ... traversals) {
        return !this.find(type, m, traversals).isEmpty();
    }

    public <A extends Annotation> boolean has(Class<A> type, ParameterInfo p, AnnotationTraversal ... traversals) {
        return !this.find(type, p, traversals).isEmpty();
    }

    private List load(Class<?> type, ElementInfo element, AnnotationTraversal[] traversals) {
        List<AnnotationTraversal> t;
        if (type != null) {
            return this.cache.get(null, element, traversals).stream().filter(x -> ((AnnotationInfo)x).isType(type)).toList();
        }
        ArrayList<AnnotationInfo<? extends Annotation>> l = new ArrayList<AnnotationInfo<? extends Annotation>>();
        if (traversals.length > 0) {
            t = CollectionUtils.l(traversals);
        } else if (element instanceof ClassInfo) {
            t = CollectionUtils.l(CollectionUtils.a(AnnotationTraversal.PARENTS, AnnotationTraversal.PACKAGE));
        } else if (element instanceof MethodInfo) {
            t = CollectionUtils.l(CollectionUtils.a(AnnotationTraversal.SELF, AnnotationTraversal.MATCHING_METHODS, AnnotationTraversal.DECLARING_CLASS, AnnotationTraversal.RETURN_TYPE, AnnotationTraversal.PACKAGE));
        } else if (element instanceof FieldInfo || element instanceof ConstructorInfo) {
            t = CollectionUtils.l(CollectionUtils.a(AnnotationTraversal.SELF));
        } else {
            AssertionUtils.assertType(ParameterInfo.class, element, () -> ThrowableUtils.unsupportedOp());
            t = CollectionUtils.l(CollectionUtils.a(AnnotationTraversal.SELF, AnnotationTraversal.MATCHING_PARAMETERS, AnnotationTraversal.PARAMETER_TYPE));
        }
        if (element instanceof ClassInfo) {
            ClassInfo element2 = (ClassInfo)element;
            if (t.contains((Object)AnnotationTraversal.SELF)) {
                l.addAll((Collection)this.runtimeCache.get(element2.inner()));
                l.addAll(element2.getDeclaredAnnotations());
            }
            if (t.contains((Object)AnnotationTraversal.PARENTS)) {
                for (ClassInfo p : element2.getParentsAndInterfaces()) {
                    l.addAll((Collection)this.runtimeCache.get(p.inner()));
                    l.addAll(p.getDeclaredAnnotations());
                }
            }
            if (t.contains((Object)AnnotationTraversal.PACKAGE) && element2.getPackage() != null) {
                l.addAll(element2.getPackage().getAnnotations());
            }
        } else if (element instanceof MethodInfo) {
            MethodInfo element3 = (MethodInfo)element;
            if (t.contains((Object)AnnotationTraversal.SELF)) {
                l.addAll((Collection)this.runtimeCache.get(element3.inner()));
                l.addAll(element3.getDeclaredAnnotations());
            }
            if (t.contains((Object)AnnotationTraversal.MATCHING_METHODS)) {
                for (MethodInfo m : element3.getMatchingMethods().stream().skip(1L).toList()) {
                    l.addAll((Collection)this.runtimeCache.get(m.inner()));
                    l.addAll(m.getDeclaredAnnotations());
                }
            }
            if (t.contains((Object)AnnotationTraversal.DECLARING_CLASS)) {
                l.addAll(this.find(element3.getDeclaringClass(), CollectionUtils.a(AnnotationTraversal.PARENTS)));
            }
            if (t.contains((Object)AnnotationTraversal.RETURN_TYPE)) {
                l.addAll(this.find(element3.getReturnType().unwrap(Value.class, Optional.class), CollectionUtils.a(AnnotationTraversal.PARENTS)));
            }
            if (t.contains((Object)AnnotationTraversal.PACKAGE) && element3.getDeclaringClass().getPackage() != null) {
                l.addAll(element3.getDeclaringClass().getPackage().getAnnotations());
            }
        } else if (element instanceof FieldInfo) {
            FieldInfo element4 = (FieldInfo)element;
            if (t.contains((Object)AnnotationTraversal.SELF)) {
                l.addAll((Collection)this.runtimeCache.get(element4.inner()));
                l.addAll(element4.getAnnotations());
            }
        } else if (element instanceof ConstructorInfo) {
            ConstructorInfo element5 = (ConstructorInfo)element;
            if (t.contains((Object)AnnotationTraversal.SELF)) {
                l.addAll((Collection)this.runtimeCache.get(element5.inner()));
                l.addAll(element5.getDeclaredAnnotations());
            }
        } else if (element instanceof ParameterInfo) {
            ParameterInfo element6 = (ParameterInfo)element;
            if (t.contains((Object)AnnotationTraversal.SELF)) {
                l.addAll(element6.getAnnotations());
            }
            if (t.contains((Object)AnnotationTraversal.MATCHING_PARAMETERS)) {
                for (ParameterInfo p : element6.getMatchingParameters().stream().skip(1L).toList()) {
                    l.addAll(p.getAnnotations());
                }
            }
            if (t.contains((Object)AnnotationTraversal.PARAMETER_TYPE)) {
                l.addAll(this.find(element6.getParameterType().unwrap(Value.class, Optional.class), CollectionUtils.a(AnnotationTraversal.PARENTS, AnnotationTraversal.PACKAGE)));
            }
        }
        return l;
    }

    private List load(Object o) {
        if (o instanceof Class) {
            Class o2 = (Class)o;
            ClassInfoTyped ci = ClassInfo.of(o2);
            return this.annotationMap == null ? CollectionUtils.liste() : this.annotationMap.find(ci.inner()).map(a -> AnnotationProvider.ai(ci, a)).toList();
        }
        if (o instanceof Method) {
            Method o2 = (Method)o;
            MethodInfo mi = ReflectionUtils.info(o2);
            return this.annotationMap == null ? CollectionUtils.liste() : this.annotationMap.find(mi.inner()).map(a -> AnnotationProvider.ai(mi, a)).toList();
        }
        if (o instanceof Field) {
            Field o2 = (Field)o;
            FieldInfo fi = ReflectionUtils.info(o2);
            return this.annotationMap == null ? CollectionUtils.liste() : this.annotationMap.find(fi.inner()).map(a -> AnnotationProvider.ai(fi, a)).toList();
        }
        if (o instanceof Constructor) {
            Constructor o2 = (Constructor)o;
            ConstructorInfo ci = ReflectionUtils.info(o2);
            return this.annotationMap == null ? CollectionUtils.liste() : this.annotationMap.find(ci.inner()).map(a -> AnnotationProvider.ai(ci, a)).toList();
        }
        throw ThrowableUtils.unsupportedOp();
    }

    public static class Builder {
        CacheMode cacheMode = CACHING_MODE;
        boolean logOnExit = LOG_ON_EXIT;
        ReflectionMap.Builder<Annotation> runtimeAnnotations;

        Builder() {
        }

        public Builder addRuntimeAnnotations(Annotation ... annotations) {
            return this.addRuntimeAnnotations(CollectionUtils.l(annotations));
        }

        public Builder addRuntimeAnnotations(List<Annotation> annotations) {
            if (this.runtimeAnnotations == null) {
                this.runtimeAnnotations = ReflectionMap.create(Annotation.class);
            }
            for (Annotation a : annotations) {
                try {
                    ClassInfoTyped<?> ci = ClassInfo.of(a.getClass());
                    ci.getPublicMethod(x -> x.hasName("onClass")).ifPresent(mi -> {
                        if (!mi.getReturnType().is(Class[].class)) {
                            throw ThrowableUtils.bex("Invalid annotation @{0} used in runtime annotations.  Annotation must define an onClass() method that returns a Class array.", Utils.cns(a));
                        }
                        for (Class c : (Class[])mi.accessible().invoke(a, new Object[0])) {
                            this.runtimeAnnotations.append(c.getName(), a);
                        }
                    });
                    ci.getPublicMethod(x -> x.hasName("on")).ifPresent(mi -> {
                        if (!mi.getReturnType().is(String[].class)) {
                            throw ThrowableUtils.bex("Invalid annotation @{0} used in runtime annotations.  Annotation must define an on() method that returns a String array.", Utils.cns(a));
                        }
                        for (String s : (String[])mi.accessible().invoke(a, new Object[0])) {
                            this.runtimeAnnotations.append(s, a);
                        }
                    });
                }
                catch (BeanRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ThrowableUtils.bex((Throwable)e, (Class)null, "Invalid annotation @{0} used in runtime annotations.", Utils.cn(a));
                }
            }
            return this;
        }

        public AnnotationProvider build() {
            if (Utils.e(this.runtimeAnnotations) && INSTANCE != null) {
                return INSTANCE;
            }
            return new AnnotationProvider(this);
        }

        public Builder cacheMode(CacheMode value) {
            this.cacheMode = value;
            return this;
        }

        public Builder logOnExit() {
            this.logOnExit = true;
            return this;
        }

        public Builder logOnExit(boolean value) {
            this.logOnExit = value;
            return this;
        }
    }
}

