/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlSerializerSession;

public class XmlSerializer
extends WriterSerializer
implements XmlMetaProvider {
    public static final XmlSerializer DEFAULT = new XmlSerializer(XmlSerializer.create());
    public static final XmlSerializer DEFAULT_SQ = new Sq(XmlSerializer.create());
    public static final XmlSerializer DEFAULT_SQ_READABLE = new SqReadable(XmlSerializer.create());
    public static final XmlSerializer DEFAULT_NS = new Ns(XmlSerializer.create());
    public static final XmlSerializer DEFAULT_NS_SQ = new NsSq(XmlSerializer.create());
    public static final XmlSerializer DEFAULT_NS_SQ_READABLE = new NsSqReadable(XmlSerializer.create());
    protected static final Namespace DEFAULT_JUNEAU_NAMESPACE = Namespace.of("juneau", "http://www.apache.org/2013/Juneau");
    protected static final Namespace DEFAULT_XS_NAMESPACE = Namespace.of("xs", "http://www.w3.org/2001/XMLSchema");
    protected final boolean addBeanTypesXml;
    protected final boolean addJsonTags;
    protected final boolean addNamespaceUrlsToRoot;
    protected final boolean autoDetectNamespaces;
    protected final boolean enableNamespaces;
    private final Namespace defaultNamespace;
    private final List<Namespace> namespaces;
    private final String textNodeDelimiter;
    private final boolean addBeanTypes;
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();

    public static Builder create() {
        return new Builder();
    }

    public XmlSerializer(Builder builder) {
        super(builder);
        this.addBeanTypesXml = builder.addBeanTypesXml;
        this.addJsonTags = !builder.disableJsonTags;
        this.addNamespaceUrlsToRoot = builder.addNamespaceUrisToRoot;
        this.autoDetectNamespaces = !builder.disableAutoDetectNamespaces;
        this.defaultNamespace = Utils.nn((Object)builder.defaultNamespace) ? builder.defaultNamespace : DEFAULT_JUNEAU_NAMESPACE;
        this.enableNamespaces = builder.enableNamespaces;
        this.namespaces = CollectionUtils.u((List)(Utils.nn(builder.namespaces) ? new ArrayList<Namespace>(builder.namespaces) : new ArrayList()));
        this.textNodeDelimiter = builder.textNodeDelimiter;
        this.addBeanTypes = this.addBeanTypesXml || super.isAddBeanTypes();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public XmlSerializerSession.Builder createSession() {
        return XmlSerializerSession.create(this);
    }

    @Override
    public XmlSerializerSession getSession() {
        return this.createSession().build();
    }

    @Override
    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new XmlBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    protected final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected final List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    protected final String getTextNodeDelimiter() {
        return this.textNodeDelimiter;
    }

    @Override
    protected boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddNamespaceUrlsToRoot() {
        return this.addNamespaceUrlsToRoot;
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.autoDetectNamespaces;
    }

    protected final boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"addBeanTypes", (Object)this.addBeanTypes).a((Object)"addNamespaceUrlsToRoot", (Object)this.addNamespaceUrlsToRoot).a((Object)"autoDetectNamespaces", (Object)this.autoDetectNamespaces).a((Object)"defaultNamespace", (Object)this.defaultNamespace).a((Object)"enableNamespaces", (Object)this.enableNamespaces).a((Object)"namespaces", this.namespaces);
    }

    public static class Builder
    extends WriterSerializer.Builder {
        private static final Cache<HashKey, XmlSerializer> CACHE = Cache.of(HashKey.class, XmlSerializer.class).build();
        private boolean addBeanTypesXml;
        private boolean addNamespaceUrisToRoot;
        private boolean disableAutoDetectNamespaces;
        private boolean disableJsonTags;
        private boolean enableNamespaces;
        private Namespace defaultNamespace;
        private List<Namespace> namespaces;
        private String textNodeDelimiter;

        protected Builder() {
            this.produces("text/xml");
            this.addBeanTypesXml = (Boolean)Utils.env((String)"XmlSerializer.addBeanTypes", (Object)false);
            this.addNamespaceUrisToRoot = (Boolean)Utils.env((String)"XmlSerializer.addNamespaceUrisToRoot", (Object)false);
            this.disableAutoDetectNamespaces = (Boolean)Utils.env((String)"XmlSerializer.disableAutoDetectNamespaces", (Object)false);
            this.disableJsonTags = (Boolean)Utils.env((String)"XmlSerializer.disableJsonTags", (Object)false);
            this.enableNamespaces = (Boolean)Utils.env((String)"XmlSerializer.enableNamespaces", (Object)false);
            this.defaultNamespace = null;
            this.namespaces = null;
            this.textNodeDelimiter = (String)Utils.env((String)"XmlSerializer.textNodeDelimiter", (Object)"");
        }

        protected Builder(Builder copyFrom) {
            super((WriterSerializer.Builder)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.addBeanTypesXml = copyFrom.addBeanTypesXml;
            this.addNamespaceUrisToRoot = copyFrom.addNamespaceUrisToRoot;
            this.defaultNamespace = copyFrom.defaultNamespace;
            this.disableAutoDetectNamespaces = copyFrom.disableAutoDetectNamespaces;
            this.disableJsonTags = copyFrom.disableJsonTags;
            this.enableNamespaces = copyFrom.enableNamespaces;
            this.namespaces = copyFrom.namespaces == null ? null : new ArrayList<Namespace>(copyFrom.namespaces);
            this.textNodeDelimiter = copyFrom.textNodeDelimiter;
        }

        protected Builder(XmlSerializer copyFrom) {
            super((WriterSerializer)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.addBeanTypesXml = copyFrom.addBeanTypesXml;
            this.addNamespaceUrisToRoot = copyFrom.addNamespaceUrlsToRoot;
            this.defaultNamespace = copyFrom.getDefaultNamespace();
            this.disableAutoDetectNamespaces = !copyFrom.autoDetectNamespaces;
            this.disableJsonTags = !copyFrom.addJsonTags;
            this.enableNamespaces = copyFrom.enableNamespaces;
            List<Namespace> ctxNamespaces = copyFrom.getNamespaces();
            this.namespaces = ctxNamespaces.isEmpty() ? null : new ArrayList<Namespace>(ctxNamespaces);
            this.textNodeDelimiter = copyFrom.getTextNodeDelimiter();
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addBeanTypes(boolean value) {
            super.addBeanTypes(value);
            return this;
        }

        public Builder addBeanTypesXml() {
            return this.addBeanTypesXml(true);
        }

        public Builder addBeanTypesXml(boolean value) {
            this.addBeanTypesXml = value;
            return this;
        }

        public Builder addNamespaceUrisToRoot() {
            return this.addNamespaceUrisToRoot(true);
        }

        public Builder addNamespaceUrisToRoot(boolean value) {
            this.addNamespaceUrisToRoot = value;
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder addRootType(boolean value) {
            super.addRootType(value);
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public XmlSerializer build() {
            return this.cache((Cache)CACHE).build(XmlSerializer.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder defaultNamespace(Namespace value) {
            this.defaultNamespace = value;
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        public Builder disableAutoDetectNamespaces() {
            return this.disableAutoDetectNamespaces(true);
        }

        public Builder disableAutoDetectNamespaces(boolean value) {
            this.disableAutoDetectNamespaces = value;
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        public Builder disableJsonTags() {
            return this.disableJsonTags(true);
        }

        public Builder disableJsonTags(boolean value) {
            this.disableJsonTags = value;
            return this;
        }

        public Builder enableNamespaces() {
            return this.enableNamespaces(true);
        }

        public Builder enableNamespaces(boolean value) {
            this.enableNamespaces = value;
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.addBeanTypesXml, this.addNamespaceUrisToRoot, this.disableAutoDetectNamespaces, this.disableJsonTags, this.enableNamespaces, this.defaultNamespace, this.namespaces, this.textNodeDelimiter});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder keepNullProperties(boolean value) {
            super.keepNullProperties(value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends SerializerListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        public Builder namespaces(Namespace ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.namespaces = CollectionUtils.addAll(this.namespaces, (Object[])values);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder ns() {
            return this.enableNamespaces();
        }

        @Override
        public Builder produces(String value) {
            super.produces(value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder quoteCharOverride(char value) {
            super.quoteCharOverride(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortCollections(boolean value) {
            super.sortCollections(value);
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sortMaps(boolean value) {
            super.sortMaps(value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        public Builder textNodeDelimiter(String value) {
            this.textNodeDelimiter = value == null ? "" : value;
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyCollections(boolean value) {
            super.trimEmptyCollections(value);
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimEmptyMaps(boolean value) {
            super.trimEmptyMaps(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder useWhitespace(boolean value) {
            super.useWhitespace(value);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }
    }

    public static class Sq
    extends XmlSerializer {
        public Sq(Builder builder) {
            super(((Builder)AssertionUtils.assertArgNotNull((String)"builder", (Object)builder)).quoteChar('\''));
        }
    }

    public static class SqReadable
    extends XmlSerializer {
        public SqReadable(Builder builder) {
            super(((Builder)AssertionUtils.assertArgNotNull((String)"builder", (Object)builder)).quoteChar('\'').useWhitespace());
        }
    }

    public static class Ns
    extends XmlSerializer {
        public Ns(Builder builder) {
            super(((Builder)AssertionUtils.assertArgNotNull((String)"builder", (Object)builder)).enableNamespaces());
        }
    }

    public static class NsSq
    extends XmlSerializer {
        public NsSq(Builder builder) {
            super(((Builder)AssertionUtils.assertArgNotNull((String)"builder", (Object)builder)).enableNamespaces().quoteChar('\''));
        }
    }

    public static class NsSqReadable
    extends XmlSerializer {
        public NsSqReadable(Builder builder) {
            super(((Builder)AssertionUtils.assertArgNotNull((String)"builder", (Object)builder)).enableNamespaces().quoteChar('\'').useWhitespace());
        }
    }
}

