/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMetaRuntimeException;
import org.apache.juneau.Delegate;
import org.apache.juneau.MarshalledFilter;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Example;
import org.apache.juneau.annotation.Marshalled;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.annotation.Uri;
import org.apache.juneau.commons.collections.BidiMap;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.function.OptionalSupplier;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.Property;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.reflect.Mutater;
import org.apache.juneau.reflect.Mutaters;
import org.apache.juneau.swap.AutoListSwap;
import org.apache.juneau.swap.AutoMapSwap;
import org.apache.juneau.swap.AutoNumberSwap;
import org.apache.juneau.swap.AutoObjectSwap;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.DefaultSwaps;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swap.Surrogate;
import org.apache.juneau.swap.SurrogateSwap;

@Bean(properties="innerClass,elementType,keyType,valueType,notABeanReason,initException,beanMeta")
public class ClassMeta<T>
extends ClassInfoTyped<T> {
    private final List<ClassMeta<?>> args;
    private final BeanContext beanContext;
    private final Supplier<BuilderSwap<T, ?>> builderSwap;
    private final Categories cat;
    private final Cache<Class<?>, ObjectSwap<?, ?>> childSwapMap;
    private final Supplier<List<ObjectSwap<?, ?>>> childSwaps;
    private final Cache<Class<?>, ObjectSwap<?, ?>> childUnswapMap;
    private final Supplier<String> beanDictionaryName;
    private final Supplier<ClassMeta<?>> elementType;
    private final OptionalSupplier<String> example;
    private final OptionalSupplier<FieldInfo> exampleField;
    private final OptionalSupplier<MethodInfo> exampleMethod;
    private final Supplier<BidiMap<Object, String>> enumValues;
    private final Map<Class<?>, Mutater<?, T>> fromMutaters = new ConcurrentHashMap();
    private final OptionalSupplier<MethodInfo> fromStringMethod;
    private final OptionalSupplier<ClassInfoTyped<? extends T>> implClass;
    private final Supplier<KeyValueTypes> keyValueTypes;
    private final OptionalSupplier<MarshalledFilter> marshalledFilter;
    private final Supplier<Property<T, Object>> nameProperty;
    private final OptionalSupplier<ConstructorInfo> noArgConstructor;
    private final Supplier<Property<T, Object>> parentProperty;
    private final Cache<String, Optional<?>> properties;
    private final Mutater<String, T> stringMutater;
    private final OptionalSupplier<ConstructorInfo> stringConstructor;
    private final Supplier<List<ObjectSwap<T, ?>>> swaps;
    private final Map<Class<?>, Mutater<T, ?>> toMutaters = new ConcurrentHashMap();
    private final OptionalSupplier<BeanMeta.BeanMetaValue<T>> beanMeta;

    private static boolean isCacheable(Class<?> c) {
        String n = Utils.cn(c);
        char x = n.charAt(n.length() - 1);
        return x < '0' || x > '9' || n.indexOf("$$") == -1 && !n.startsWith("sun") && !n.startsWith("com.sun") && n.indexOf("$Proxy") == -1;
    }

    ClassMeta(Class<T> innerClass, BeanContext beanContext) {
        super(innerClass);
        this.beanContext = beanContext;
        this.cat = new Categories();
        if (Utils.nn(beanContext) && Utils.nn(beanContext.getCmCache()) && ClassMeta.isCacheable(innerClass)) {
            beanContext.getCmCache().put(innerClass, this);
        }
        AnnotationProvider ap = beanContext.getAnnotationProvider();
        if (this.isChildOf(Delegate.class)) {
            this.cat.set(Category.DELEGATE);
        }
        if (this.isEnum()) {
            this.cat.set(Category.ENUM);
        } else if (this.isChildOf(CharSequence.class)) {
            this.cat.set(Category.CHARSEQ);
            if (this.is(String.class)) {
                this.cat.set(Category.STR);
            }
        } else if (this.isChildOf(Number.class) || this.isAny(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE)) {
            this.cat.set(Category.NUMBER);
            if (this.isChildOfAny(Float.class, Double.class) || this.isAny((Class<?>)Float.TYPE, (Class<?>)Double.TYPE)) {
                this.cat.set(Category.DECIMAL);
            }
        } else if (this.isChildOf(Collection.class)) {
            this.cat.set(Category.COLLECTION);
            if (this.isChildOf(Set.class)) {
                this.cat.set(Category.SET);
            } else if (this.isChildOf(List.class)) {
                this.cat.set(Category.LIST);
            }
        } else if (this.isChildOf(Map.class)) {
            this.cat.set(Category.MAP);
            if (this.isChildOf(BeanMap.class)) {
                this.cat.set(Category.BEANMAP);
            }
        } else if (this.isChildOfAny(Date.class, Calendar.class)) {
            if (this.isChildOf(Date.class)) {
                this.cat.set(Category.DATE);
            } else if (this.isChildOf(Calendar.class)) {
                this.cat.set(Category.CALENDAR);
            }
        } else if (this.isChildOf(Temporal.class)) {
            this.cat.set(Category.TEMPORAL);
        } else if (this.inner().isArray()) {
            this.cat.set(Category.ARRAY);
        } else if (this.isChildOfAny(URL.class, URI.class) || ap.has(Uri.class, this, new AnnotationTraversal[0])) {
            this.cat.set(Category.URI);
        } else if (this.isChildOf(Reader.class)) {
            this.cat.set(Category.READER);
        } else if (this.isChildOf(InputStream.class)) {
            this.cat.set(Category.INPUTSTREAM);
        }
        this.beanMeta = Utils.mem(() -> this.findBeanMeta());
        this.builderSwap = Utils.mem(() -> this.findBuilderSwap());
        this.childSwapMap = Cache.create().supplier(x -> this.findSwap((Class<?>)x)).build();
        this.childSwaps = Utils.mem(() -> this.findChildSwaps());
        this.childUnswapMap = Cache.create().supplier(x -> this.findUnswap((Class<?>)x)).build();
        this.beanDictionaryName = Utils.mem(() -> this.findBeanDictionaryName());
        this.elementType = Utils.mem(() -> this.findElementType());
        this.enumValues = Utils.mem(() -> this.findEnumValues());
        this.example = Utils.mem(() -> this.findExample());
        this.exampleField = Utils.mem(() -> this.findExampleField());
        this.exampleMethod = Utils.mem(() -> this.findExampleMethod());
        this.fromStringMethod = Utils.mem(() -> this.findFromStringMethod());
        this.implClass = Utils.mem(() -> this.findImplClass());
        this.keyValueTypes = Utils.mem(() -> this.findKeyValueTypes());
        this.marshalledFilter = Utils.mem(() -> this.findMarshalledFilter());
        this.nameProperty = Utils.mem(() -> this.findNameProperty());
        this.noArgConstructor = Utils.mem(() -> this.findNoArgConstructor());
        this.parentProperty = Utils.mem(() -> this.findParentProperty());
        this.properties = Cache.create().build();
        this.stringConstructor = Utils.mem(() -> this.findStringConstructor());
        this.swaps = Utils.mem(() -> this.findSwaps());
        this.args = null;
        this.stringMutater = Mutaters.get(String.class, this.inner());
    }

    protected ObjectSwap<?, ?> findSwap(Class<?> c) {
        return this.childSwaps.get().stream().filter(x -> x.getNormalClass().isParentOf(c)).findFirst().orElse(null);
    }

    protected ObjectSwap<?, ?> findUnswap(Class<?> c) {
        return this.childSwaps.get().stream().filter(x -> x.getSwapClass().isParentOf(c)).findFirst().orElse(null);
    }

    ClassMeta(List<ClassMeta<?>> args) {
        super(Object[].class);
        this.args = args;
        this.childSwaps = Utils.mem(() -> this.findChildSwaps());
        this.childSwapMap = null;
        this.childUnswapMap = null;
        this.cat = new Categories().set(Category.ARGS);
        this.beanContext = null;
        this.elementType = Utils.mem(() -> this.findElementType());
        this.keyValueTypes = Utils.mem(() -> this.findKeyValueTypes());
        this.beanMeta = Utils.mem(() -> this.findBeanMeta());
        this.swaps = Utils.mem(() -> this.findSwaps());
        this.stringMutater = null;
        this.fromStringMethod = Utils.mem(() -> this.findFromStringMethod());
        this.exampleMethod = Utils.mem(() -> this.findExampleMethod());
        this.parentProperty = Utils.mem(() -> this.findParentProperty());
        this.nameProperty = Utils.mem(() -> this.findNameProperty());
        this.exampleField = Utils.mem(() -> this.findExampleField());
        this.noArgConstructor = Utils.mem(() -> this.findNoArgConstructor());
        this.properties = Cache.create().build();
        this.stringConstructor = Utils.mem(() -> this.findStringConstructor());
        this.marshalledFilter = Utils.mem(() -> this.findMarshalledFilter());
        this.builderSwap = Utils.mem(() -> this.findBuilderSwap());
        this.example = Utils.mem(() -> this.findExample());
        this.implClass = Utils.mem(() -> this.findImplClass());
        this.enumValues = Utils.mem(() -> this.findEnumValues());
        this.beanDictionaryName = Utils.mem(() -> this.findBeanDictionaryName());
    }

    ClassMeta(ClassMeta<T> mainType, ClassMeta<?> keyType, ClassMeta<?> valueType, ClassMeta<?> elementType) {
        super(mainType.inner());
        this.childSwaps = mainType.childSwaps;
        this.childSwapMap = mainType.childSwapMap;
        this.childUnswapMap = mainType.childUnswapMap;
        this.cat = mainType.cat;
        this.fromStringMethod = mainType.fromStringMethod;
        this.beanContext = mainType.beanContext;
        this.elementType = elementType != null ? Utils.mem(() -> elementType) : mainType.elementType;
        this.keyValueTypes = keyType != null || valueType != null ? Utils.mem(() -> new KeyValueTypes(keyType, valueType)) : mainType.keyValueTypes;
        this.beanMeta = mainType.beanMeta;
        this.swaps = mainType.swaps;
        this.exampleMethod = mainType.exampleMethod;
        this.args = null;
        this.stringMutater = mainType.stringMutater;
        this.parentProperty = mainType.parentProperty;
        this.nameProperty = mainType.nameProperty;
        this.exampleField = mainType.exampleField;
        this.noArgConstructor = mainType.noArgConstructor;
        this.properties = mainType.properties;
        this.stringConstructor = mainType.stringConstructor;
        this.marshalledFilter = mainType.marshalledFilter;
        this.builderSwap = mainType.builderSwap;
        this.example = mainType.example;
        this.implClass = mainType.implClass;
        this.enumValues = mainType.enumValues;
        this.beanDictionaryName = mainType.beanDictionaryName;
    }

    public boolean canCreateNewBean(Object outer) {
        BeanMeta<T> bm = this.getBeanMeta();
        if (bm == null || !bm.hasConstructor()) {
            return false;
        }
        if (this.isMemberClass() && this.isNotStatic()) {
            return Utils.nn(outer) && bm.getConstructor().hasParameterTypes(outer.getClass());
        }
        return true;
    }

    public boolean canCreateNewInstance() {
        if (this.isMemberClass() && this.isNotStatic()) {
            return false;
        }
        BeanMeta<T> bm = this.getBeanMeta();
        return this.noArgConstructor.isPresent() || bm != null && bm.getBeanProxyInvocationHandler() != null || this.isArray() && this.elementType.get().canCreateNewInstance();
    }

    public boolean canCreateNewInstance(Object outer) {
        if (this.isMemberClass() && this.isNotStatic()) {
            return Utils.nn(outer) && this.noArgConstructor.map(x -> x.hasParameterTypes(outer.getClass())).orElse(false) != false;
        }
        return this.canCreateNewInstance();
    }

    public boolean canCreateNewInstanceFromString(Object outer) {
        if (this.fromStringMethod.isPresent()) {
            return true;
        }
        if (this.stringConstructor.isPresent()) {
            if (this.isMemberClass() && this.isNotStatic()) {
                return Utils.nn(outer) && this.stringConstructor.map(x -> x.hasParameterTypes(outer.getClass(), String.class)).orElse(false) != false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ClassMeta && super.equals(o);
    }

    public <A extends Annotation> ClassMeta<T> forEachAnnotation(Class<A> type, Predicate<A> filter, Consumer<A> action) {
        if (this.beanContext != null) {
            this.beanContext.getAnnotationProvider().find(type, this, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(x -> filter == null || filter.test(x)).forEach(x -> action.accept(x));
        }
        return this;
    }

    public ClassMeta<?> getArg(int index) {
        if (Utils.nn(this.args) && index >= 0 && index < this.args.size()) {
            return this.args.get(index);
        }
        throw ThrowableUtils.bex("Invalid argument index specified:  {0}.  Only {1} arguments are defined.", index, this.args == null ? 0 : this.args.size());
    }

    public List<ClassMeta<?>> getArgs() {
        return this.args;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public BeanMeta<T> getBeanMeta() {
        return ((BeanMeta.BeanMetaValue)this.beanMeta.get()).beanMeta();
    }

    public BeanRegistry getBeanRegistry() {
        return ((BeanMeta.BeanMetaValue)this.beanMeta.get()).optBeanMeta().map(x -> x.getBeanRegistry()).orElse(null);
    }

    public BuilderSwap<T, ?> getBuilderSwap(BeanSession session) {
        return this.builderSwap.get();
    }

    public String getBeanDictionaryName() {
        return this.beanDictionaryName.get();
    }

    public ClassMeta<?> getElementType() {
        return this.elementType.get();
    }

    public T getExample(BeanSession session, JsonParserSession jpSession) {
        try {
            if (this.example.isPresent()) {
                return jpSession.parse((String)this.example.get(), this);
            }
            if (this.exampleMethod.isPresent()) {
                return (T)((MethodInfo)this.exampleMethod.get()).invokeLenient(null, session);
            }
            if (this.exampleField.isPresent()) {
                return ((FieldInfo)this.exampleField.get()).get(null);
            }
            if (this.isCollection()) {
                Object etExample = this.getElementType().getExample(session, jpSession);
                if (Utils.nn(etExample)) {
                    if (this.canCreateNewInstance()) {
                        Collection c = (Collection)this.newInstance();
                        c.add(etExample);
                        return (T)c;
                    }
                    return (T)Collections.singleton(etExample);
                }
            } else if (super.isArray()) {
                Object etExample = this.getElementType().getExample(session, jpSession);
                if (Utils.nn(etExample)) {
                    Object o = Array.newInstance(this.getElementType().inner(), 1);
                    Array.set(o, 0, etExample);
                    return (T)o;
                }
            } else if (this.isMap()) {
                Object vtExample = this.getValueType().getExample(session, jpSession);
                Object ktExample = this.getKeyType().getExample(session, jpSession);
                if (Utils.nn(ktExample) && Utils.nn(vtExample)) {
                    if (this.canCreateNewInstance()) {
                        Map m = (Map)this.newInstance();
                        m.put(ktExample, vtExample);
                        return (T)m;
                    }
                    return (T)Collections.singletonMap(ktExample, vtExample);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ClassMetaRuntimeException(e);
        }
    }

    public <I> Mutater<I, T> getFromMutater(Class<I> c) {
        Mutater<Object, Object> t = this.fromMutaters.get(c);
        if (t == Mutaters.NULL) {
            return null;
        }
        if (t == null) {
            t = Mutaters.get(c, this.inner());
            if (t == null) {
                t = Mutaters.NULL;
            }
            this.fromMutaters.put(c, t);
        }
        return t == Mutaters.NULL ? null : t;
    }

    public ConstructorInfo getImplClassConstructor(Visibility conVis) {
        return this.implClass.map(x -> x.getNoArgConstructor(conVis).orElse(null)).orElse(null);
    }

    public Mutater<InputStream, T> getInputStreamMutater() {
        return this.getFromMutater(InputStream.class);
    }

    public ClassMeta<?> getKeyType() {
        return this.keyValueTypes.get().keyType();
    }

    public Property<T, Object> getNameProperty() {
        return this.nameProperty.get();
    }

    public synchronized String getNotABeanReason() {
        return ((BeanMeta.BeanMetaValue)this.beanMeta.get()).notABeanReason();
    }

    public Optional<?> getOptionalDefault() {
        if (this.isOptional()) {
            return Utils.opt(this.getElementType().getOptionalDefault());
        }
        return null;
    }

    public Property<T, Object> getParentProperty() {
        return this.parentProperty.get();
    }

    public <T2> Optional<T2> getProperty(String name, Function<ClassMeta<?>, T2> function) {
        return this.properties.get(name, () -> Utils.opt(function.apply(this)));
    }

    public InvocationHandler getProxyInvocationHandler() {
        return ((BeanMeta.BeanMetaValue)this.beanMeta.get()).optBeanMeta().map(x -> x.getBeanProxyInvocationHandler()).orElse(null);
    }

    public Mutater<Reader, T> getReaderMutater() {
        return this.getFromMutater(Reader.class);
    }

    public ClassMeta<?> getSerializedClassMeta(BeanSession session) {
        ObjectSwap<T, ?> ps = this.getSwap(session);
        return ps == null ? this : ps.getSwapClassMeta(session);
    }

    public Mutater<String, T> getStringMutater() {
        return this.stringMutater;
    }

    public ObjectSwap<T, ?> getSwap(BeanSession session) {
        List<ObjectSwap<T, ?>> swapsList = this.swaps.get();
        if (!swapsList.isEmpty()) {
            int matchQuant = 0;
            ObjectSwap<T, ?> matchSwap = null;
            for (ObjectSwap<T, ?> swap : swapsList) {
                int q = swap.match(session);
                if (q <= matchQuant) continue;
                matchQuant = q;
                matchSwap = swap;
            }
            if (matchSwap != null) {
                return matchSwap;
            }
        }
        return null;
    }

    public <O> Mutater<T, O> getToMutater(Class<O> c) {
        Mutater<Object, Object> t = this.toMutaters.get(c);
        if (t == Mutaters.NULL) {
            return null;
        }
        if (t == null) {
            t = Mutaters.get(this.inner(), c);
            if (t == null) {
                t = Mutaters.NULL;
            }
            this.toMutaters.put(c, t);
        }
        return t == Mutaters.NULL ? null : t;
    }

    public ClassMeta<?> getValueType() {
        return this.keyValueTypes.get().valueType();
    }

    public boolean hasInputStreamMutater() {
        return this.hasMutaterFrom(InputStream.class);
    }

    public boolean hasMutaterFrom(Class<?> c) {
        return Utils.nn(this.getFromMutater(c));
    }

    public boolean hasMutaterFrom(ClassMeta<?> c) {
        return Utils.nn(this.getFromMutater(c.inner()));
    }

    public boolean hasMutaterTo(Class<?> c) {
        return Utils.nn(this.getToMutater(c));
    }

    public boolean hasMutaterTo(ClassMeta<?> c) {
        return Utils.nn(this.getToMutater(c.inner()));
    }

    public boolean hasReaderMutater() {
        return this.hasMutaterFrom(Reader.class);
    }

    public boolean hasStringMutater() {
        return Utils.nn(this.stringMutater);
    }

    public boolean isArgs() {
        return this.cat.is(Category.ARGS);
    }

    public boolean isBean() {
        return Utils.nn(this.getBeanMeta());
    }

    public boolean isBeanMap() {
        return this.cat.is(Category.BEANMAP);
    }

    public boolean isBoolean() {
        return this.isAny((Class<?>)Boolean.TYPE, (Class<?>)Boolean.class);
    }

    public boolean isByteArray() {
        return this.is(byte[].class);
    }

    public boolean isCalendar() {
        return this.cat.is(Category.CALENDAR);
    }

    public boolean isChar() {
        return this.isAny((Class<?>)Character.TYPE, (Class<?>)Character.class);
    }

    public boolean isCharSequence() {
        return this.cat.is(Category.CHARSEQ);
    }

    public boolean isCollection() {
        return this.cat != null && this.cat.is(Category.COLLECTION);
    }

    public boolean isCollectionOrArrayOrOptional() {
        return this.cat.is(Category.ARRAY) || this.is(Optional.class) || this.cat.is(Category.COLLECTION);
    }

    public boolean isDate() {
        return this.cat.is(Category.DATE);
    }

    public boolean isDateOrCalendar() {
        return this.cat.is(Category.DATE) || this.cat.is(Category.CALENDAR);
    }

    public boolean isDateOrCalendarOrTemporal() {
        return this.cat.is(Category.DATE) || this.cat.is(Category.CALENDAR) || this.cat.is(Category.TEMPORAL);
    }

    public boolean isDecimal() {
        return this.cat.is(Category.DECIMAL);
    }

    public boolean isDelegate() {
        return this.cat.is(Category.DELEGATE);
    }

    public boolean isDouble() {
        return this.isAny((Class<?>)Double.class, (Class<?>)Double.TYPE);
    }

    public boolean isFloat() {
        return this.isAny((Class<?>)Float.class, (Class<?>)Float.TYPE);
    }

    public boolean isInputStream() {
        return this.cat.is(Category.INPUTSTREAM);
    }

    public boolean isInteger() {
        return this.isAny((Class<?>)Integer.class, (Class<?>)Integer.TYPE);
    }

    public boolean isList() {
        return this.cat.is(Category.LIST);
    }

    public boolean isLong() {
        return this.isAny((Class<?>)Long.class, (Class<?>)Long.TYPE);
    }

    public boolean isMap() {
        return this.cat != null && this.cat.is(Category.MAP);
    }

    public boolean isMapOrBean() {
        return this.cat.is(Category.MAP) || Utils.nn(this.getBeanMeta());
    }

    public boolean isMethod() {
        return this.is(Method.class);
    }

    public boolean isNullable() {
        if (this.isPrimitive()) {
            return this.is(Character.TYPE);
        }
        return true;
    }

    public boolean isNumber() {
        return this.cat.is(Category.NUMBER);
    }

    public boolean isObject() {
        return this.is(Object.class);
    }

    public boolean isOptional() {
        return this.is(Optional.class);
    }

    public boolean isReader() {
        return this.cat.is(Category.READER);
    }

    public boolean isSet() {
        return this.cat.is(Category.SET);
    }

    public boolean isShort() {
        return this.isAny((Class<?>)Short.class, (Class<?>)Short.TYPE);
    }

    public boolean isString() {
        return this.is(String.class);
    }

    public boolean isTemporal() {
        return this.cat.is(Category.TEMPORAL);
    }

    public boolean isUri() {
        return this.cat != null && this.cat.is(Category.URI);
    }

    public T mutateFrom(Object o) {
        Mutater<?, T> t = this.getFromMutater(o.getClass());
        return t == null ? null : (T)t.mutate(o);
    }

    public <O> O mutateTo(Object o, Class<O> c) {
        Mutater<T, O> t = this.getToMutater(c);
        return t == null ? null : (O)t.mutate(o);
    }

    public <O> O mutateTo(Object o, ClassMeta<O> c) {
        return (O)this.mutateTo(o, c.inner());
    }

    public T newInstance() throws ExecutableException {
        if (super.isArray()) {
            return (T)Array.newInstance(this.inner().getComponentType(), 0);
        }
        if (this.noArgConstructor.isPresent()) {
            return ((ConstructorInfo)this.noArgConstructor.get()).newInstance(new Object[0]);
        }
        InvocationHandler h = this.getProxyInvocationHandler();
        if (Utils.nn(h)) {
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), CollectionUtils.a(this.inner(), Serializable.class), h);
        }
        return null;
    }

    public T newInstance(Object outer) throws ExecutableException {
        if (this.isMemberClass() && this.isNotStatic() && this.noArgConstructor.isPresent()) {
            return ((ConstructorInfo)this.noArgConstructor.get()).newInstance(outer);
        }
        return this.newInstance();
    }

    public T newInstanceFromString(Object outer, String arg) throws ExecutableException {
        if (this.isEnum()) {
            Object t = this.enumValues.get().getKey(arg);
            if (t == null && !this.beanContext.isIgnoreUnknownEnumValues()) {
                throw new ExecutableException("Could not resolve enum value ''{0}'' on class ''{1}''", arg, Utils.cn(this.inner()));
            }
            return (T)t;
        }
        if (this.fromStringMethod.isPresent()) {
            return ((MethodInfo)this.fromStringMethod.get()).invoke(null, arg);
        }
        if (this.stringConstructor.isPresent()) {
            if (this.isMemberClass() && this.isNotStatic()) {
                return ((ConstructorInfo)this.stringConstructor.get()).newInstance(outer, arg);
            }
            return ((ConstructorInfo)this.stringConstructor.get()).newInstance(arg);
        }
        throw new ExecutableException("No string constructor or valueOf(String) method found for class '" + Utils.cn(this.inner()) + "'", new Object[0]);
    }

    public boolean same(ClassMeta<?> cm) {
        if (this.equals(cm)) {
            return true;
        }
        return this.isPrimitive() && this.cat.same(cm.cat);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simple) {
        return this.toString(new StringBuilder(), simple).toString();
    }

    public String toString(Object t) {
        if (t == null) {
            return null;
        }
        if (this.isEnum() && this.beanContext.isUseEnumNames()) {
            return ((Enum)t).name();
        }
        return t.toString();
    }

    private ObjectSwap<T, ?> createSwap(Swap s) {
        List<SurrogateSwap<?, ?>> l;
        ClassInfoTyped<?> ci;
        Class<?> c = s.value();
        if (ClassUtils.isVoid(c)) {
            c = s.impl();
        }
        if ((ci = ReflectionUtils.info(c)).isChildOf(ObjectSwap.class)) {
            ObjectSwap ps = BeanCreator.of(ObjectSwap.class).type(ci).run();
            if (s.mediaTypes().length > 0) {
                ps.forMediaTypes(MediaType.ofAll(s.mediaTypes()));
            }
            if (!s.template().isEmpty()) {
                ps.withTemplate(s.template());
            }
            return ps;
        }
        if (ci.isChildOf(Surrogate.class) && !(l = SurrogateSwap.findObjectSwaps(c, this.beanContext)).isEmpty()) {
            return l.iterator().next();
        }
        throw new ClassMetaRuntimeException(c, "Invalid swap class ''{0}'' specified.  Must extend from ObjectSwap or Surrogate.", c);
    }

    private String findBeanDictionaryName() {
        if (this.beanContext == null) {
            return null;
        }
        String d = ((BeanMeta.BeanMetaValue)this.beanMeta.get()).optBeanMeta().map(x -> x.getDictionaryName()).orElse(null);
        if (Utils.nn(d)) {
            return d;
        }
        return this.beanContext.getAnnotationProvider().find(Bean.class, this, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(x -> !x.typeName().isEmpty()).map(x -> x.typeName()).findFirst().orElse(null);
    }

    private BeanMeta.BeanMetaValue<T> findBeanMeta() {
        if (!this.cat.isUnknown()) {
            return new BeanMeta.BeanMetaValue(null, "Known non-bean type");
        }
        return BeanMeta.create(this, (ClassInfo)this.implClass.get());
    }

    private KeyValueTypes findKeyValueTypes() {
        if (this.cat.is(Category.MAP) && !this.cat.is(Category.BEANMAP)) {
            ClassMeta[] parameters = this.beanContext.findParameters(this.inner(), this.inner());
            if (Utils.nn(parameters) && parameters.length == 2) {
                return new KeyValueTypes(parameters[0], parameters[1]);
            }
            return new KeyValueTypes(this.beanContext.getClassMeta(Object.class), this.beanContext.getClassMeta(Object.class));
        }
        return new KeyValueTypes(null, null);
    }

    private ClassMeta<?> findElementType() {
        if (this.beanContext == null) {
            return null;
        }
        if (this.cat.is(Category.ARRAY)) {
            return this.beanContext.getClassMeta(this.inner().getComponentType());
        }
        if (this.cat.is(Category.COLLECTION) || this.is(Optional.class)) {
            ClassMeta[] parameters = this.beanContext.findParameters(this.inner(), this.inner());
            if (Utils.nn(parameters) && parameters.length == 1) {
                return parameters[0];
            }
            return this.beanContext.getClassMeta(Object.class);
        }
        return null;
    }

    private BuilderSwap<T, ?> findBuilderSwap() {
        BeanContext bc = this.beanContext;
        if (bc == null) {
            return null;
        }
        return BuilderSwap.findSwapFromObjectClass(bc, this.inner(), bc.getBeanConstructorVisibility(), bc.getBeanMethodVisibility());
    }

    private List<ObjectSwap<T, ?>> findSwaps() {
        if (this.beanContext == null) {
            return CollectionUtils.l(new ObjectSwap[0]);
        }
        ArrayList list = new ArrayList();
        List<ObjectSwap<?, ?>> swapArray = this.beanContext.getSwaps();
        if (!swapArray.isEmpty()) {
            Class innerClass = this.inner();
            for (ObjectSwap<?, ?> f : swapArray) {
                if (!f.getNormalClass().isParentOf(innerClass)) continue;
                list.add(f);
            }
        }
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        ap.find(Swap.class, this, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).forEach(x -> list.add(this.createSwap((Swap)x)));
        ObjectSwap<?, ?> ds = DefaultSwaps.find(this);
        if (ds == null) {
            ds = AutoObjectSwap.find(this.beanContext, this);
        }
        if (ds == null) {
            ds = AutoNumberSwap.find(this.beanContext, this);
        }
        if (ds == null) {
            ds = AutoMapSwap.find(this.beanContext, this);
        }
        if (ds == null) {
            ds = AutoListSwap.find(this.beanContext, this);
        }
        if (Utils.nn(ds)) {
            list.add(ds);
        }
        return CollectionUtils.u(list);
    }

    private List<ObjectSwap<?, ?>> findChildSwaps() {
        if (this.beanContext == null) {
            return CollectionUtils.l(new ObjectSwap[0]);
        }
        List<ObjectSwap<?, ?>> swapArray = this.beanContext.getSwaps();
        if (swapArray.isEmpty()) {
            return CollectionUtils.l(new ObjectSwap[0]);
        }
        ArrayList list = new ArrayList();
        Class innerClass = this.inner();
        for (ObjectSwap<?, ?> f : swapArray) {
            if (!f.getNormalClass().isChildOf(innerClass)) continue;
            list.add(f);
        }
        return CollectionUtils.u(list);
    }

    private BidiMap<Object, String> findEnumValues() {
        if (!this.isEnum()) {
            return null;
        }
        BeanContext bc = this.beanContext;
        boolean useEnumNames = Utils.nn(bc) && bc.isUseEnumNames();
        BidiMap.Builder m = BidiMap.create().unmodifiable();
        Class<Enum> c = this.inner().asSubclass(Enum.class);
        CollectionUtils.stream(c.getEnumConstants()).forEach(x -> m.add(x, useEnumNames ? x.name() : x.toString()));
        return m.build();
    }

    private String findExample() {
        String example = ((BeanMeta.BeanMetaValue)this.beanMeta.get()).optBeanMeta().map(x -> x.getBeanFilter()).map(x -> x.getExample()).orElse(null);
        if (example == null) {
            example = this.marshalledFilter.map(x -> x.getExample()).orElse(null);
        }
        if (example == null && Utils.nn(this.beanContext)) {
            example = this.beanContext.getAnnotationProvider().find(Example.class, this, new AnnotationTraversal[0]).stream().map(x -> ((Example)x.inner()).value()).filter(Utils::ne).findFirst().orElse(null);
        }
        if (example == null) {
            if (this.isAny((Class<?>)Boolean.TYPE, (Class<?>)Boolean.class)) {
                example = "true";
            } else if (this.isAny((Class<?>)Character.TYPE, (Class<?>)Character.class)) {
                example = "a";
            } else if (this.cat.is(Category.CHARSEQ)) {
                example = "foo";
            } else if (this.cat.is(Category.ENUM)) {
                Iterator i = EnumSet.allOf(this.inner().asSubclass(Enum.class)).iterator();
                example = i.hasNext() ? (this.beanContext.isUseEnumNames() ? ((Enum)i.next()).name() : ((Enum)i.next()).toString()) : null;
            } else if (this.isAny((Class<?>)Float.TYPE, (Class<?>)Float.class, (Class<?>)Double.TYPE, (Class<?>)Double.class)) {
                example = "1.0";
            } else if (this.isAny(Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class)) {
                example = "1";
            }
        }
        return example;
    }

    private FieldInfo findExampleField() {
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        return this.getDeclaredFields().stream().filter(x -> x.isStatic() && this.isParentOf(x.getFieldType()) && ap.has(Example.class, (FieldInfo)x, new AnnotationTraversal[0])).map(x -> x.accessible()).findFirst().orElse(null);
    }

    private MethodInfo findExampleMethod() {
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        Optional<MethodInfo> m = this.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && (x.hasName("example") || ap.has(Example.class, (MethodInfo)x, new AnnotationTraversal[0])) && x.hasParameterTypesLenient(BeanSession.class));
        if (m.isPresent()) {
            return m.get();
        }
        return this.getDeclaredMethods().stream().flatMap(x -> x.getMatchingMethods().stream()).filter(x -> x.isStatic() && ap.has(Example.class, (MethodInfo)x, new AnnotationTraversal[0])).map(x -> x.accessible()).findFirst().orElse(null);
    }

    private MethodInfo findFromStringMethod() {
        String[] names = CollectionUtils.a("fromString", "fromValue", "valueOf", "parse", "parseString", "forName", "forString");
        return this.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasReturnType(this) && x.hasParameterTypes(String.class) && CollectionUtils.contains(x.getName(), names)).orElse(null);
    }

    private ClassInfoTyped<? extends T> findImplClass() {
        if (this.is(Object.class)) {
            return null;
        }
        ClassInfo v = this.beanContext.getAnnotationProvider().find(Bean.class, this, new AnnotationTraversal[0]).stream().map(x -> (Bean)x.inner()).filter(x -> Utils.neq(x.implClass(), Void.TYPE)).map(x -> ClassInfo.of(x)).findFirst().orElse(null);
        if (v == null) {
            v = this.marshalledFilter.map(x -> x.getImplClass()).map(ReflectionUtils::info).orElse(null);
        }
        return (ClassInfoTyped)v;
    }

    private MarshalledFilter findMarshalledFilter() {
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        List<AnnotationInfo<Marshalled>> l = ap.find(Marshalled.class, this, new AnnotationTraversal[0]);
        if (l.isEmpty()) {
            return null;
        }
        return MarshalledFilter.create(this.inner()).applyAnnotations(CollectionUtils.reverse(l.stream().map(AnnotationInfo::inner).toList())).build();
    }

    private Property<T, Object> findNameProperty() {
        Optional<MethodInfo> getterMethod;
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        Optional<Property> s = this.getAllFields().stream().filter(x -> ap.has(NameProperty.class, (FieldInfo)x, new AnnotationTraversal[0])).map(x -> x.accessible()).map(x -> Property.create().field((FieldInfo)x).build()).findFirst();
        if (s.isPresent()) {
            return s.get();
        }
        Property.Builder<Object, Object> builder = Property.create();
        Optional<MethodInfo> setterMethod = this.getAllMethods().stream().filter(x -> ap.has(NameProperty.class, (MethodInfo)x, new AnnotationTraversal[0]) && x.hasNumParameters(1)).findFirst();
        if (setterMethod.isPresent()) {
            builder.setter(setterMethod.get().accessible());
            String setterName = setterMethod.get().getSimpleName();
            if (setterName.startsWith("set") && setterName.length() > 3) {
                String propertyName = setterName.substring(3);
                String getterName1 = "get" + propertyName;
                String getterName2 = "is" + propertyName;
                Optional<MethodInfo> getter = this.getAllMethods().stream().filter(x -> !x.isStatic() && x.hasNumParameters(0) && (x.hasName(getterName1) || x.hasName(getterName2)) && !x.getReturnType().is(Void.TYPE)).findFirst();
                if (getter.isPresent()) {
                    builder.getter(getter.get().accessible());
                } else {
                    String fieldName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                    Optional<FieldInfo> field = this.getAllFields().stream().filter(x -> !x.isStatic() && x.hasName(fieldName)).findFirst();
                    if (field.isPresent()) {
                        FieldInfo f = field.get().accessible();
                        builder.getter(obj -> f.get(obj));
                    }
                }
            }
        }
        if ((getterMethod = this.getAllMethods().stream().filter(x -> ap.has(NameProperty.class, (MethodInfo)x, new AnnotationTraversal[0]) && x.hasNumParameters(0) && !x.getReturnType().is(Void.TYPE)).findFirst()).isPresent()) {
            builder.getter(getterMethod.get().accessible());
        }
        if (setterMethod.isEmpty() && getterMethod.isEmpty()) {
            return null;
        }
        return builder.build();
    }

    private ConstructorInfo findNoArgConstructor() {
        if (this.is(Object.class)) {
            return null;
        }
        if (this.implClass.isPresent()) {
            return ((ClassInfoTyped)this.implClass.get()).getPublicConstructor(x -> x.hasNumParameters(0)).orElse(null);
        }
        if (this.isAbstract()) {
            return null;
        }
        int numParams = this.isMemberClass() && this.isNotStatic() ? 1 : 0;
        return this.getPublicConstructors().stream().filter(x -> x.isPublic() && x.isNotDeprecated() && x.hasNumParameters(numParams)).findFirst().orElse(null);
    }

    private Property<T, Object> findParentProperty() {
        Optional<MethodInfo> getterMethod;
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        Optional<Property> s = this.getAllFields().stream().filter(x -> ap.has(ParentProperty.class, (FieldInfo)x, new AnnotationTraversal[0])).map(x -> x.accessible()).map(x -> Property.create().field((FieldInfo)x).build()).findFirst();
        if (s.isPresent()) {
            return s.get();
        }
        Property.Builder<Object, Object> builder = Property.create();
        Optional<MethodInfo> setterMethod = this.getAllMethods().stream().filter(x -> ap.has(ParentProperty.class, (MethodInfo)x, new AnnotationTraversal[0]) && x.hasNumParameters(1)).findFirst();
        if (setterMethod.isPresent()) {
            builder.setter(setterMethod.get().accessible());
            String setterName = setterMethod.get().getSimpleName();
            if (setterName.startsWith("set") && setterName.length() > 3) {
                String propertyName = setterName.substring(3);
                String getterName1 = "get" + propertyName;
                String getterName2 = "is" + propertyName;
                Optional<MethodInfo> getter = this.getAllMethods().stream().filter(x -> !x.isStatic() && x.hasNumParameters(0) && (x.hasName(getterName1) || x.hasName(getterName2)) && !x.getReturnType().is(Void.TYPE)).findFirst();
                if (getter.isPresent()) {
                    builder.getter(getter.get().accessible());
                } else {
                    String fieldName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                    Optional<FieldInfo> field = this.getAllFields().stream().filter(x -> !x.isStatic() && x.hasName(fieldName)).findFirst();
                    if (field.isPresent()) {
                        FieldInfo f = field.get().accessible();
                        builder.getter(obj -> f.get(obj));
                    }
                }
            }
        }
        if ((getterMethod = this.getAllMethods().stream().filter(x -> ap.has(ParentProperty.class, (MethodInfo)x, new AnnotationTraversal[0]) && x.hasNumParameters(0) && !x.getReturnType().is(Void.TYPE)).findFirst()).isPresent()) {
            builder.getter(getterMethod.get().accessible());
        }
        if (setterMethod.isEmpty() && getterMethod.isEmpty()) {
            return null;
        }
        return builder.build();
    }

    private ConstructorInfo findStringConstructor() {
        if (this.is(Object.class) || this.isAbstract()) {
            return null;
        }
        if (this.implClass.isPresent()) {
            return ((ClassInfoTyped)this.implClass.get()).getPublicConstructor(x -> x.hasParameterTypes(String.class)).orElse(null);
        }
        if (this.isAbstract()) {
            return null;
        }
        int numParams = this.isMemberClass() && this.isNotStatic() ? 2 : 1;
        return this.getPublicConstructors().stream().filter(x -> x.isPublic() && x.isNotDeprecated() && x.hasNumParameters(numParams)).filter(x -> x.getParameter(numParams == 2 ? 1 : 0).isType(String.class)).findFirst().orElse(null);
    }

    protected ObjectSwap<?, ?> getChildObjectSwapForSwap(Class<?> normalClass) {
        return this.childSwapMap.get(normalClass);
    }

    protected ObjectSwap<?, ?> getChildObjectSwapForUnswap(Class<?> swapClass) {
        return this.childUnswapMap.get(swapClass);
    }

    protected boolean hasChildSwaps() {
        return !this.childSwaps.get().isEmpty();
    }

    protected StringBuilder toString(StringBuilder sb, boolean simple) {
        String n;
        String string = n = simple ? Utils.cnsq(this.inner()) : Utils.cn(this.inner());
        if (this.cat.is(Category.ARRAY)) {
            return this.elementType.get().toString(sb, simple).append('[').append(']');
        }
        if (this.cat.is(Category.BEANMAP)) {
            return sb.append(Utils.cn(BeanMap.class)).append('<').append(n).append('>');
        }
        if (this.cat.is(Category.MAP)) {
            KeyValueTypes kvTypes = this.keyValueTypes.get();
            Optional<ClassMeta<?>> kt = kvTypes.optKeyType();
            Optional<ClassMeta<?>> vt = kvTypes.optValueType();
            if (kt.isPresent() && vt.isPresent() && kt.get().isObject() && vt.get().isObject()) {
                return sb.append(n);
            }
            return sb.append(n).append('<').append(kt.map(x -> x.toString(simple)).orElse("?")).append(',').append(vt.map(x -> x.toString(simple)).orElse("?")).append('>');
        }
        if (this.cat.is(Category.COLLECTION) || this.is(Optional.class)) {
            ClassMeta<?> et = this.elementType.get();
            return sb.append(n).append((String)(et != null && et.isObject() ? "" : "<" + (et == null ? "?" : et.toString(simple)) + ">"));
        }
        return sb.append(n);
    }

    private static class Categories {
        int bits;

        private Categories() {
        }

        public boolean same(Categories cat) {
            return cat.bits == this.bits;
        }

        boolean is(Category c) {
            return (this.bits & c.mask) != 0;
        }

        boolean isUnknown() {
            return this.bits == 0;
        }

        Categories set(Category c) {
            this.bits |= c.mask;
            return this;
        }
    }

    static enum Category {
        MAP(0),
        COLLECTION(1),
        NUMBER(2),
        DECIMAL(3),
        DATE(4),
        ARRAY(5),
        ENUM(6),
        CHARSEQ(8),
        STR(9),
        URI(10),
        BEANMAP(11),
        READER(12),
        INPUTSTREAM(13),
        ARGS(14),
        CALENDAR(15),
        TEMPORAL(16),
        LIST(17),
        SET(18),
        DELEGATE(19),
        BEAN(20);

        private final int mask;

        private Category(int bitPosition) {
            this.mask = 1 << bitPosition;
        }
    }

    private record KeyValueTypes(ClassMeta<?> keyType, ClassMeta<?> valueType) {
        Optional<ClassMeta<?>> optKeyType() {
            return Utils.opt(this.keyType());
        }

        Optional<ClassMeta<?>> optValueType() {
            return Utils.opt(this.valueType());
        }
    }
}

