/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.internal.hppc.LongArrayList;
import org.apache.lucene.search.BitSetDocIdStream;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PriorityQueue;

final class BooleanScorer
extends BulkScorer {
    static final int SHIFT = 12;
    static final int SIZE = 4096;
    static final int MASK = 4095;
    final Bucket[] buckets;
    final FixedBitSet matching = new FixedBitSet(4096);
    final DisiWrapper[] leads;
    final HeadPriorityQueue head;
    final TailPriorityQueue tail;
    final SimpleScorable score = new SimpleScorable();
    final int minShouldMatch;
    final long cost;
    final boolean needsScores;
    private final DocAndFloatFeatureBuffer docAndScoreBuffer = new DocAndFloatFeatureBuffer();

    BooleanScorer(Collection<Scorer> scorers, int minShouldMatch, boolean needsScores) {
        if (minShouldMatch < 1 || minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be within 1..num_scorers. Got " + minShouldMatch);
        }
        if (scorers.size() <= 1) {
            throw new IllegalArgumentException("This scorer can only be used with two scorers or more, got " + scorers.size());
        }
        if (needsScores || minShouldMatch > 1) {
            this.buckets = new Bucket[4096];
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Bucket();
            }
        } else {
            this.buckets = null;
        }
        this.leads = new DisiWrapper[scorers.size()];
        this.head = new HeadPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new TailPriorityQueue(minShouldMatch - 1);
        this.minShouldMatch = minShouldMatch;
        this.needsScores = needsScores;
        LongArrayList costs = new LongArrayList(scorers.size());
        for (Scorer scorer : scorers) {
            DisiWrapper w = new DisiWrapper(scorer, false);
            costs.add(w.cost);
            DisiWrapper evicted = this.tail.insertWithOverflow(w);
            if (evicted == null) continue;
            this.head.add(evicted);
        }
        this.cost = ScorerUtil.costWithMinShouldMatch(costs.stream(), costs.size(), minShouldMatch);
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private void scoreWindowIntoBitSetAndReplay(LeafCollector collector, Bits acceptDocs, int base, int min2, int max2, DisiWrapper[] scorers, int numScorers) throws IOException {
        for (int i = 0; i < numScorers; ++i) {
            DisiWrapper w = scorers[i];
            assert (w.doc < max2);
            DocIdSetIterator it = w.iterator;
            if (w.doc < min2) {
                it.advance(min2);
            }
            if (this.buckets == null) {
                it.intoBitSet(max2, this.matching, base);
            } else if (this.needsScores) {
                w.scorer.nextDocsAndScores(max2, acceptDocs, this.docAndScoreBuffer);
                while (this.docAndScoreBuffer.size > 0) {
                    for (int index = 0; index < this.docAndScoreBuffer.size; ++index) {
                        int doc = this.docAndScoreBuffer.docs[index];
                        float score = this.docAndScoreBuffer.features[index];
                        int d = doc & 0xFFF;
                        this.matching.set(d);
                        Bucket bucket = this.buckets[d];
                        ++bucket.freq;
                        bucket.score += (double)score;
                    }
                    w.scorer.nextDocsAndScores(max2, acceptDocs, this.docAndScoreBuffer);
                }
            } else {
                assert (this.minShouldMatch > 1);
                int doc = it.docID();
                while (doc < max2) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        int d = doc & 0xFFF;
                        this.matching.set(d);
                        Bucket bucket = this.buckets[d];
                        ++bucket.freq;
                    }
                    doc = it.nextDoc();
                }
            }
            w.doc = it.docID();
        }
        if (this.buckets == null) {
            if (acceptDocs != null) {
                acceptDocs.applyMask(this.matching, base);
            }
            collector.collect(new BitSetDocIdStream(this.matching, base));
        } else {
            FixedBitSet matching = this.matching;
            Bucket[] buckets = this.buckets;
            long[] bitArray = matching.getBits();
            for (int idx = 0; idx < bitArray.length; ++idx) {
                int ntz;
                for (long bits = bitArray[idx]; bits != 0L; bits ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(bits);
                    int indexInWindow = idx << 6 | ntz;
                    Bucket bucket = buckets[indexInWindow];
                    if (bucket.freq >= this.minShouldMatch) {
                        this.score.score = (float)bucket.score;
                        collector.collect(base | indexInWindow);
                    }
                    bucket.freq = 0;
                    bucket.score = 0.0;
                }
            }
        }
        this.matching.clear();
    }

    private DisiWrapper advance(int min2) throws IOException {
        assert (this.tail.size() == this.minShouldMatch - 1);
        HeadPriorityQueue head = this.head;
        TailPriorityQueue tail = this.tail;
        DisiWrapper headTop = (DisiWrapper)head.top();
        DisiWrapper tailTop = (DisiWrapper)tail.top();
        while (headTop.doc < min2) {
            if (tailTop == null || headTop.cost <= tailTop.cost) {
                headTop.doc = headTop.iterator.advance(min2);
                headTop = (DisiWrapper)head.updateTop();
                continue;
            }
            DisiWrapper previousHeadTop = headTop;
            tailTop.doc = tailTop.iterator.advance(min2);
            headTop = head.updateTop(tailTop);
            tailTop = tail.updateTop(previousHeadTop);
        }
        return headTop;
    }

    private void scoreWindowMultipleScorers(LeafCollector collector, Bits acceptDocs, int windowBase, int windowMin, int windowMax, int maxFreq) throws IOException {
        while (maxFreq < this.minShouldMatch && maxFreq + this.tail.size() >= this.minShouldMatch) {
            DisiWrapper candidate = (DisiWrapper)this.tail.pop();
            if (candidate.doc < windowMin) {
                candidate.doc = candidate.iterator.advance(windowMin);
            }
            if (candidate.doc < windowMax) {
                this.leads[maxFreq++] = candidate;
                continue;
            }
            this.head.add(candidate);
        }
        if (maxFreq >= this.minShouldMatch) {
            for (int i = 0; i < this.tail.size(); ++i) {
                this.leads[maxFreq++] = this.tail.get(i);
            }
            this.tail.clear();
            this.scoreWindowIntoBitSetAndReplay(collector, acceptDocs, windowBase, windowMin, windowMax, this.leads, maxFreq);
        }
        for (int i = 0; i < maxFreq; ++i) {
            DisiWrapper evicted = this.head.insertWithOverflow(this.leads[i]);
            if (evicted == null) continue;
            this.tail.add(evicted);
        }
    }

    private void scoreWindowSingleScorer(DisiWrapper w, LeafCollector collector, Bits acceptDocs, int windowMin, int windowMax, int max2) throws IOException {
        assert (this.tail.size() == 0);
        int nextWindowBase = ((DisiWrapper)this.head.top()).doc & 0xFFFFF000;
        int end = Math.max(windowMax, Math.min(max2, nextWindowBase));
        DocIdSetIterator it = w.iterator;
        int doc = w.doc;
        if (doc < windowMin) {
            doc = it.advance(windowMin);
        }
        collector.setScorer(w.scorer);
        while (doc < end) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                collector.collect(doc);
            }
            doc = it.nextDoc();
        }
        w.doc = doc;
        collector.setScorer(this.score);
    }

    private DisiWrapper scoreWindow(DisiWrapper top, LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        int windowBase = top.doc & 0xFFFFF000;
        int windowMin = Math.max(min2, windowBase);
        int windowMax = Math.min(max2, windowBase + 4096);
        this.leads[0] = (DisiWrapper)this.head.pop();
        int maxFreq = 1;
        while (this.head.size() > 0 && ((DisiWrapper)this.head.top()).doc < windowMax) {
            this.leads[maxFreq++] = (DisiWrapper)this.head.pop();
        }
        if (this.minShouldMatch == 1 && maxFreq == 1) {
            DisiWrapper bulkScorer = this.leads[0];
            this.scoreWindowSingleScorer(bulkScorer, collector, acceptDocs, windowMin, windowMax, max2);
            return this.head.add(bulkScorer);
        }
        this.scoreWindowMultipleScorers(collector, acceptDocs, windowBase, windowMin, windowMax, maxFreq);
        return (DisiWrapper)this.head.top();
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        collector.setScorer(this.score);
        DisiWrapper top = this.advance(min2);
        while (top.doc < max2) {
            top = this.scoreWindow(top, collector, acceptDocs, min2, max2);
        }
        return top.doc;
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }

    static final class HeadPriorityQueue
    extends PriorityQueue<DisiWrapper> {
        public HeadPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(DisiWrapper a, DisiWrapper b) {
            return a.doc < b.doc;
        }
    }

    static final class TailPriorityQueue
    extends PriorityQueue<DisiWrapper> {
        public TailPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(DisiWrapper a, DisiWrapper b) {
            return a.cost < b.cost;
        }

        public DisiWrapper get(int i) {
            Objects.checkIndex(i, this.size());
            return (DisiWrapper)this.getHeapArray()[1 + i];
        }
    }
}

