/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.XSDNumUtils;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdType;
import org.apache.jena.tdb2.store.value.DateTimeNode;
import org.apache.jena.tdb2.store.value.DecimalNode56;
import org.apache.jena.tdb2.store.value.DoubleNode62;
import org.apache.jena.tdb2.store.value.FloatNode;
import org.apache.jena.tdb2.store.value.IntegerNode;

public class NodeIdInline {
    private static Set<RDFDatatype> datatypes = new HashSet<RDFDatatype>();
    private static BidiMap<NodeIdType, RDFDatatype> derivedTypeMap;

    public static NodeId inline(Node node) {
        if (node == null) {
            Log.warn(NodeId.class, "Null node: " + String.valueOf(node));
            return null;
        }
        if (!NodeId.enableInlineLiterals) {
            return null;
        }
        if (!node.isLiteral()) {
            return null;
        }
        if (NodeUtils.isSimpleString(node) || NodeUtils.isLangString(node)) {
            return null;
        }
        try {
            return NodeIdInline.inline$(node);
        }
        catch (Throwable th) {
            Log.warn(NodeId.class, "Failed to process " + String.valueOf(node));
            return null;
        }
    }

    public static boolean hasInlineDatatype(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        RDFDatatype dtn = node.getLiteralDatatype();
        return datatypes.contains(dtn);
    }

    private static NodeId inline$(Node node) {
        if (!NodeIdInline.hasInlineDatatype(node)) {
            return null;
        }
        LiteralLabel lit = node.getLiteral();
        if (node.getLiteralDatatype().equals(XSDDatatype.XSDdecimal)) {
            if (!XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                return null;
            }
            BigDecimal decimal = new BigDecimal(lit.getLexicalForm().trim());
            DecimalNode56 dn = DecimalNode56.valueOf(decimal = XSDNumUtils.canonicalDecimal(decimal));
            if (dn != null) {
                return NodeId.createRaw(NodeIdType.XSD_DECIMAL, dn.pack());
            }
            return null;
        }
        if (XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            if (lit.getLexicalForm().length() > 19) {
                return null;
            }
            NodeIdType type = derivedTypeMap.inverseBidiMap().getOrDefault(lit.getDatatype(), NodeIdType.XSD_INTEGER);
            try {
                long v = ((Number)lit.getValue()).longValue();
                v = IntegerNode.pack56(v);
                if (v == -1L) {
                    return null;
                }
                return NodeId.createRaw(type, v);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        if (XSDDatatype.XSDdouble.isValidLiteral(lit)) {
            double d = ((Number)lit.getValue()).doubleValue();
            long v = DoubleNode62.pack(d);
            if (v == -72057594037927936L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DOUBLE, v);
        }
        if (XSDDatatype.XSDfloat.isValidLiteral(lit)) {
            float f = ((Number)lit.getValue()).floatValue();
            long v = FloatNode.pack(f);
            return NodeId.createRaw(NodeIdType.XSD_FLOAT, v);
        }
        if (lit.getDatatype().equals(XSDDatatype.XSDdateTimeStamp) && XSDDatatype.XSDdateTimeStamp.isValidLiteral(lit)) {
            long v = DateTimeNode.packDateTime(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DATETIMESTAMP, v);
        }
        if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
            long v = DateTimeNode.packDateTime(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DATETIME, v);
        }
        if (XSDDatatype.XSDdate.isValidLiteral(lit)) {
            long v = DateTimeNode.packDate(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            return NodeId.createRaw(NodeIdType.XSD_DATE, v);
        }
        if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
            long v = 0L;
            boolean b = (Boolean)lit.getValue();
            if (b) {
                v |= 1L;
            }
            return NodeId.createRaw(NodeIdType.XSD_BOOLEAN, v);
        }
        return null;
    }

    public static Node extract(NodeId nodeId) {
        if (nodeId == NodeId.NodeDoesNotExist) {
            return null;
        }
        NodeIdType type = nodeId.type();
        if (type == NodeIdType.PTR || type == NodeIdType.SPECIAL) {
            return null;
        }
        switch (type) {
            case XSD_INTEGER: 
            case XSD_POSITIVE_INTEGER: 
            case XSD_NEGATIVE_INTEGER: 
            case XSD_NON_NEGATIVE_INTEGER: 
            case XSD_NON_POSITIVE_INTEGER: 
            case XSD_LONG: 
            case XSD_INT: 
            case XSD_SHORT: 
            case XSD_BYTE: 
            case XSD_UNSIGNEDLONG: 
            case XSD_UNSIGNEDINT: 
            case XSD_UNSIGNEDSHORT: 
            case XSD_UNSIGNEDBYTE: {
                long val = IntegerNode.unpack56(nodeId.value2);
                RDFDatatype dt = derivedTypeMap.getOrDefault((Object)type, XSDDatatype.XSDinteger);
                Node n = NodeFactory.createLiteralDT(Long.toString(val), dt);
                return n;
            }
            case XSD_DECIMAL: {
                BigDecimal decimal = DecimalNode56.unpackAsBigDecimal(nodeId.value2);
                String x = XSDNumUtils.stringForm(decimal);
                return NodeFactory.createLiteralDT(x, XSDDatatype.XSDdecimal);
            }
            case XSD_DOUBLE: {
                double d = DoubleNode62.unpack(nodeId.value2);
                String xsdStr = XSDNumUtils.stringForm(d);
                Node n = NodeFactory.createLiteralDT(xsdStr, XSDDatatype.XSDdouble);
                return n;
            }
            case XSD_FLOAT: {
                float f = FloatNode.unpack(nodeId.value2);
                String xsdStr = XSDNumUtils.stringForm(f);
                Node n = NodeFactory.createLiteralDT(xsdStr, XSDDatatype.XSDfloat);
                return n;
            }
            case XSD_DATETIMESTAMP: 
            case XSD_DATETIME: {
                XSDDatatype dt = type == NodeIdType.XSD_DATETIMESTAMP ? XSDDatatype.XSDdateTimeStamp : XSDDatatype.XSDdateTime;
                long val = nodeId.getValue2();
                String lex = DateTimeNode.unpackDateTime(val);
                return NodeFactory.createLiteralDT(lex, dt);
            }
            case XSD_DATE: {
                long val = nodeId.getValue2();
                String lex = DateTimeNode.unpackDate(val);
                return NodeFactory.createLiteralDT(lex, XSDDatatype.XSDdate);
            }
            case XSD_BOOLEAN: {
                long val = nodeId.getValue2();
                if (val == 0L) {
                    return NodeConst.nodeFalse;
                }
                if (val == 1L) {
                    return NodeConst.nodeTrue;
                }
                throw new TDBException("Unrecognized boolean node id : " + val);
            }
        }
        throw new TDBException("Unrecognized node id type: " + String.valueOf((Object)type));
    }

    static {
        datatypes.add(XSDDatatype.XSDdecimal);
        datatypes.add(XSDDatatype.XSDinteger);
        datatypes.add(XSDDatatype.XSDdouble);
        datatypes.add(XSDDatatype.XSDfloat);
        datatypes.add(XSDDatatype.XSDlong);
        datatypes.add(XSDDatatype.XSDint);
        datatypes.add(XSDDatatype.XSDshort);
        datatypes.add(XSDDatatype.XSDbyte);
        datatypes.add(XSDDatatype.XSDpositiveInteger);
        datatypes.add(XSDDatatype.XSDnonPositiveInteger);
        datatypes.add(XSDDatatype.XSDnegativeInteger);
        datatypes.add(XSDDatatype.XSDnonNegativeInteger);
        datatypes.add(XSDDatatype.XSDunsignedLong);
        datatypes.add(XSDDatatype.XSDunsignedInt);
        datatypes.add(XSDDatatype.XSDunsignedShort);
        datatypes.add(XSDDatatype.XSDunsignedByte);
        datatypes.add(XSDDatatype.XSDdateTimeStamp);
        datatypes.add(XSDDatatype.XSDdateTime);
        datatypes.add(XSDDatatype.XSDdate);
        datatypes.add(XSDDatatype.XSDboolean);
        derivedTypeMap = new DualHashBidiMap<NodeIdType, RDFDatatype>();
        derivedTypeMap.put(NodeIdType.XSD_LONG, XSDDatatype.XSDlong);
        derivedTypeMap.put(NodeIdType.XSD_INT, XSDDatatype.XSDint);
        derivedTypeMap.put(NodeIdType.XSD_SHORT, XSDDatatype.XSDshort);
        derivedTypeMap.put(NodeIdType.XSD_BYTE, XSDDatatype.XSDbyte);
        derivedTypeMap.put(NodeIdType.XSD_POSITIVE_INTEGER, XSDDatatype.XSDpositiveInteger);
        derivedTypeMap.put(NodeIdType.XSD_NON_POSITIVE_INTEGER, XSDDatatype.XSDnonPositiveInteger);
        derivedTypeMap.put(NodeIdType.XSD_NEGATIVE_INTEGER, XSDDatatype.XSDnegativeInteger);
        derivedTypeMap.put(NodeIdType.XSD_NON_NEGATIVE_INTEGER, XSDDatatype.XSDnonNegativeInteger);
        derivedTypeMap.put(NodeIdType.XSD_UNSIGNEDLONG, XSDDatatype.XSDunsignedLong);
        derivedTypeMap.put(NodeIdType.XSD_UNSIGNEDINT, XSDDatatype.XSDunsignedInt);
        derivedTypeMap.put(NodeIdType.XSD_UNSIGNEDSHORT, XSDDatatype.XSDunsignedShort);
        derivedTypeMap.put(NodeIdType.XSD_UNSIGNEDBYTE, XSDDatatype.XSDunsignedByte);
    }
}

