/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.impl.BindingVector;
import org.apache.jena.reasoner.rulesys.impl.BindingVectorMultiSet;
import org.apache.jena.reasoner.rulesys.impl.RETENode;
import org.apache.jena.reasoner.rulesys.impl.RETERuleContext;
import org.apache.jena.reasoner.rulesys.impl.RETESinkNode;
import org.apache.jena.reasoner.rulesys.impl.RETESourceNode;

public class RETEQueue
implements RETESinkNode,
RETESourceNode {
    protected BindingVectorMultiSet queue;
    protected byte[] matchIndices;
    protected RETEQueue sibling;
    protected RETESinkNode continuation;

    public RETEQueue(byte[] matchIndices) {
        this.matchIndices = matchIndices;
        this.queue = new BindingVectorMultiSet(matchIndices);
    }

    public RETEQueue(List<? extends Byte> matchIndexList) {
        int len = matchIndexList.size();
        this.matchIndices = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.matchIndices[i] = matchIndexList.get(i);
        }
        this.queue = new BindingVectorMultiSet(this.matchIndices);
    }

    public void setSibling(RETEQueue sibling) {
        this.sibling = sibling;
    }

    @Override
    public void setContinuation(RETESinkNode continuation) {
        this.continuation = continuation;
        if (this.sibling != null) {
            this.sibling.continuation = continuation;
        }
    }

    @Override
    public void fire(BindingVector env, boolean isAdd) {
        if (isAdd) {
            this.queue.add(env);
        } else {
            this.queue.remove(env);
        }
        Node[] envNodes = env.getEnvironment();
        Iterator<BindingVector> i = this.sibling.queue.getSubSet(env);
        while (i.hasNext()) {
            Node[] candidate = i.next().getEnvironment();
            Node[] newNodes = new Node[candidate.length];
            for (int j = 0; j < candidate.length; ++j) {
                Node n = candidate[j];
                newNodes[j] = n == null ? envNodes[j] : n;
            }
            BindingVector newEnv = new BindingVector(newNodes);
            this.continuation.fire(newEnv, isAdd);
        }
    }

    @Override
    public RETENode clone(Map<RETENode, RETENode> netCopy, RETERuleContext context2) {
        RETEQueue clone = (RETEQueue)netCopy.get(this);
        if (clone == null) {
            clone = new RETEQueue(this.matchIndices);
            netCopy.put(this, clone);
            clone.setSibling((RETEQueue)this.sibling.clone(netCopy, context2));
            clone.setContinuation((RETESinkNode)this.continuation.clone(netCopy, context2));
            clone.queue.putAll(this.queue);
        }
        return clone;
    }
}

