/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.mailetcontainer.api.MatcherLoader;
import org.apache.james.mailetcontainer.impl.MailetProcessorImpl;
import org.apache.james.mailetcontainer.lib.AbstractStateCompositeProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.mailet.MailetContext;

public class CompositeProcessorImpl
extends AbstractStateCompositeProcessor {
    private final MetricFactory metricFactory;
    private final MailetContext mailetContext;
    private final MatcherLoader matcherLoader;
    private final MailetLoader mailetLoader;

    @Inject
    public CompositeProcessorImpl(MetricFactory metricFactory, MailetContext mailetContext, MatcherLoader matcherLoader, MailetLoader mailetLoader) {
        this.metricFactory = metricFactory;
        this.mailetContext = mailetContext;
        this.matcherLoader = matcherLoader;
        this.mailetLoader = mailetLoader;
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
    }

    @Override
    protected MailProcessor createMailProcessor(String name, HierarchicalConfiguration<ImmutableNode> config) throws Exception {
        MailetProcessorImpl processor = new MailetProcessorImpl(name, this.metricFactory);
        try {
            processor.setMailetContext(this.mailetContext);
            processor.setMailetLoader(this.mailetLoader);
            processor.setMatcherLoader(this.matcherLoader);
            processor.configure(config);
            processor.setRootMailProcessor(this);
            processor.init();
            return processor;
        }
        catch (Exception e) {
            processor.destroy();
            throw e;
        }
    }
}

