/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlDateTimeFormatter;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.ZonedDateTime;
import reactor.util.annotation.Nullable;

final class ZonedDateTimeCodec
extends AbstractTemporalCodec<ZonedDateTime>
implements ArrayCodecDelegate<ZonedDateTime> {
    ZonedDateTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(ZonedDateTime.class, byteBufAllocator, PostgresqlObjectId.TIMESTAMPTZ, PostgresqlObjectId.TIMESTAMPTZ_ARRAY, value -> PostgresqlDateTimeFormatter.toString(value.toOffsetDateTime()));
    }

    @Override
    ZonedDateTime doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<? extends ZonedDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, ZonedDateTime.class, ZonedDateTime::from);
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return null;
    }
}

