/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Base64PasswordEncoderOutputFormatter
extends PasswordEncoderOutputFormatter {
    @NotNull
    private static final Base64PasswordEncoderOutputFormatter INSTANCE = new Base64PasswordEncoderOutputFormatter();

    private Base64PasswordEncoderOutputFormatter() {
    }

    @NotNull
    public static Base64PasswordEncoderOutputFormatter getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public byte[] format(@NotNull byte[] unformattedData) throws LDAPException {
        return StaticUtils.getBytes(Base64.encode(unformattedData));
    }

    @Override
    @NotNull
    public byte[] unFormat(@NotNull byte[] formattedData) throws LDAPException {
        try {
            return Base64.decode(StaticUtils.toUTF8String(formattedData));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_BASE64_PW_FORMATTER_CANNOT_DECODE.get(), e);
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("Base64PasswordEncoderOutputFormatter()");
    }
}

