/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.Set;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraApplicableFlagTable;
import org.apache.james.mailbox.cassandra.table.Flag;
import reactor.core.publisher.Mono;

public class CassandraApplicableFlagDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement select;
    private final PreparedStatement update;
    private final PreparedStatement delete;

    @Inject
    public CassandraApplicableFlagDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.select = this.prepareSelect(session);
        this.delete = this.prepareDelete(session);
        this.update = this.prepareUpdate(session);
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"applicableFlag").columns(new CqlIdentifier[]{Flag.USER_FLAGS}).where((Relation)Relation.column((CqlIdentifier)CassandraApplicableFlagTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraApplicableFlagTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"applicableFlag").where((Relation)Relation.column((CqlIdentifier)CassandraApplicableFlagTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraApplicableFlagTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement prepareUpdate(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"applicableFlag").append(Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER_FLAGS)).where((Relation)Relation.column((CqlIdentifier)CassandraApplicableFlagTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraApplicableFlagTable.MAILBOX_ID)))).build());
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind(new Object[0]).setUuid(CassandraApplicableFlagTable.MAILBOX_ID, mailboxId.asUuid()));
    }

    public Mono<Flags> retrieveApplicableFlag(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind(new Object[0]).setUuid(CassandraApplicableFlagTable.MAILBOX_ID, mailboxId.asUuid())).map(FlagsExtractor::getApplicableFlags);
    }

    public Mono<Void> updateApplicableFlags(CassandraId cassandraId, Set<String> toBeAdded) {
        if (toBeAdded.isEmpty()) {
            return Mono.empty();
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.update.bind(new Object[0]).setUuid(CassandraApplicableFlagTable.MAILBOX_ID, cassandraId.asUuid())).setSet(Flag.USER_FLAGS, toBeAdded, String.class));
    }
}

