/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.dto.EventDTO;
import org.apache.james.jmap.api.filtering.RuleDTO;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.api.filtering.impl.RuleSetDefined;

public class FilteringRuleSetDefinedDTO
implements EventDTO {
    private final String type;
    private final int eventId;
    private final String aggregateId;
    private final ImmutableList<RuleDTO> rules;

    public static FilteringRuleSetDefinedDTO from(RuleSetDefined event, String type) {
        return new FilteringRuleSetDefinedDTO(type, event.eventId().serialize(), event.getAggregateId().asAggregateKey(), RuleDTO.from(event.getRules()));
    }

    public static FilteringRuleSetDefinedDTO from(RuleSetDefined event) {
        return FilteringRuleSetDefinedDTO.from(event, "filtering-rule-set-defined");
    }

    @JsonCreator
    public FilteringRuleSetDefinedDTO(@JsonProperty(value="type") String type, @JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateId") String aggregateId, @JsonProperty(value="rules") ImmutableList<RuleDTO> rules) {
        this.type = type;
        this.eventId = eventId;
        this.aggregateId = aggregateId;
        this.rules = rules;
    }

    public String getType() {
        return this.type;
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public ImmutableList<RuleDTO> getRules() {
        return this.rules;
    }

    @JsonIgnore
    public RuleSetDefined toEvent() {
        return new RuleSetDefined(FilteringAggregateId.parse(this.aggregateId), EventId.fromSerialized((int)this.eventId), RuleDTO.toRules(this.rules));
    }

    public final boolean equals(Object o) {
        if (o instanceof FilteringRuleSetDefinedDTO) {
            FilteringRuleSetDefinedDTO that = (FilteringRuleSetDefinedDTO)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.type, that.type) && Objects.equals(this.aggregateId, that.aggregateId) && Objects.equals(this.rules, that.rules);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.type, this.eventId, this.aggregateId, this.rules);
    }
}

