/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class HasChildQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    @Nullable
    private final Integer maxChildren;
    @Nullable
    private final Integer minChildren;
    private final Query query;
    @Nullable
    private final ChildScoreMode scoreMode;
    private final String type;
    public static final JsonpDeserializer<HasChildQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasChildQuery::setupHasChildQueryDeserializer);

    private HasChildQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.maxChildren = builder.maxChildren;
        this.minChildren = builder.minChildren;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.scoreMode = builder.scoreMode;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static HasChildQuery of(Function<Builder, ObjectBuilder<HasChildQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.HasChild;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final InnerHits innerHits() {
        return this.innerHits;
    }

    @Nullable
    public final Integer maxChildren() {
        return this.maxChildren;
    }

    @Nullable
    public final Integer minChildren() {
        return this.minChildren;
    }

    public final Query query() {
        return this.query;
    }

    @Nullable
    public final ChildScoreMode scoreMode() {
        return this.scoreMode;
    }

    public final String type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        if (this.maxChildren != null) {
            generator.writeKey("max_children");
            generator.write(this.maxChildren.intValue());
        }
        if (this.minChildren != null) {
            generator.writeKey("min_children");
            generator.write(this.minChildren.intValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).ignoreUnmapped(this.ignoreUnmapped).innerHits(this.innerHits).maxChildren(this.maxChildren).minChildren(this.minChildren).query(this.query).scoreMode(this.scoreMode).type(this.type);
    }

    protected static void setupHasChildQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(Builder::maxChildren, JsonpDeserializer.integerDeserializer(), "max_children");
        op.add(Builder::minChildren, JsonpDeserializer.integerDeserializer(), "min_children");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::scoreMode, ChildScoreMode._DESERIALIZER, "score_mode");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HasChildQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        @Nullable
        private Integer maxChildren;
        @Nullable
        private Integer minChildren;
        private Query query;
        @Nullable
        private ChildScoreMode scoreMode;
        private String type;

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public final Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        public final Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        public final Builder maxChildren(@Nullable Integer value) {
            this.maxChildren = value;
            return this;
        }

        public final Builder minChildren(@Nullable Integer value) {
            this.minChildren = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder scoreMode(@Nullable ChildScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HasChildQuery build() {
            this._checkSingleUse();
            return new HasChildQuery(this);
        }
    }
}

