/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.EvaluatedCondition;
import org.awaitility.core.IgnoredException;
import org.awaitility.core.StartEvaluationEvent;
import org.awaitility.core.TimeoutEvent;
import org.hamcrest.Matcher;

class ConditionEvaluationHandler<T> {
    private final Matcher<? super T> matcher;
    private final ConditionSettings settings;
    private final StopWatch watch;

    ConditionEvaluationHandler(Matcher<? super T> matcher, ConditionSettings settings) {
        this.matcher = matcher;
        this.settings = settings;
        this.watch = new StopWatch();
    }

    void handleConditionResultMismatch(String mismatchMessage, T currentConditionValue, Duration pollInterval) {
        this.doWithListener(listener -> {
            long elapsedTimeInMS = this.watch.getElapsedTimeInMS();
            long remainingTimeInMS = this.getRemainingTimeInMS(elapsedTimeInMS, this.settings.getMaxWaitTime());
            try {
                listener.conditionEvaluated(new EvaluatedCondition<Object>(mismatchMessage, this.matcher, currentConditionValue, elapsedTimeInMS, remainingTimeInMS, false, this.settings.getAlias(), pollInterval));
            }
            catch (ClassCastException e) {
                this.throwClassCastExceptionBecauseConditionEvaluationListenerCouldNotBeApplied(e, (ConditionEvaluationListener)listener);
            }
        });
    }

    void handleConditionResultMatch(String matchMessage, T currentConditionValue, Duration pollInterval) {
        this.doWithListener(listener -> {
            long elapsedTimeInMS = this.watch.getElapsedTimeInMS();
            long remainingTimeInMS = this.getRemainingTimeInMS(elapsedTimeInMS, this.settings.getMaxWaitTime());
            try {
                listener.conditionEvaluated(new EvaluatedCondition<Object>(matchMessage, this.matcher, currentConditionValue, elapsedTimeInMS, remainingTimeInMS, true, this.settings.getAlias(), pollInterval));
            }
            catch (ClassCastException e) {
                this.throwClassCastExceptionBecauseConditionEvaluationListenerCouldNotBeApplied(e, (ConditionEvaluationListener)listener);
            }
        });
    }

    private void doWithListener(Consumer<ConditionEvaluationListener<T>> consumer) {
        ConditionEvaluationListener listener = this.settings.getConditionEvaluationListener();
        if (listener == null) {
            return;
        }
        consumer.accept(listener);
    }

    private long getRemainingTimeInMS(long elapsedTimeInMS, Duration maxWaitTime) {
        return maxWaitTime == null || ChronoUnit.FOREVER.getDuration().equals(maxWaitTime) ? Long.MAX_VALUE : maxWaitTime.toMillis() - elapsedTimeInMS;
    }

    private void throwClassCastExceptionBecauseConditionEvaluationListenerCouldNotBeApplied(ClassCastException e, ConditionEvaluationListener listener) {
        throw new ClassCastException("Cannot apply condition evaluation listener " + listener.getClass().getName() + " because " + e.getMessage());
    }

    public void start() {
        ConditionEvaluationListener listener = this.settings.getConditionEvaluationListener();
        if (listener != null) {
            long elapsedTimeInMS = 0L;
            long remainingTimeInMS = this.getRemainingTimeInMS(0L, this.settings.getMaxWaitTime());
            listener.beforeEvaluation(new StartEvaluationEvent<T>("Starting evaluation", this.matcher, elapsedTimeInMS, remainingTimeInMS, this.settings.getAlias()));
        }
        this.watch.start();
    }

    public void handleTimeout(String message, boolean isConditionSatisfied) {
        ConditionEvaluationListener listener = this.settings.getConditionEvaluationListener();
        if (listener != null) {
            long elapsedTimeInMS = this.watch.getElapsedTimeInMS();
            long remainingTimeInMS = this.getRemainingTimeInMS(elapsedTimeInMS, this.settings.getMaxWaitTime());
            listener.onTimeout(new TimeoutEvent(message, elapsedTimeInMS, remainingTimeInMS, isConditionSatisfied, this.settings.getAlias()));
        }
    }

    public void handleIgnoredException(Throwable throwable) {
        ConditionEvaluationListener listener = this.settings.getConditionEvaluationListener();
        if (listener != null) {
            long elapsedTimeInMS = this.watch.getElapsedTimeInMS();
            long remainingTimeInMS = this.getRemainingTimeInMS(elapsedTimeInMS, this.settings.getMaxWaitTime());
            listener.exceptionIgnored(new IgnoredException(throwable, elapsedTimeInMS, remainingTimeInMS, this.settings.getAlias()));
        }
    }

    private static class StopWatch {
        private long startTime;

        private StopWatch() {
        }

        public void start() {
            this.startTime = System.nanoTime();
        }

        long getElapsedTimeInMS() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime);
        }
    }
}

