/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogField;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.BooleanLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.DNLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.FilterLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.FloatingPointLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.IntegerLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.JSONLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RFC3339TimestampLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.StringLogFieldSyntax;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONFormattedAccessLogFields {
    @NotNull
    private static final Map<String, LogField> DEFINED_FIELDS = new ConcurrentHashMap<String, LogField>();
    @NotNull
    private static final AtomicReference<Map<String, LogField>> READ_ONLY_DEFINED_FIELDS_REF = new AtomicReference();
    private static final int DEFAULT_MAX_CHARACTERS_PER_STRING = 2000;
    @NotNull
    private static final BooleanLogFieldSyntax BOOLEAN_SYNTAX = BooleanLogFieldSyntax.getInstance();
    @NotNull
    private static final DNLogFieldSyntax DN_SYNTAX = new DNLogFieldSyntax(2000, null, null, null);
    @NotNull
    private static final FilterLogFieldSyntax FILTER_SYNTAX = new FilterLogFieldSyntax(2000, null, null, null);
    @NotNull
    private static final FloatingPointLogFieldSyntax FLOATING_POINT_SYNTAX = FloatingPointLogFieldSyntax.getInstance();
    @NotNull
    private static final IntegerLogFieldSyntax INTEGER_SYNTAX = IntegerLogFieldSyntax.getInstance();
    @NotNull
    private static final JSONLogFieldSyntax JSON_SYNTAX = new JSONLogFieldSyntax(2000, null, null);
    @NotNull
    private static final RFC3339TimestampLogFieldSyntax RFC_3339_TIMESTAMP_SYNTAX = RFC3339TimestampLogFieldSyntax.getInstance();
    @NotNull
    private static final StringLogFieldSyntax STRING_SYNTAX = new StringLogFieldSyntax(2000);
    @NotNull
    public static final LogField ABANDON_MESSAGE_ID = JSONFormattedAccessLogFields.createField("ABANDON_MESSAGE_ID", "idToAbandon", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ADD_ATTRIBUTES = JSONFormattedAccessLogFields.createField("ADD_ATTRIBUTES", "attributes", STRING_SYNTAX);
    @NotNull
    public static final LogField ADD_ENTRY_DN = JSONFormattedAccessLogFields.createField("ADD_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField ADD_UNDELETE_FROM_DN = JSONFormattedAccessLogFields.createField("ADD_UNDELETE_FROM_DN", "undeleteFromDN", DN_SYNTAX);
    @NotNull
    public static final LogField ADDITIONAL_INFO = JSONFormattedAccessLogFields.createField("ADDITIONAL_INFO", "additionalInfo", STRING_SYNTAX);
    @NotNull
    public static final LogField ADMINISTRATIVE_OPERATION = JSONFormattedAccessLogFields.createField("ADMINISTRATIVE_OPERATION", "administrativeOperation", STRING_SYNTAX);
    @NotNull
    public static final LogField ASSURED_REPLICATION_REQUIREMENTS = JSONFormattedAccessLogFields.createField("ASSURED_REPLICATION_REQUIREMENTS", "assuredReplicationRequirements", JSON_SYNTAX);
    @NotNull
    public static final LogField ASSURED_REPLICATION_REQUIREMENTS_ALTERED_BY_REQUEST_CONTROL = JSONFormattedAccessLogFields.createField("ASSURED_REPLICATION_REQUIREMENTS_ALTERED_BY_REQUEST_CONTROL", "alteredByRequestControl", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField ASSURED_REPLICATION_REQUIREMENTS_ASSURANCE_TIMEOUT_MILLIS = JSONFormattedAccessLogFields.createField("ASSURED_REPLICATION_REQUIREMENTS_ASSURANCE_TIMEOUT_MILLIS", "assuranceTimeoutMillis", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ASSURED_REPLICATION_REQUIREMENTS_LOCAL_ASSURANCE_LEVEL = JSONFormattedAccessLogFields.createField("ASSURED_REPLICATION_REQUIREMENTS_LOCAL_ASSURANCE_LEVEL", "localAssuranceLevel", STRING_SYNTAX);
    @NotNull
    public static final LogField ASSURED_REPLICATION_REQUIREMENTS_REMOTE_ASSURANCE_LEVEL = JSONFormattedAccessLogFields.createField("ASSURED_REPLICATION_REQUIREMENTS_REMOTE_ASSURANCE_LEVEL", "remoteAssuranceLevel", STRING_SYNTAX);
    @NotNull
    public static final LogField ASSURED_REPLICATION_REQUIREMENTS_RESPONSE_DELAYED_BY_ASSURANCE = JSONFormattedAccessLogFields.createField("ASSURED_REPLICATION_REQUIREMENTS_RESPONSE_DELAYED_BY_ASSURANCE", "responseDelayedByAssurance", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField AUTHORIZATION_DN = JSONFormattedAccessLogFields.createField("AUTHORIZATION_DN", "authorizationDN", DN_SYNTAX);
    @NotNull
    public static final LogField AUTO_AUTHENTICATED_AS = JSONFormattedAccessLogFields.createField("AUTO_AUTHENTICATED_AS", "autoAuthenticatedAs", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_DN = JSONFormattedAccessLogFields.createField("BIND_AUTHENTICATION_DN", "authenticationDN", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_REASON = JSONFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_REASON", "authenticationFailureReason", JSON_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_REASON_ID = JSONFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_REASON_ID", "id", INTEGER_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_REASON_MESSAGE = JSONFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_REASON_MESSAGE", "message", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_REASON_NAME = JSONFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_REASON_NAME", "name", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_TYPE = JSONFormattedAccessLogFields.createField("BIND_AUTHENTICATION_TYPE", "authType", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHORIZATION_DN = JSONFormattedAccessLogFields.createField("BIND_AUTHORIZATION_DN", "authorizationDN", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_DN = JSONFormattedAccessLogFields.createField("BIND_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_PROTOCOL_VERSION = JSONFormattedAccessLogFields.createField("BIND_PROTOCOL_VERSION", "version", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_RETIRED_PASSWORD_USED = JSONFormattedAccessLogFields.createField("BIND_RETIRED_PASSWORD_USED", "retiredPasswordUsed", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField BIND_SASL_MECHANISM = JSONFormattedAccessLogFields.createField("BIND_SASL_MECHANISM", "saslMechanism", STRING_SYNTAX);
    @NotNull
    public static final LogField CHANGE_TO_SOFT_DELETED_ENTRY = JSONFormattedAccessLogFields.createField("CHANGE_TO_SOFT_DELETED_ENTRY", "changeToSoftDeletedEntry", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField CIPHER = JSONFormattedAccessLogFields.createField("CIPHER", "cipher", STRING_SYNTAX);
    @NotNull
    public static final LogField CLIENT_CONNECTION_POLICY = JSONFormattedAccessLogFields.createField("CLIENT_CONNECTION_POLICY", "clientConnectionPolicy", STRING_SYNTAX);
    @NotNull
    public static final LogField COMPARE_ASSERTION_VALUE = JSONFormattedAccessLogFields.createField("COMPARE_ASSERTION_VALUE", "assertionValue", STRING_SYNTAX);
    @NotNull
    public static final LogField COMPARE_ATTRIBUTE_NAME = JSONFormattedAccessLogFields.createField("COMPARE_ATTRIBUTE_NAME", "attr", STRING_SYNTAX);
    @NotNull
    public static final LogField COMPARE_ENTRY_DN = JSONFormattedAccessLogFields.createField("COMPARE_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField CONNECT_FROM_ADDRESS = JSONFormattedAccessLogFields.createField("CONNECT_FROM_ADDRESS", "fromAddress", STRING_SYNTAX);
    @NotNull
    public static final LogField CONNECT_FROM_PORT = JSONFormattedAccessLogFields.createField("CONNECT_FROM_PORT", "fromPort", INTEGER_SYNTAX);
    @NotNull
    public static final LogField CONNECT_TO_ADDRESS = JSONFormattedAccessLogFields.createField("CONNECT_TO_ADDRESS", "toAddress", STRING_SYNTAX);
    @NotNull
    public static final LogField CONNECT_TO_PORT = JSONFormattedAccessLogFields.createField("CONNECT_TO_PORT", "toPort", INTEGER_SYNTAX);
    @NotNull
    public static final LogField CONNECTION_ID = JSONFormattedAccessLogFields.createField("CONNECTION_ID", "connectionID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField DELETE_ENTRY_DN = JSONFormattedAccessLogFields.createField("DELETE_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField DELETE_SOFT_DELETED_ENTRY_DN = JSONFormattedAccessLogFields.createField("DELETE_SOFT_DELETED_ENTRY_DN", "softDeletedEntryDN", DN_SYNTAX);
    @NotNull
    public static final LogField DIAGNOSTIC_MESSAGE = JSONFormattedAccessLogFields.createField("DIAGNOSTIC_MESSAGE", "message", STRING_SYNTAX);
    @NotNull
    public static final LogField DISCONNECT_MESSAGE = JSONFormattedAccessLogFields.createField("DISCONNECT_MESSAGE", "message", STRING_SYNTAX);
    @NotNull
    public static final LogField DISCONNECT_REASON = JSONFormattedAccessLogFields.createField("DISCONNECT_REASON", "disconnectReason", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ADMIN_ACTION_MESSAGE = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_ADMIN_ACTION_MESSAGE", "adminActionRequired", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_BASE_DN = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_BASE_DN", "baseDN", DN_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ENTRIES_ADDED_TO_TARGET = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_ENTRIES_ADDED_TO_TARGET", "entriesAddedToTarget", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ENTRIES_DELETED_FROM_SOURCE = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_ENTRIES_DELETED_FROM_SOURCE", "entriesDeletedFromSource", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ENTRIES_READ_FROM_SOURCE = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_ENTRIES_READ_FROM_SOURCE", "entriesReadFromSource", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ERROR_MESSAGE = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_ERROR_MESSAGE", "errorMessage", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_OPERATION_ID = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_OPERATION_ID", "rebalancingOperationID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SIZE_LIMIT = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_SIZE_LIMIT", "sizeLimit", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_BACKEND_SET = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_BACKEND_SET", "sourceBackendSet", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_SERVER = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_SERVER", "sourceServer", JSON_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_SERVER_ADDRESS = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_SERVER_ADDRESS", "address", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_SERVER_ALTERED = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_SERVER_ALTERED", "sourceServerAltered", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_SERVER_PORT = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_SERVER_PORT", "port", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_BACKEND_SET = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_BACKEND_SET", "targetBackendSet", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_SERVER = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_SERVER", "targetServer", JSON_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_SERVER_ADDRESS = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_SERVER_ADDRESS", "address", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_SERVER_ALTERED = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_SERVER_ALTERED", "targetServerAltered", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_SERVER_PORT = JSONFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_SERVER_PORT", "port", INTEGER_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_REQUEST_OID = JSONFormattedAccessLogFields.createField("EXTENDED_REQUEST_OID", "requestOID", STRING_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_REQUEST_TYPE = JSONFormattedAccessLogFields.createField("EXTENDED_REQUEST_TYPE", "requestType", STRING_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_RESPONSE_OID = JSONFormattedAccessLogFields.createField("EXTENDED_RESPONSE_OID", "responseOID", STRING_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_RESPONSE_TYPE = JSONFormattedAccessLogFields.createField("EXTENDED_RESPONSE_TYPE", "responseType", STRING_SYNTAX);
    @NotNull
    public static final LogField INDEXES_WITH_KEYS_ACCESSED_EXCEEDING_ENTRY_LIMIT = JSONFormattedAccessLogFields.createField("INDEXES_WITH_KEYS_ACCESSED_EXCEEDING_ENTRY_LIMIT", "indexesWithKeysAccessedExceedingEntryLimit", STRING_SYNTAX);
    @NotNull
    public static final LogField INDEXES_WITH_KEYS_ACCESSED_NEAR_ENTRY_LIMIT = JSONFormattedAccessLogFields.createField("INDEXES_WITH_KEYS_ACCESSED_NEAR_ENTRY_LIMIT", "indexesWithKeysAccessedNearEntryLimit", STRING_SYNTAX);
    @NotNull
    public static final LogField INSTANCE_NAME = JSONFormattedAccessLogFields.createField("INSTANCE_NAME", "instanceName", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_REQUEST_CONTROLS = JSONFormattedAccessLogFields.createField("INTER_SERVER_REQUEST_CONTROLS", "interServerRequestControls", JSON_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_REQUEST_CONTROLS_COMPONENT_NAME = JSONFormattedAccessLogFields.createField("INTER_SERVER_REQUEST_CONTROLS_COMPONENT_NAME", "componentName", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_REQUEST_CONTROLS_OPERATION_PURPOSE = JSONFormattedAccessLogFields.createField("INTER_SERVER_REQUEST_CONTROLS_OPERATION_PURPOSE", "operationPurpose", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_REQUEST_CONTROLS_PROPERTIES = JSONFormattedAccessLogFields.createField("INTER_SERVER_REQUEST_CONTROLS_PROPERTIES", "properties", JSON_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_REQUEST_CONTROLS_PROPERTIES_NAME = JSONFormattedAccessLogFields.createField("INTER_SERVER_REQUEST_CONTROLS_PROPERTIES_NAME", "name", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_REQUEST_CONTROLS_PROPERTIES_VALUE = JSONFormattedAccessLogFields.createField("INTER_SERVER_REQUEST_CONTROLS_PROPERTIES_VALUE", "value", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL", "intermediateClientRequestControl", JSON_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_CLIENT_IDENTITY = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_CLIENT_IDENTITY", "clientIdentity", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_CLIENT_NAME = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_CLIENT_NAME", "clientName", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_REQUEST_ID = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_REQUEST_ID", "clientRequestID", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_SESSION_ID = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_SESSION_ID", "clientSessionID", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_CLIENT_ADDRESS = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_CLIENT_ADDRESS", "downstreamClientAddress", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_CLIENT_SECURE = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_CLIENT_SECURE", "downstreamClientSecure", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_REQUEST = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST_CONTROL_DOWNSTREAM_REQUEST", "downstreamRequest", JSON_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL", "intermediateClientResponseControl", JSON_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL_RESPONSE_ID = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL_RESPONSE_ID", "serverResponseID", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL_SERVER_NAME = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL_SERVER_NAME", "serverName", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL_SESSION_ID = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL_SESSION_ID", "serverSessionID", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_RESPONSE = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_RESPONSE", "upstreamResponse", JSON_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_SERVER_ADDRESS = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_SERVER_ADDRESS", "upstreamServerAddress", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_SERVER_SECURE = JSONFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_SERVER_SECURE", "upstreamServerSecure", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSE_NAME = JSONFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSE_NAME", "name", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSE_OID = JSONFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSE_OID", "oid", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSE_VALUE = JSONFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSE_VALUE", "value", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSES_RETURNED = JSONFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSES_RETURNED", "intermediateResponsesReturned", INTEGER_SYNTAX);
    @NotNull
    public static final LogField LOCAL_ASSURANCE_SATISFIED = JSONFormattedAccessLogFields.createField("LOCAL_ASSURANCE_SATISFIED", "localAssuranceSatisfied", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField LOG_TYPE = JSONFormattedAccessLogFields.createField("LOG_TYPE", "logType", STRING_SYNTAX);
    @NotNull
    public static final LogField MATCHED_DN = JSONFormattedAccessLogFields.createField("MATCHED_DN", "matchedDN", DN_SYNTAX);
    @NotNull
    public static final LogField MESSAGE_ID = JSONFormattedAccessLogFields.createField("MESSAGE_ID", "messageID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField MESSAGE_TYPE = JSONFormattedAccessLogFields.createField("MESSAGE_TYPE", "messageType", STRING_SYNTAX);
    @NotNull
    public static final LogField MISSING_PRIVILEGES = JSONFormattedAccessLogFields.createField("MISSING_PRIVILEGES", "missingPrivileges", STRING_SYNTAX);
    @NotNull
    public static final LogField MODDN_DELETE_OLD_RDN = JSONFormattedAccessLogFields.createField("MODDN_DELETE_OLD_RDN", "deleteOldRDN", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField MODDN_ENTRY_DN = JSONFormattedAccessLogFields.createField("MODDN_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField MODDN_NEW_RDN = JSONFormattedAccessLogFields.createField("MODDN_NEW_RDN", "newRDN", DN_SYNTAX);
    @NotNull
    public static final LogField MODDN_NEW_SUPERIOR_DN = JSONFormattedAccessLogFields.createField("MODDN_NEW_SUPERIOR_DN", "newSuperior", DN_SYNTAX);
    @NotNull
    public static final LogField MODIFY_ATTRIBUTES = JSONFormattedAccessLogFields.createField("MODIFY_ATTRIBUTES", "attributes", STRING_SYNTAX);
    @NotNull
    public static final LogField MODIFY_ENTRY_DN = JSONFormattedAccessLogFields.createField("MODIFY_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField OPERATION_ID = JSONFormattedAccessLogFields.createField("OPERATION_ID", "operationID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField OPERATION_PURPOSE = JSONFormattedAccessLogFields.createField("OPERATION_PURPOSE", "operationPurposeRequestControl", JSON_SYNTAX);
    @NotNull
    public static final LogField OPERATION_PURPOSE_APPLICATION_NAME = JSONFormattedAccessLogFields.createField("OPERATION_PURPOSE_APPLICATION_NAME", "applicationName", STRING_SYNTAX);
    @NotNull
    public static final LogField OPERATION_PURPOSE_APPLICATION_VERSION = JSONFormattedAccessLogFields.createField("OPERATION_PURPOSE_APPLICATION_VERSION", "applicationVersion", STRING_SYNTAX);
    @NotNull
    public static final LogField OPERATION_PURPOSE_CODE_LOCATION = JSONFormattedAccessLogFields.createField("OPERATION_PURPOSE_CODE_LOCATION", "codeLocation", STRING_SYNTAX);
    @NotNull
    public static final LogField OPERATION_PURPOSE_REQUEST_PURPOSE = JSONFormattedAccessLogFields.createField("OPERATION_PURPOSE_REQUEST_PURPOSE", "requestPurpose", STRING_SYNTAX);
    @NotNull
    public static final LogField OPERATION_TYPE = JSONFormattedAccessLogFields.createField("OPERATION_TYPE", "operationType", STRING_SYNTAX);
    @NotNull
    public static final LogField ORIGIN = JSONFormattedAccessLogFields.createField("ORIGIN", "origin", STRING_SYNTAX);
    @NotNull
    public static final LogField ORIGIN_DETAILS = JSONFormattedAccessLogFields.createField("ORIGIN_DETAILS", "originDetails", JSON_SYNTAX);
    @NotNull
    public static final LogField ORIGIN_DETAILS_NAME = JSONFormattedAccessLogFields.createField("ORIGIN_DETAILS_NAME", "name", STRING_SYNTAX);
    @NotNull
    public static final LogField ORIGIN_DETAILS_VALUE = JSONFormattedAccessLogFields.createField("ORIGIN_DETAILS_VALUE", "value", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN", "certificateChain", JSON_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_CERTIFICATE_BYTES = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_CERTIFICATE_BYTES", "certificateBytes", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_CERTIFICATE_STRING = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_CERTIFICATE_STRING", "toString", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_CERTIFICATE_TYPE = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_CERTIFICATE_TYPE", "type", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_ISSUER_SUBJECT_DN = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_ISSUER_SUBJECT_DN", "issuerSubject", DN_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_NOT_AFTER = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_NOT_AFTER", "notAfter", RFC_3339_TIMESTAMP_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_NOT_BEFORE = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_NOT_BEFORE", "notBefore", RFC_3339_TIMESTAMP_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_SERIAL_NUMBER = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_SERIAL_NUMBER", "serialNumber", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_SIGNATURE_ALGORITHM = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_SIGNATURE_ALGORITHM", "signatureAlgorithm", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_SIGNATURE_BYTES = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_SIGNATURE_BYTES", "signatureBytes", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_CHAIN_SUBJECT_DN = JSONFormattedAccessLogFields.createField("PEER_CERTIFICATE_CHAIN_SUBJECT_DN", "subject", DN_SYNTAX);
    @NotNull
    public static final LogField PRE_AUTHORIZATION_USED_PRIVILEGES = JSONFormattedAccessLogFields.createField("PRE_AUTHORIZATION_USED_PRIVILEGES", "preAuthorizationUsedPrivileges", STRING_SYNTAX);
    @NotNull
    public static final LogField PROCESSING_TIME_MILLIS = JSONFormattedAccessLogFields.createField("PROCESSING_TIME_MILLIS", "processingTimeMillis", FLOATING_POINT_SYNTAX);
    @NotNull
    public static final LogField PRODUCT_NAME = JSONFormattedAccessLogFields.createField("PRODUCT_NAME", "product", STRING_SYNTAX);
    @NotNull
    public static final LogField PROTOCOL = JSONFormattedAccessLogFields.createField("PROTOCOL", "protocol", STRING_SYNTAX);
    @NotNull
    public static final LogField REFERRAL_URLS = JSONFormattedAccessLogFields.createField("REFERRAL_URLS", "referralURLs", STRING_SYNTAX);
    @NotNull
    public static final LogField REMOTE_ASSURANCE_SATISFIED = JSONFormattedAccessLogFields.createField("REMOTE_ASSURANCE_SATISFIED", "remoteAssuranceSatisfied", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField REPLICATION_CHANGE_ID = JSONFormattedAccessLogFields.createField("REPLICATION_CHANGE_ID", "replicationChangeID", STRING_SYNTAX);
    @NotNull
    public static final LogField REQUEST_CONTROL_OIDS = JSONFormattedAccessLogFields.createField("REQUEST_CONTROL_OIDS", "requestControlOIDs", STRING_SYNTAX);
    @NotNull
    public static final LogField REQUESTER_DN = JSONFormattedAccessLogFields.createField("REQUESTER_DN", "requesterDN", DN_SYNTAX);
    @NotNull
    public static final LogField REQUESTER_IP_ADDRESS = JSONFormattedAccessLogFields.createField("REQUESTER_IP_ADDRESS", "requesterIP", STRING_SYNTAX);
    @NotNull
    public static final LogField RESPONSE_CONTROL_OIDS = JSONFormattedAccessLogFields.createField("RESPONSE_CONTROL_OIDS", "responseControlOIDs", STRING_SYNTAX);
    @NotNull
    public static final LogField RESULT_CODE_NAME = JSONFormattedAccessLogFields.createField("RESULT_CODE_NAME", "resultCodeName", STRING_SYNTAX);
    @NotNull
    public static final LogField RESULT_CODE_VALUE = JSONFormattedAccessLogFields.createField("RESULT_CODE_VALUE", "resultCode", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_BASE_DN = JSONFormattedAccessLogFields.createField("SEARCH_BASE_DN", "baseDN", DN_SYNTAX);
    @NotNull
    public static final LogField SEARCH_DEREF_POLICY = JSONFormattedAccessLogFields.createField("SEARCH_DEREF_POLICY", "dereferenceAliases", STRING_SYNTAX);
    @NotNull
    public static final LogField SEARCH_ENTRIES_RETURNED = JSONFormattedAccessLogFields.createField("SEARCH_ENTRIES_RETURNED", "entriesReturned", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_FILTER = JSONFormattedAccessLogFields.createField("SEARCH_FILTER", "filter", FILTER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_INDEXED = JSONFormattedAccessLogFields.createField("SEARCH_INDEXED", "isIndexed", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField SEARCH_REQUESTED_ATTRIBUTES = JSONFormattedAccessLogFields.createField("SEARCH_REQUESTED_ATTRIBUTES", "requestedAttributes", STRING_SYNTAX);
    @NotNull
    public static final LogField SEARCH_RESULT_ENTRY_DN = JSONFormattedAccessLogFields.createField("SEARCH_RESULT_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField SEARCH_RESULT_ENTRY_ATTRIBUTES = JSONFormattedAccessLogFields.createField("SEARCH_RESULT_ENTRY_ATTRIBUTES", "attributes", STRING_SYNTAX);
    @NotNull
    public static final LogField SEARCH_SCOPE_NAME = JSONFormattedAccessLogFields.createField("SEARCH_SCOPE_NAME", "scopeName", STRING_SYNTAX);
    @NotNull
    public static final LogField SEARCH_SCOPE_VALUE = JSONFormattedAccessLogFields.createField("SEARCH_SCOPE_VALUE", "scope", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_SIZE_LIMIT = JSONFormattedAccessLogFields.createField("SEARCH_SIZE_LIMIT", "requestedSizeLimit", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_TIME_LIMIT_SECONDS = JSONFormattedAccessLogFields.createField("SEARCH_TIME_LIMIT_SECONDS", "requestedTimeLimitSeconds", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_TYPES_ONLY = JSONFormattedAccessLogFields.createField("SEARCH_TYPES_ONLY", "typesOnly", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField SECURITY_NEGOTIATION_PROPERTIES = JSONFormattedAccessLogFields.createField("SECURITY_NEGOTIATION_PROPERTIES", "negotiationProperties", JSON_SYNTAX);
    @NotNull
    public static final LogField SECURITY_NEGOTIATION_PROPERTIES_NAME = JSONFormattedAccessLogFields.createField("SECURITY_NEGOTIATION_PROPERTIES_NAME", "name", STRING_SYNTAX);
    @NotNull
    public static final LogField SECURITY_NEGOTIATION_PROPERTIES_VALUE = JSONFormattedAccessLogFields.createField("SECURITY_NEGOTIATION_PROPERTIES_VALUE", "value", STRING_SYNTAX);
    @NotNull
    public static final LogField SERVER_ASSURANCE_RESULTS = JSONFormattedAccessLogFields.createField("SERVER_ASSURANCE_RESULTS", "serverAssuranceResults", JSON_SYNTAX);
    @NotNull
    public static final LogField SERVER_ASSURANCE_RESULTS_REPLICA_ID = JSONFormattedAccessLogFields.createField("SERVER_ASSURANCE_RESULTS_REPLICA_ID", "replicaID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SERVER_ASSURANCE_RESULTS_REPLICATION_SERVER_ID = JSONFormattedAccessLogFields.createField("SERVER_ASSURANCE_RESULTS_REPLICATION_SERVER_ID", "replicationServerID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SERVER_ASSURANCE_RESULTS_RESULT_CODE = JSONFormattedAccessLogFields.createField("SERVER_ASSURANCE_RESULTS_RESULT_CODE", "resultCode", STRING_SYNTAX);
    @NotNull
    public static final LogField SERVERS_ACCESSED = JSONFormattedAccessLogFields.createField("SERVERS_ACCESSED", "serversAccessed", STRING_SYNTAX);
    @NotNull
    public static final LogField STARTUP_ID = JSONFormattedAccessLogFields.createField("STARTUP_ID", "startupID", STRING_SYNTAX);
    @NotNull
    public static final LogField TARGET_HOST = JSONFormattedAccessLogFields.createField("TARGET_HOST", "targetHost", STRING_SYNTAX);
    @NotNull
    public static final LogField TARGET_PORT = JSONFormattedAccessLogFields.createField("TARGET_PORT", "targetPort", INTEGER_SYNTAX);
    @NotNull
    public static final LogField TARGET_PROTOCOL = JSONFormattedAccessLogFields.createField("TARGET_PROTOCOL", "targetProtocol", STRING_SYNTAX);
    @NotNull
    public static final LogField THREAD_ID = JSONFormattedAccessLogFields.createField("THREAD_ID", "threadID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField TIMESTAMP = JSONFormattedAccessLogFields.createField("TIMESTAMP", "timestamp", RFC_3339_TIMESTAMP_SYNTAX);
    @NotNull
    public static final LogField TRIGGERED_BY_CONNECTION_ID = JSONFormattedAccessLogFields.createField("TRIGGERED_BY_CONNECTION_ID", "triggeredByConnectionID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField TRIGGERED_BY_OPERATION_ID = JSONFormattedAccessLogFields.createField("TRIGGERED_BY_OPERATION_ID", "triggeredByOperationID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField UNCACHED_DATA_ACCESSED = JSONFormattedAccessLogFields.createField("UNCACHED_DATA_ACCESSED", "uncachedDataAccessed", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField USED_PRIVILEGES = JSONFormattedAccessLogFields.createField("USED_PRIVILEGES", "usedPrivileges", STRING_SYNTAX);
    @NotNull
    public static final LogField USING_ADMIN_SESSION_WORKER_THREAD = JSONFormattedAccessLogFields.createField("USING_ADMIN_SESSION_WORKER_THREAD", "usingAdminSessionWorkerThread", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField WORK_QUEUE_WAIT_TIME_MILLIS = JSONFormattedAccessLogFields.createField("WORK_QUEUE_WAIT_TIME_MILLIS", "workQueueWaitTimeMillis", INTEGER_SYNTAX);

    private JSONFormattedAccessLogFields() {
    }

    @NotNull
    private static LogField createField(@NotNull String constantName, @NotNull String fieldName, @NotNull LogFieldSyntax<?> fieldSyntax) {
        LogField field = new LogField(fieldName, constantName, fieldSyntax);
        DEFINED_FIELDS.put(constantName, field);
        return field;
    }

    @NotNull
    public static Map<String, LogField> getDefinedFields() {
        Map<String, LogField> m = READ_ONLY_DEFINED_FIELDS_REF.get();
        if (m != null) {
            return m;
        }
        m = Collections.unmodifiableMap(new TreeMap<String, LogField>(DEFINED_FIELDS));
        if (READ_ONLY_DEFINED_FIELDS_REF.compareAndSet(null, m)) {
            return m;
        }
        return READ_ONLY_DEFINED_FIELDS_REF.get();
    }

    @Nullable
    public static LogField getFieldForConstantName(@NotNull String constantName) {
        String convertedName = StaticUtils.toUpperCase(constantName).replace('-', '_');
        return DEFINED_FIELDS.get(convertedName);
    }
}

