/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;

public interface Pool<POOLABLE>
extends Disposable {
    public Mono<Integer> warmup();

    public Mono<PooledRef<POOLABLE>> acquire();

    public Mono<PooledRef<POOLABLE>> acquire(Duration var1);

    default public <V> Flux<V> withPoolable(Function<POOLABLE, Publisher<V>> scopeFunction) {
        return Flux.usingWhen(this.acquire(), slot -> {
            Object poolable = slot.poolable();
            if (poolable == null) {
                return Mono.empty();
            }
            return (Publisher)scopeFunction.apply(poolable);
        }, PooledRef::release, (ref, error) -> ref.release(), PooledRef::release);
    }

    public PoolConfig<POOLABLE> config();

    default public void dispose() {
        this.disposeLater().subscribe();
    }

    public Mono<Void> disposeLater();
}

