/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.json.impl.JsonArrayImpl;
import org.apache.activemq.artemis.json.impl.JsonObjectBuilderImpl;
import org.apache.activemq.artemis.json.impl.JsonValueImpl;
import org.apache.activemq.artemis.utils.Preconditions;

public class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private final org.apache.activemq.artemis.commons.shaded.json.JsonArrayBuilder rawArrayBuilder;

    public org.apache.activemq.artemis.commons.shaded.json.JsonArrayBuilder getRawArrayBuilder() {
        return this.rawArrayBuilder;
    }

    public JsonArrayBuilderImpl(org.apache.activemq.artemis.commons.shaded.json.JsonArrayBuilder rawArrayBuilder) {
        Preconditions.checkNotNull(rawArrayBuilder);
        this.rawArrayBuilder = rawArrayBuilder;
    }

    @Override
    public JsonArrayBuilder add(JsonValue value) {
        if (!(value instanceof JsonValueImpl)) {
            throw new UnsupportedOperationException();
        }
        this.rawArrayBuilder.add(((JsonValueImpl)value).getRawValue());
        return this;
    }

    @Override
    public JsonArrayBuilder add(String value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(int value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(long value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(double value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean value) {
        this.rawArrayBuilder.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.rawArrayBuilder.addNull();
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        if (!(builder instanceof JsonObjectBuilderImpl)) {
            throw new UnsupportedOperationException();
        }
        this.rawArrayBuilder.add(((JsonObjectBuilderImpl)builder).getRawObjectBuilder());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        if (!(builder instanceof JsonArrayBuilderImpl)) {
            throw new UnsupportedOperationException();
        }
        this.rawArrayBuilder.add(((JsonArrayBuilderImpl)builder).getRawArrayBuilder());
        return this;
    }

    @Override
    public JsonArrayBuilder remove(int index) {
        this.rawArrayBuilder.remove(index);
        return this;
    }

    @Override
    public JsonArray build() {
        return new JsonArrayImpl(this.rawArrayBuilder.build());
    }
}

