/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class Offset {
    private final int value;

    public static Offset of(int value) {
        return new Offset(value);
    }

    public static Offset none() {
        return new Offset(0);
    }

    private Offset(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"An offset can not be negative");
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Offset) {
            Offset offset = (Offset)o;
            return Objects.equals(this.value, offset.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }
}

