/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.type.Type;

public class MapTableFunctionHandle
implements TableFunctionHandle {
    private static final Set<Class<?>> SUPPORT_VALUE_TYPE = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Double.class, Float.class, String.class, Boolean.class));
    private final Map<String, Object> map = new HashMap<String, Object>();

    public void addProperty(String key, Object value) {
        if (!SUPPORT_VALUE_TYPE.contains(value.getClass())) {
            throw new IllegalArgumentException("Unsupported value type.");
        }
        this.map.put(key, value);
    }

    public Object getProperty(String key) {
        return this.map.get(key);
    }

    @Override
    public byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateSerializeSize());
        buffer.putInt(this.map.size());
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            byte[] bytes = entry.getKey().getBytes(StandardCharsets.UTF_8);
            buffer.putInt(bytes.length);
            buffer.put(bytes);
            if (entry.getValue() instanceof Long) {
                buffer.put(Type.INT64.getType());
                buffer.putLong((Long)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                buffer.put(Type.INT32.getType());
                buffer.putInt((Integer)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Double) {
                buffer.put(Type.DOUBLE.getType());
                buffer.putDouble((Double)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Float) {
                buffer.put(Type.FLOAT.getType());
                buffer.putFloat(((Float)entry.getValue()).floatValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                buffer.put(Type.BOOLEAN.getType());
                buffer.put(Boolean.TRUE.equals(entry.getValue()) ? (byte)1 : 0);
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            buffer.put(Type.STRING.getType());
            bytes = ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8);
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        }
        return buffer.array();
    }

    private int calculateSerializeSize() {
        int size = 32;
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            size += 4 + entry.getKey().getBytes(StandardCharsets.UTF_8).length + 1;
            if (entry.getValue() instanceof Long) {
                size += 8;
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                size += 4;
                continue;
            }
            if (entry.getValue() instanceof Double) {
                size += 8;
                continue;
            }
            if (entry.getValue() instanceof Float) {
                size += 4;
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                ++size;
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            byte[] bytes = ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8);
            size += 4 + bytes.length;
        }
        return size;
    }

    @Override
    public void deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int size = buffer.getInt();
        block8: for (int i = 0; i < size; ++i) {
            byte[] b = new byte[buffer.getInt()];
            buffer.get(b);
            String key = new String(b, StandardCharsets.UTF_8);
            Type type = Type.valueOf(buffer.get());
            switch (type) {
                case BOOLEAN: {
                    this.map.put(key, buffer.get() != 0);
                    continue block8;
                }
                case INT32: {
                    this.map.put(key, buffer.getInt());
                    continue block8;
                }
                case INT64: {
                    this.map.put(key, buffer.getLong());
                    continue block8;
                }
                case FLOAT: {
                    this.map.put(key, Float.valueOf(buffer.getFloat()));
                    continue block8;
                }
                case DOUBLE: {
                    this.map.put(key, buffer.getDouble());
                    continue block8;
                }
                case STRING: {
                    b = new byte[buffer.getInt()];
                    buffer.get(b);
                    this.map.put(key, new String(b, StandardCharsets.UTF_8));
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapTableFunctionHandle{");
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapTableFunctionHandle handle = (MapTableFunctionHandle)o;
        return Objects.equals(this.map, handle.map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public static class Builder {
        private final Map<String, Object> map = new HashMap<String, Object>();

        public Builder addProperty(String key, Object value) {
            if (!SUPPORT_VALUE_TYPE.contains(value.getClass())) {
                throw new IllegalArgumentException("Unsupported value type.");
            }
            this.map.put(key, value);
            return this;
        }

        public MapTableFunctionHandle build() {
            MapTableFunctionHandle handle = new MapTableFunctionHandle();
            handle.map.putAll(this.map);
            return handle;
        }
    }
}

