/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.flush;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManagerMBean;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManagerMetrics;
import org.apache.iotdb.db.storageengine.dataregion.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushManager
implements FlushManagerMBean,
IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushManager.class);
    private FlushTaskPoolManager flushPool = FlushTaskPoolManager.getInstance();

    public void start() throws StartupException {
        FlushSubTaskPoolManager.getInstance().start();
        this.flushPool.start();
        try {
            JMXService.registerMBean((Object)this, (String)ServiceType.FLUSH_SERVICE.getJmxName());
            MetricService.getInstance().addMetricSet((IMetricSet)new FlushManagerMetrics(this));
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    public void stop() {
        FlushSubTaskPoolManager.getInstance().stop();
        FlushTaskPoolManager.getInstance().stop();
        JMXService.deregisterMBean((String)ServiceType.FLUSH_SERVICE.getJmxName());
    }

    public ServiceType getID() {
        return ServiceType.FLUSH_SERVICE;
    }

    @Override
    public int getNumberOfWaitingTasks() {
        return this.flushPool.getWaitingTasksNumber();
    }

    @Override
    public int getNumberOfWorkingTasks() {
        return this.flushPool.getWorkingTasksNumber();
    }

    @Override
    public int getNumberOfPendingTasks() {
        return this.flushPool.getWaitingTasksNumber();
    }

    @Override
    public int getNumberOfWorkingSubTasks() {
        return FlushSubTaskPoolManager.getInstance().getWorkingTasksNumber();
    }

    @Override
    public int getNumberOfPendingSubTasks() {
        return FlushSubTaskPoolManager.getInstance().getWaitingTasksNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> registerTsFileProcessor(TsFileProcessor tsFileProcessor) {
        TsFileProcessor tsFileProcessor2 = tsFileProcessor;
        synchronized (tsFileProcessor2) {
            if (tsFileProcessor.isManagedByFlushManager()) {
                return CompletableFuture.completedFuture(null);
            }
            if (tsFileProcessor.getFlushingMemTableSize() > 0) {
                tsFileProcessor.setManagedByFlushManager(true);
                return this.flushPool.submit((Runnable)((Object)new FlushThread(tsFileProcessor)));
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private FlushManager() {
    }

    public static FlushManager getInstance() {
        return InstanceHolder.instance;
    }

    public String toString() {
        return String.format("FlushTaskPool size %d + %d,", this.flushPool.getWorkingTasksNumber(), this.flushPool.getWaitingTasksNumber());
    }

    class FlushThread
    extends WrappedRunnable {
        TsFileProcessor tsFileProcessor;

        FlushThread(TsFileProcessor tsFileProcessor) {
            this.tsFileProcessor = tsFileProcessor;
        }

        public void runMayThrow() {
            if (null == this.tsFileProcessor) {
                return;
            }
            while (this.tsFileProcessor.getFlushingMemTableSize() > 0) {
                this.tsFileProcessor.flushOneMemTable();
            }
            this.tsFileProcessor.setManagedByFlushManager(false);
        }
    }

    private static class InstanceHolder {
        private static FlushManager instance = new FlushManager();

        private InstanceHolder() {
        }
    }
}

