/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.sink.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.response.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tool.tsfile.ImportTsFileBase;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;
import org.apache.thrift.transport.TTransportException;

public class ImportTsFileRemotely
extends ImportTsFileBase {
    private static final IoTPrinter IOT_PRINTER = new IoTPrinter(System.out);
    private static final String MODS = ".mods";
    private static final String LOAD_STRATEGY = "sync";
    private static final Integer MAX_RETRY_COUNT = 3;
    private IoTDBSyncClient client;
    private static String host;
    private static String port;
    private static String username;
    private static String password;
    private static boolean validateTsFile;

    public ImportTsFileRemotely(String timePrecision) {
        this.setTimePrecision(timePrecision);
        this.initClient();
        this.sendHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTsFile() {
        block16: {
            block9: while (true) {
                try {
                    String filePath;
                    while ((filePath = ImportTsFileScanTool.pollFromQueue()) != null) {
                        File tsFile = new File(filePath);
                        try {
                            if (ImportTsFileScanTool.isContainModsFile(filePath + MODS)) {
                                this.doTransfer(tsFile, new File(filePath + MODS));
                            } else {
                                this.doTransfer(tsFile, null);
                            }
                            ImportTsFileRemotely.processSuccessFile(filePath);
                            continue block9;
                        }
                        catch (Exception e) {
                            IOT_PRINTER.println("Connect is abort, try to reconnect, max retry count: " + MAX_RETRY_COUNT);
                            boolean isReconnectAndLoadSuccessFul = false;
                            for (int i = 1; i <= MAX_RETRY_COUNT; ++i) {
                                try {
                                    IOT_PRINTER.println(String.format("The %sth retry will after %s seconds.", i, i * 2));
                                    LockSupport.parkNanos(TimeUnit.SECONDS.toNanos((long)i * 2L));
                                    this.close();
                                    this.initClient();
                                    this.sendHandshake();
                                    if (ImportTsFileScanTool.isContainModsFile(filePath + MODS)) {
                                        this.doTransfer(tsFile, new File(filePath + MODS));
                                    } else {
                                        this.doTransfer(tsFile, null);
                                    }
                                    ImportTsFileRemotely.processSuccessFile(filePath);
                                    isReconnectAndLoadSuccessFul = true;
                                    IOT_PRINTER.println("Reconnect successful.");
                                    break;
                                }
                                catch (Exception e1) {
                                    IOT_PRINTER.println(String.format("The %sth reconnect failed", i));
                                    continue;
                                }
                            }
                            if (isReconnectAndLoadSuccessFul) continue;
                            this.processFailFile(filePath, e);
                            this.close();
                            this.initClient();
                            this.sendHandshake();
                        }
                    }
                    break block16;
                }
                catch (Exception e) {
                    IOT_PRINTER.println("Unexpected error occurred: " + e.getMessage());
                    break block16;
                }
            }
            finally {
                this.close();
            }
        }
    }

    public void sendHandshake() {
        try {
            Map<String, String> params = this.constructParamsMap();
            TPipeTransferResp resp = this.client.pipeTransfer((TPipeTransferReq)PipeTransferDataNodeHandshakeV2Req.toTPipeTransferReq(params));
            if (resp.getStatus().getCode() == TSStatusCode.PIPE_TYPE_ERROR.getStatusCode()) {
                IOT_PRINTER.println(String.format("Handshake error with target server ip: %s, port: %s, because: %s. Retry to handshake by PipeTransferHandshakeV1Req.", this.client.getIpAddress(), this.client.getPort(), resp.getStatus()));
                resp = this.client.pipeTransfer((TPipeTransferReq)PipeTransferDataNodeHandshakeV1Req.toTPipeTransferReq((String)this.getTimePrecision()));
            }
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new PipeConnectionException(String.format("Handshake error with target server ip: %s, port: %s, because: %s.", this.client.getIpAddress(), this.client.getPort(), resp.getStatus()));
            }
            this.client.setTimeout(PipeConfig.getInstance().getPipeConnectorTransferTimeoutMs());
            IOT_PRINTER.println(String.format("Handshake success. Target server ip: %s, port: %s", this.client.getIpAddress(), this.client.getPort()));
        }
        catch (Exception e) {
            throw new PipeException(String.format("Handshake error with target server ip: %s, port: %s, because: %s.", this.client.getIpAddress(), this.client.getPort(), e.getMessage()));
        }
    }

    private Map<String, String> constructParamsMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("timestampPrecision", this.getTimePrecision());
        params.put("clusterID", this.getClusterId());
        params.put("convertOnTypeMismatch", Boolean.toString(true));
        params.put("loadTsFileStrategy", LOAD_STRATEGY);
        params.put("username", username);
        params.put("password", password);
        params.put("validateTsFile", Boolean.toString(validateTsFile));
        return params;
    }

    public void doTransfer(File tsFile, File modFile) throws PipeException, IOException {
        TPipeTransferResp resp;
        PipeTransferTsFileSealReq req;
        if (Objects.nonNull(modFile)) {
            this.transferFilePieces(modFile, true);
            this.transferFilePieces(tsFile, true);
            req = PipeTransferTsFileSealWithModReq.toTPipeTransferReq((String)modFile.getName(), (long)modFile.length(), (String)tsFile.getName(), (long)tsFile.length());
        } else {
            this.transferFilePieces(tsFile, false);
            req = PipeTransferTsFileSealReq.toTPipeTransferReq((String)tsFile.getName(), (long)tsFile.length());
        }
        try {
            resp = this.client.pipeTransfer((TPipeTransferReq)req);
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Network error when seal file %s, because %s.", tsFile, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            throw new PipeConnectionException(String.format("Seal file %s error, result status %s.", tsFile, status));
        }
        IOT_PRINTER.println("Successfully transferred file " + tsFile);
    }

    private void transferFilePieces(File file, boolean isMultiFile) throws PipeException, IOException {
        block11: {
            int readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
            byte[] readBuffer = new byte[readFileBufferSize];
            long position = 0L;
            try (RandomAccessFile reader = new RandomAccessFile(file, "r");){
                TSStatus status;
                while (true) {
                    PipeTransferFilePieceResp resp;
                    int readLength;
                    if ((readLength = reader.read(readBuffer)) == -1) {
                        break block11;
                    }
                    byte[] payLoad = readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength);
                    try {
                        PipeTransferFilePieceReq req = isMultiFile ? this.getTransferMultiFilePieceReq(file.getName(), position, payLoad) : this.getTransferSingleFilePieceReq(file.getName(), position, payLoad);
                        resp = PipeTransferFilePieceResp.fromTPipeTransferResp((TPipeTransferResp)this.client.pipeTransfer((TPipeTransferReq)req));
                    }
                    catch (Exception e) {
                        throw new PipeConnectionException(String.format("Network error when transfer file %s, because %s.", file, e.getMessage()), (Throwable)e);
                    }
                    position += (long)readLength;
                    status = resp.getStatus();
                    if (status.getCode() == TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                        position = resp.getEndWritingOffset();
                        reader.seek(position);
                        IOT_PRINTER.println(String.format("Redirect file position to %s.", position));
                        continue;
                    }
                    if (status.getCode() == TSStatusCode.PIPE_CONFIG_RECEIVER_HANDSHAKE_NEEDED.getStatusCode()) {
                        this.sendHandshake();
                    }
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break;
                }
                throw new PipeException(String.format("Transfer file %s error, result status %s.", file, status));
            }
        }
    }

    private PipeTransferFilePieceReq getTransferMultiFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferTsFilePieceWithModReq.toTPipeTransferReq((String)fileName, (long)position, (byte[])payLoad);
    }

    private PipeTransferFilePieceReq getTransferSingleFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferTsFilePieceReq.toTPipeTransferReq((String)fileName, (long)position, (byte[])payLoad);
    }

    private void initClient() {
        try {
            this.client = new IoTDBSyncClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs(PipeConfig.getInstance().getPipeSinkHandshakeTimeoutMs()).setRpcThriftCompressionEnabled(PipeConfig.getInstance().isPipeConnectorRPCThriftCompressionEnabled()).build(), this.getEndPoint().getIp(), this.getEndPoint().getPort(), false, "", "");
        }
        catch (TTransportException e) {
            throw new PipeException("Sync client init error because " + e.getMessage());
        }
    }

    private TEndPoint getEndPoint() {
        return new TEndPoint(host, Integer.parseInt(port));
    }

    private String getClusterId() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return "TSFILE-IMPORTER-" + UUID.nameUUIDFromBytes(bytes);
    }

    private void close() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            IOT_PRINTER.println("Failed to close client because " + e.getMessage());
        }
    }

    public static void setHost(String host) {
        ImportTsFileRemotely.host = host;
    }

    public static void setPort(String port) {
        ImportTsFileRemotely.port = port;
    }

    public static void setUsername(String username) {
        ImportTsFileRemotely.username = username;
    }

    public static void setPassword(String password) {
        ImportTsFileRemotely.password = password;
    }

    public static void setValidateTsFile(boolean validateTsFile) {
        ImportTsFileRemotely.validateTsFile = validateTsFile;
    }

    static {
        username = "root";
        password = "root";
    }
}

