/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import ru.yandex.clickhouse.util.ClickHouseBlockChecksum;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseLZ4OutputStream
extends OutputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private final DataOutputStream dataWrapper;
    private final LZ4Compressor compressor;
    private final byte[] currentBlock;
    private final byte[] compressedBlock;
    private int pointer;

    public ClickHouseLZ4OutputStream(OutputStream stream, int maxCompressBlockSize) {
        this.dataWrapper = new DataOutputStream(stream);
        this.compressor = factory.fastCompressor();
        this.currentBlock = new byte[maxCompressBlockSize];
        this.compressedBlock = new byte[this.compressor.maxCompressedLength(maxCompressBlockSize)];
    }

    public int position() {
        return this.pointer;
    }

    @Override
    public void write(int b) throws IOException {
        this.currentBlock[this.pointer] = (byte)b;
        ++this.pointer;
        if (this.pointer == this.currentBlock.length) {
            this.writeBlock();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int blockSize = this.currentBlock.length;
        int rest = blockSize - this.pointer;
        while (len >= rest) {
            System.arraycopy(b, off, this.currentBlock, this.pointer, rest);
            this.pointer += rest;
            this.writeBlock();
            off += rest;
            len -= rest;
            rest = blockSize;
        }
        if (len > 0) {
            System.arraycopy(b, off, this.currentBlock, this.pointer, len);
            this.pointer += len;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pointer != 0) {
            this.writeBlock();
        }
        this.dataWrapper.flush();
    }

    private void writeBlock() throws IOException {
        int compressed = this.compressor.compress(this.currentBlock, 0, this.pointer, this.compressedBlock, 0);
        ClickHouseBlockChecksum checksum = ClickHouseBlockChecksum.calculateForBlock((byte)-126, compressed + 9, this.pointer, this.compressedBlock, compressed);
        this.dataWrapper.write(checksum.asBytes());
        this.dataWrapper.writeByte(130);
        Utils.writeInt(this.dataWrapper, compressed + 9);
        Utils.writeInt(this.dataWrapper, this.pointer);
        this.dataWrapper.write(this.compressedBlock, 0, compressed);
        this.pointer = 0;
    }
}

