/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.util.Objects;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.StringUtils;
import org.apache.inlong.sort.formats.base.TableFormatDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableFormatDeserializer
extends TableFormatDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTableFormatDeserializer.class);
    private final DeserializationSchema<Row> deserializationSchema;
    private final boolean ignoreErrors;

    public DefaultTableFormatDeserializer(DeserializationSchema<Row> deserializationSchema, boolean ignoreErrors) {
        this.deserializationSchema = deserializationSchema;
        this.ignoreErrors = ignoreErrors;
    }

    public DefaultTableFormatDeserializer(DeserializationSchema<Row> deserializationSchema) {
        this(deserializationSchema, false);
    }

    public TypeInformation<Row> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }

    public void flatMap(byte[] bytes, Collector<Row> collector) throws Exception {
        Row row;
        try {
            row = (Row)this.deserializationSchema.deserialize(bytes);
        }
        catch (Exception e) {
            if (this.ignoreErrors) {
                LOG.warn("Could not properly deserialize the data {}.", (Object)StringUtils.byteToHexString((byte[])bytes), (Object)e);
                return;
            }
            throw e;
        }
        if (row != null) {
            collector.collect((Object)row);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultTableFormatDeserializer that = (DefaultTableFormatDeserializer)((Object)o);
        return this.ignoreErrors == that.ignoreErrors && Objects.equals(this.deserializationSchema, that.deserializationSchema);
    }

    public int hashCode() {
        return Objects.hash(this.deserializationSchema, this.ignoreErrors);
    }

    public String toString() {
        return "DefaultTableFormatDeserializer{deserializationSchema=" + this.deserializationSchema + ", ignoreErrors=" + this.ignoreErrors + '}';
    }
}

