/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import org.apache.flume.lifecycle.LifecycleState;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneProducer;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSink;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueueZoneWorker
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueueZoneWorker.class);
    private static final LogCounter logCounter = new LogCounter(10, 100000, 30000);
    private final String workerName;
    private final long fetchWaitMs;
    private final MessageQueueZoneSink mqZoneSink;
    private final MessageQueueZoneProducer zoneProducer;
    private LifecycleState status;

    public MessageQueueZoneWorker(MessageQueueZoneSink mqZoneSink, int workerIndex, long fetchWaitMs, MessageQueueZoneProducer zoneProducer) {
        this.mqZoneSink = mqZoneSink;
        this.workerName = mqZoneSink.getCachedSinkName() + "-worker-" + workerIndex;
        this.fetchWaitMs = fetchWaitMs;
        this.zoneProducer = zoneProducer;
        this.status = LifecycleState.IDLE;
    }

    @Override
    public void start() {
        this.status = LifecycleState.START;
        super.start();
    }

    public void close() {
        this.zoneProducer.close();
        this.status = LifecycleState.STOP;
    }

    @Override
    public void run() {
        logger.info("{} start message zone worker", (Object)this.workerName);
        PackProfile profile = null;
        while (this.status != LifecycleState.STOP) {
            try {
                profile = this.mqZoneSink.takeDispatchedRecord();
                if (profile == null) {
                    this.sleepOneInterval();
                    continue;
                }
                this.zoneProducer.send(profile);
            }
            catch (Throwable e1) {
                if (profile != null) {
                    this.mqZoneSink.offerDispatchRecord(profile);
                }
                if (logCounter.shouldPrint()) {
                    logger.error("{} send message failure", (Object)this.workerName, (Object)e1);
                }
                this.sleepOneInterval();
            }
        }
        logger.info("{} exit message zone worker", (Object)this.workerName);
    }

    private void sleepOneInterval() {
        block2: {
            try {
                Thread.sleep(this.fetchWaitMs);
            }
            catch (InterruptedException e1) {
                if (!logCounter.shouldPrint()) break block2;
                logger.error("{} wait poll record interrupted", (Object)this.workerName, (Object)e1);
            }
        }
    }
}

