/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.jdbc;

import java.util.HashSet;
import java.util.Set;
import org.apache.flume.Context;
import org.apache.flume.channel.jdbc.JdbcChannelException;
import org.apache.flume.channel.jdbc.JdbcChannelProvider;
import org.apache.flume.channel.jdbc.impl.JdbcChannelProviderImpl;

public final class JdbcChannelProviderFactory {
    private static Set<String> INSTANCES = new HashSet<String>();
    private static JdbcChannelProvider PROVIDER;

    public static synchronized JdbcChannelProvider getProvider(Context context, String name) {
        if (PROVIDER == null) {
            PROVIDER = new JdbcChannelProviderImpl();
            PROVIDER.initialize(context);
        }
        if (!INSTANCES.add(name)) {
            throw new JdbcChannelException("Attempt to initialize multiple channels with same name: " + name);
        }
        return PROVIDER;
    }

    public static synchronized void releaseProvider(String name) {
        if (!INSTANCES.remove(name)) {
            throw new JdbcChannelException("Attempt to release non-existant channel: " + name);
        }
        if (INSTANCES.size() == 0) {
            PROVIDER.close();
            PROVIDER = null;
        }
    }

    private JdbcChannelProviderFactory() {
    }
}

