/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Server;

public class ResourceListingBuilder {
    private String apiVersion;
    private final List<ApiListingReference> apis = new ArrayList<ApiListingReference>();
    private final List<SecurityScheme> securitySchemes = new ArrayList<SecurityScheme>();
    private ApiInfo info;
    private final List<Server> servers = new ArrayList<Server>();

    public ResourceListingBuilder apiVersion(String apiVersion) {
        this.apiVersion = BuilderDefaults.defaultIfAbsent(apiVersion, this.apiVersion);
        return this;
    }

    public ResourceListingBuilder apis(List<ApiListingReference> apis) {
        this.apis.addAll(BuilderDefaults.nullToEmptyList(apis));
        return this;
    }

    public ResourceListingBuilder securitySchemes(List<SecurityScheme> authorizations) {
        this.securitySchemes.addAll(BuilderDefaults.nullToEmptyList(authorizations));
        return this;
    }

    public ResourceListingBuilder info(ApiInfo info) {
        this.info = BuilderDefaults.defaultIfAbsent(info, this.info);
        return this;
    }

    public ResourceListing build() {
        return new ResourceListing(this.apiVersion, this.apis, this.securitySchemes, this.info, this.servers);
    }

    public ResourceListingBuilder servers(Collection<Server> servers) {
        this.servers.addAll(BuilderDefaults.nullToEmptyList(servers));
        return this;
    }
}

