/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.Store;

public class StoreHeap
extends Store
implements Serializable {
    protected static final Fun.Tuple2 TOMBSTONE = Fun.t2(null, null);
    protected static final Object NULL = new Object();
    protected final ConcurrentNavigableMap<Long, Fun.Tuple2> records = new ConcurrentSkipListMap<Long, Fun.Tuple2>();
    protected final ConcurrentNavigableMap<Long, Fun.Tuple2> rollback = new ConcurrentSkipListMap<Long, Fun.Tuple2>();
    protected final Queue<Long> freeRecids = new ConcurrentLinkedQueue<Long>();
    protected final AtomicLong maxRecid = new AtomicLong(7L);

    public StoreHeap() {
        super(false, false, null);
        for (long recid = 1L; recid <= 7L; ++recid) {
            this.records.put(recid, Fun.t2(null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        ReentrantReadWriteLock.WriteLock lock = this.locks[new Random().nextInt(this.locks.length)].writeLock();
        lock.lock();
        try {
            Long recid = this.freeRecids.poll();
            if (recid == null) {
                recid = this.maxRecid.incrementAndGet();
            }
            long l = recid;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preallocate(long[] recids) {
        ReentrantReadWriteLock.WriteLock lock = this.locks[new Random().nextInt(this.locks.length)].writeLock();
        lock.lock();
        try {
            for (int i = 0; i < recids.length; ++i) {
                Long recid = this.freeRecids.poll();
                if (recid == null) {
                    recid = this.maxRecid.incrementAndGet();
                }
                recids[i] = recid;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (value == null) {
            value = NULL;
        }
        ReentrantReadWriteLock.WriteLock lock = this.locks[new Random().nextInt(this.locks.length)].writeLock();
        lock.lock();
        try {
            Long recid = this.freeRecids.poll();
            if (recid == null) {
                recid = this.maxRecid.incrementAndGet();
            }
            this.records.put(recid, Fun.t2(value, serializer));
            this.rollback.put(recid, Fun.t2(TOMBSTONE, serializer));
            assert (recid > 0L);
            long l = recid;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        ReentrantReadWriteLock.ReadLock lock = this.locks[Store.lockPos(recid)].readLock();
        lock.lock();
        try {
            Fun.Tuple2 t = (Fun.Tuple2)this.records.get(recid);
            if (t == null || t.a == NULL) {
                A a = null;
                return a;
            }
            Object a = t.a;
            return a;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        assert (recid > 0L);
        assert (serializer != null);
        assert (recid > 0L);
        if (value == null) {
            value = NULL;
        }
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
        lock.lock();
        try {
            Fun.Tuple2<A, Serializer<A>> old = this.records.put(recid, Fun.t2(value, serializer));
            if (old != null) {
                this.rollback.putIfAbsent(recid, old);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        assert (recid > 0L);
        if (expectedOldValue == null) {
            expectedOldValue = NULL;
        }
        if (newValue == null) {
            newValue = NULL;
        }
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
        lock.lock();
        try {
            Fun.Tuple2<A, Serializer<A>> old = Fun.t2(expectedOldValue, serializer);
            boolean ret = this.records.replace(recid, old, Fun.t2(newValue, serializer));
            if (ret) {
                this.rollback.putIfAbsent(recid, old);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
        lock.lock();
        try {
            Fun.Tuple2 t2 = (Fun.Tuple2)this.records.remove(recid);
            if (t2 != null) {
                this.rollback.putIfAbsent(recid, t2);
            }
            this.freeRecids.add(recid);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lockAllWrite();
        try {
            this.records.clear();
            this.freeRecids.clear();
            this.rollback.clear();
        }
        finally {
            this.unlockAllWrite();
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.lockAllWrite();
        try {
            this.rollback.clear();
        }
        finally {
            this.unlockAllWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.lockAllWrite();
        try {
            for (Map.Entry e : this.rollback.entrySet()) {
                Long recid = (Long)e.getKey();
                Fun.Tuple2 val = (Fun.Tuple2)e.getValue();
                if (val == TOMBSTONE) {
                    this.records.remove(recid);
                    continue;
                }
                this.records.put(recid, val);
            }
            this.rollback.clear();
        }
        finally {
            this.unlockAllWrite();
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void compact() {
    }

    @Override
    public boolean canRollback() {
        return true;
    }

    @Override
    public long getMaxRecid() {
        return this.maxRecid.get();
    }

    @Override
    public ByteBuffer getRaw(long recid) {
        Fun.Tuple2 t = (Fun.Tuple2)this.records.get(recid);
        if (t == null || t.a == null) {
            return null;
        }
        return ByteBuffer.wrap(this.serialize(t.a, (Serializer)t.b).copyBytes());
    }

    @Override
    public Iterator<Long> getFreeRecids() {
        return Collections.unmodifiableCollection(this.freeRecids).iterator();
    }

    @Override
    public void updateRaw(long recid, ByteBuffer data) {
        throw new UnsupportedOperationException("can not put raw data into StoreHeap");
    }

    @Override
    public long getSizeLimit() {
        return 0L;
    }

    @Override
    public long getCurrSize() {
        return this.records.size();
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public String calculateStatistics() {
        return null;
    }
}

