/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.util.Optional;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483148)
public class ExpandedParameterPatternAnnotationPlugin
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterPatternAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterExpansionContext context) {
        Optional pattern = context.findAnnotation(Pattern.class);
        if (pattern.isPresent()) {
            LOG.debug("@Pattern present: {}", (Object)((Pattern)pattern.get()).regexp());
            context.getParameterBuilder().pattern(((Pattern)pattern.get()).regexp());
            context.getRequestParameterBuilder().query(q -> q.stringFacet(s -> s.pattern(((Pattern)pattern.get()).regexp())));
        }
    }
}

