/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.tubemq.client.common.PeerInfo;
import org.apache.inlong.tubemq.client.consumer.FetchContext;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.rv.RetValue;

public class ConsumeResult
extends RetValue {
    private String topicName = "";
    private PeerInfo peerInfo = new PeerInfo();
    private String confirmContext = "";
    private List<Message> messageList = new ArrayList<Message>();

    public void setProcessResult(FetchContext taskContext) {
        this.setFullInfo(taskContext.isSuccess(), taskContext.getErrCode(), taskContext.getErrMsg());
        this.topicName = taskContext.getPartition().getTopic();
        this.peerInfo.setMsgSourceInfo(taskContext.getPartition(), taskContext.getCurrOffset(), taskContext.getMaxOffset());
        if (this.isSuccess()) {
            this.messageList = taskContext.getMessageList();
            this.confirmContext = taskContext.getConfirmContext();
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public String getPartitionKey() {
        return this.peerInfo.getPartitionKey();
    }

    public final String getConfirmContext() {
        return this.confirmContext;
    }

    public long getCurrOffset() {
        return this.peerInfo.getCurrOffset();
    }

    public final List<Message> getMessageList() {
        return this.messageList;
    }

    public long getMaxOffset() {
        return this.peerInfo.getMaxOffset();
    }
}

