/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.example;

import java.util.List;
import java.util.Map;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.apache.inlong.tubemq.client.producer.MessageSentCallback;
import org.apache.inlong.tubemq.client.producer.MessageSentResult;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.example.MsgSendReceiveStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageProducerExample {
    private static final Logger logger = LoggerFactory.getLogger(MessageProducerExample.class);
    private static final MsgSendReceiveStats msgSendStats = new MsgSendReceiveStats(true);
    private static MessageSessionFactory sessionFactory;
    private static MessageProducer messageProducer;

    public static void main(String[] args) throws Throwable {
        String masterServers = args[0];
        String pubTopicAndFilterItems = args[1];
        long msgCount = Long.parseLong(args[2]);
        int pkgSize = 1024;
        if (args.length > 3) {
            pkgSize = MixedUtils.mid((int)Integer.parseInt(args[3]), (int)1, (int)0x100000);
        }
        Map topicAndFiltersMap = MixedUtils.parseTopicParam((String)pubTopicAndFilterItems);
        TubeClientConfig clientConfig = new TubeClientConfig(masterServers);
        sessionFactory = new TubeSingleSessionFactory(clientConfig);
        messageProducer = sessionFactory.createProducer();
        messageProducer.publish(topicAndFiltersMap.keySet());
        Thread statisticThread = new Thread((Runnable)msgSendStats, "Sent Statistic Thread");
        statisticThread.start();
        byte[] bodyData = MixedUtils.buildTestData((int)pkgSize);
        List buildTopicFilterTuples = MixedUtils.buildTopicFilterTupleList((Map)topicAndFiltersMap);
        long sentCount = 0L;
        int roundIndex = 0;
        int targetCnt = buildTopicFilterTuples.size();
        while (msgCount < 0L || sentCount < msgCount) {
            roundIndex = (int)(sentCount++ % (long)targetCnt);
            Tuple2 target = (Tuple2)buildTopicFilterTuples.get(roundIndex);
            try {
                messageProducer.sendMessage(MixedUtils.buildMessage((String)((String)target.getF0()), (String)((String)target.getF1()), (byte[])bodyData, (long)sentCount), (MessageSentCallback)new DefaultSendCallback());
            }
            catch (InterruptedException | TubeClientException e) {
                logger.error("Send message failed!", e);
            }
            MixedUtils.coolSending((long)sentCount);
        }
        messageProducer.shutdown();
        sessionFactory.shutdown();
        msgSendStats.stopStats();
        logger.info("The message sending task has been completed!");
    }

    private static class DefaultSendCallback
    implements MessageSentCallback {
        private DefaultSendCallback() {
        }

        public void onMessageSent(MessageSentResult result) {
            if (result.isSuccess()) {
                msgSendStats.addMsgCount(result.getMessage().getTopic(), 1);
            } else {
                logger.error("Send message failed!" + result.getErrMsg());
            }
        }

        public void onException(Throwable e) {
            logger.error("Send message error!", e);
        }
    }
}

