/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.ConfigurableComponent;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.sink.SinkProcessorFactory;

public class SinkGroup
implements Configurable,
ConfigurableComponent {
    List<Sink> sinks;
    SinkProcessor processor;
    SinkGroupConfiguration conf;

    public SinkGroup(List<Sink> groupSinks) {
        this.sinks = groupSinks;
    }

    @Override
    public void configure(Context context) {
        this.conf = new SinkGroupConfiguration("sinkgrp");
        try {
            this.conf.configure(context);
        }
        catch (ConfigurationException e) {
            throw new FlumeException("Invalid Configuration!", (Throwable)e);
        }
        this.configure((ComponentConfiguration)this.conf);
    }

    public SinkProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void configure(ComponentConfiguration conf) {
        this.conf = (SinkGroupConfiguration)conf;
        this.processor = SinkProcessorFactory.getProcessor(this.conf.getProcessorContext(), this.sinks);
    }
}

