/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TCLog
implements Interceptor {
    private boolean debug;
    private Log logger = null;

    public TCLog(String name) {
        this(name, false);
    }

    public TCLog(String name, boolean isDebug) {
        this.logger = LogFactory.getLog((String)name);
        this.debug = isDebug;
    }

    public void info(String str) {
        if (this.debug) {
            this.logger.info((Object)str);
        }
    }

    public void info(String str, Throwable t) {
        if (this.debug) {
            this.logger.info((Object)str, t);
        }
    }

    public void debug(String str) {
        if (this.debug) {
            this.logger.debug((Object)str);
        }
    }

    public void debug(String str, Throwable t) {
        if (this.debug) {
            this.logger.debug((Object)str, t);
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String req = "send request, request url: " + request.url() + ". request headers information: " + request.headers().toString();
        req = req.replaceAll("\n", ";");
        this.info(req);
        Response response = chain.proceed(request);
        String resp = "recieve response, response url: " + response.request().url() + ", response headers: " + response.headers().toString() + ",response body information: " + response.body().toString();
        resp = resp.replaceAll("\n", ";");
        this.info(resp);
        return response;
    }
}

