/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network;

import java.util.concurrent.Semaphore;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.utils.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkgCacheQuota {
    private static final Logger logger = LoggerFactory.getLogger(PkgCacheQuota.class);
    public static final Tuple2<Integer, Integer> DISABLE_RET = new Tuple2<Integer, Integer>(-1, -1);
    private final boolean factoryLevel;
    private final int pkgCntPermits;
    private final int pkgSizeKbPermits;
    private final int paddingSizePerPkg;
    private final boolean disabled;
    private final Semaphore pkgCntQuota;
    private final Semaphore pkgSizeKbQuota;

    public PkgCacheQuota(boolean factoryLevel, String parentId, int pkgCntPermits, int pkgSizeKbPermits, int paddingSizePerPkg) {
        this.factoryLevel = factoryLevel;
        this.pkgCntPermits = pkgCntPermits;
        this.pkgSizeKbPermits = pkgSizeKbPermits;
        this.paddingSizePerPkg = paddingSizePerPkg;
        this.pkgCntQuota = pkgCntPermits > 0 ? new Semaphore(pkgCntPermits) : null;
        this.pkgSizeKbQuota = pkgSizeKbPermits > 0 ? new Semaphore(pkgSizeKbPermits) : null;
        this.disabled = this.pkgCntQuota == null && this.pkgSizeKbQuota == null;
        logger.info("PkgCacheQuota({}) created, factoryLevel={},pkgCnt={},pkgSizeKb={},padSize={}", new Object[]{factoryLevel, parentId, pkgCntPermits, pkgSizeKbPermits, paddingSizePerPkg});
    }

    public Tuple2<Integer, Integer> getPkgCacheAvailQuota() {
        if (this.disabled) {
            return DISABLE_RET;
        }
        int cntAvailable = -1;
        if (this.pkgCntQuota != null) {
            cntAvailable = this.pkgCntQuota.availablePermits();
        }
        int sizeAvailable = -1;
        if (this.pkgSizeKbQuota != null) {
            sizeAvailable = this.pkgSizeKbQuota.availablePermits();
        }
        return new Tuple2<Integer, Integer>(cntAvailable, sizeAvailable);
    }

    public boolean tryAcquire(int sizeInByte, ProcessResult procResult) {
        if (this.disabled) {
            return procResult.setSuccess();
        }
        if (this.pkgCntQuota == null) {
            if (this.pkgSizeKbQuota.tryAcquire(this.getSizeKbPermitsByBytes(sizeInByte))) {
                return procResult.setSuccess();
            }
            return procResult.setFailResult(this.factoryLevel ? ErrorCode.INF_REQ_SIZE_REACH_FACTORY_LIMIT : ErrorCode.INF_REQ_SIZE_REACH_SDK_LIMIT);
        }
        if (this.pkgCntQuota.tryAcquire(1)) {
            if (this.pkgSizeKbQuota == null) {
                return procResult.setSuccess();
            }
            if (this.pkgSizeKbQuota.tryAcquire(this.getSizeKbPermitsByBytes(sizeInByte))) {
                return procResult.setSuccess();
            }
            this.pkgCntQuota.release();
            return procResult.setFailResult(this.factoryLevel ? ErrorCode.INF_REQ_SIZE_REACH_FACTORY_LIMIT : ErrorCode.INF_REQ_SIZE_REACH_SDK_LIMIT);
        }
        return procResult.setFailResult(this.factoryLevel ? ErrorCode.INF_REQ_COUNT_REACH_FACTORY_LIMIT : ErrorCode.INF_REQ_COUNT_REACH_SDK_LIMIT);
    }

    public void release(int sizeInByte) {
        if (this.disabled) {
            return;
        }
        if (this.pkgCntQuota == null) {
            this.pkgSizeKbQuota.release(this.getSizeKbPermitsByBytes(sizeInByte));
        } else {
            if (this.pkgSizeKbQuota != null) {
                this.pkgSizeKbQuota.release(this.getSizeKbPermitsByBytes(sizeInByte));
            }
            this.pkgCntQuota.release();
        }
    }

    public boolean isFactoryLevel() {
        return this.factoryLevel;
    }

    public int getPkgCntPermits() {
        return this.pkgCntPermits;
    }

    public int getPkgSizeKbPermits() {
        return this.pkgSizeKbPermits;
    }

    public int getPaddingSizePerPkg() {
        return this.paddingSizePerPkg;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private int getSizeKbPermitsByBytes(int sizeInByte) {
        int tmpValue = sizeInByte + this.paddingSizePerPkg;
        if (tmpValue % 1024 == 0) {
            return tmpValue / 1024;
        }
        return tmpValue / 1024 + 1;
    }
}

