/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hudi;

import java.util.Optional;
import org.apache.inlong.manager.pojo.sink.hudi.HudiColumnInfo;
import org.apache.inlong.manager.pojo.sink.hudi.HudiType;

public class HudiTypeConverter {
    public static String convert(HudiColumnInfo column) {
        return Optional.ofNullable(column).map(col -> HudiType.forType((String)col.getType())).map(hudiType -> {
            if (HudiType.DECIMAL == hudiType) {
                return String.format("decimal(%d, %d)", column.getPrecision(), column.getScale());
            }
            if (HudiType.FIXED == hudiType) {
                return String.format("fixed(%d)", column.getLength());
            }
            return hudiType.getHiveType();
        }).orElseThrow(() -> new RuntimeException("Can not properly convert type of column: " + column));
    }
}

