/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.bounded.Boundaries;
import org.apache.inlong.common.bounded.BoundaryType;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.auth.SecretTokenAuthentication;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.consts.SinkType;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.entity.TenantClusterTagEntity;
import org.apache.inlong.manager.dao.entity.TenantUserRoleEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.TenantClusterTagEntityMapper;
import org.apache.inlong.manager.dao.mapper.TenantUserRoleEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.GroupFullInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupApproveRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupCountResponse;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicRequest;
import org.apache.inlong.manager.pojo.schedule.OfflineJobRequest;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfoRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sort.BaseSortConf;
import org.apache.inlong.manager.pojo.sort.FlinkSortConf;
import org.apache.inlong.manager.pojo.sort.UserDefinedSortConf;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.user.InlongRoleInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.group.InlongGroupOperator;
import org.apache.inlong.manager.service.group.InlongGroupOperatorFactory;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.schedule.ScheduleOperator;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.source.SourceOperatorFactory;
import org.apache.inlong.manager.service.source.StreamSourceOperator;
import org.apache.inlong.manager.service.source.bounded.BoundedSourceType;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.tenant.InlongTenantService;
import org.apache.inlong.manager.service.user.InlongRoleService;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class InlongGroupServiceImpl
implements InlongGroupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupServiceImpl.class);
    @Value(value="${sort.enable.zookeeper:false}")
    private boolean enableZookeeper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongGroupExtEntityMapper groupExtMapper;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private StreamSinkService streamSinkService;
    @Autowired
    private StreamSourceEntityMapper streamSourceMapper;
    @Autowired
    private TenantClusterTagEntityMapper tenantClusterTagMapper;
    @Autowired
    private InlongStreamExtEntityMapper streamExtMapper;
    @Autowired
    private InlongClusterService clusterService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    private InlongGroupOperatorFactory groupOperatorFactory;
    @Autowired
    private SourceOperatorFactory sourceOperatorFactory;
    @Autowired
    private InlongTenantService tenantService;
    @Autowired
    private InlongRoleService inlongRoleService;
    @Autowired
    private TenantUserRoleEntityMapper tenantUserRoleEntityMapper;
    @Autowired
    private UserService userService;
    @Autowired
    ScheduleOperator scheduleOperator;

    private static void doUpdateCheck(InlongGroupEntity entity, InlongGroupRequest request, String operator) {
        if (entity == null || request == null) {
            return;
        }
        GroupStatus curStatus = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.notAllowedUpdate((GroupStatus)curStatus)) {
            String errMsg = String.format("Current status=%s is not allowed to update", curStatus);
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.GROUP_UPDATE_NOT_ALLOWED, errMsg);
        }
        if (!entity.getMqType().equals(request.getMqType()) && !GroupStatus.allowedUpdateMQ((GroupStatus)curStatus)) {
            String errMsg = String.format("Current status=%s is not allowed to update MQ type", curStatus);
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.GROUP_UPDATE_NOT_ALLOWED, errMsg);
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String save(InlongGroupRequest request, String operator) {
        LOGGER.debug("begin to save inlong group={} by user={}", (Object)request, (Object)operator);
        Preconditions.expectNotNull((Object)request, (String)"inlong group request cannot be empty");
        String groupId = request.getInlongGroupId();
        InlongGroupEntity entity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        if (entity != null) {
            LOGGER.error("groupId={} has already exists", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.GROUP_DUPLICATE);
        }
        if (request.getEnableZookeeper() == null) {
            request.setEnableZookeeper(this.enableZookeeper ? InlongConstants.ENABLE_ZK : InlongConstants.DISABLE_ZK);
        }
        InlongGroupOperator instance = this.groupOperatorFactory.getInstance(request.getMqType());
        groupId = instance.saveOpt(request, operator);
        this.saveOrUpdateExt(groupId, request.getExtList());
        if (InlongConstants.DATASYNC_OFFLINE_MODE.equals(request.getInlongGroupMode())) {
            this.constrainStartAndEndTime(request);
            this.scheduleOperator.saveOpt((ScheduleInfoRequest)CommonBeanUtils.copyProperties((Object)request, ScheduleInfoRequest::new), operator);
        }
        LOGGER.info("success to save inlong group for groupId={} by user={}", (Object)groupId, (Object)operator);
        return groupId;
    }

    private void constrainStartAndEndTime(InlongGroupRequest request) {
        Timestamp startTime = request.getStartTime();
        Timestamp endTime = request.getEndTime();
        Preconditions.expectTrue((startTime != null && endTime != null ? 1 : 0) != 0, (String)"start time or end time cannot be empty");
        long currentTime = System.currentTimeMillis();
        if (startTime.getTime() < currentTime) {
            Timestamp newStartTime = new Timestamp(currentTime);
            request.setStartTime(newStartTime);
            LOGGER.warn("start time is less than current time, re-set to current time for groupId={}, startTime={}, newStartTime={}", new Object[]{request.getInlongGroupId(), startTime, newStartTime});
        }
        if (request.getStartTime().getTime() > endTime.getTime()) {
            request.setEndTime(request.getStartTime());
            LOGGER.warn("end time is less than start time, re-set end time to start time for groupId={}, endTime={}, newEndTime={}", new Object[]{request.getInlongGroupId(), endTime, request.getEndTime()});
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public List<BatchResult> batchSave(List<InlongGroupRequest> groupRequestList, String operator) {
        ArrayList<BatchResult> resultList = new ArrayList<BatchResult>();
        for (InlongGroupRequest groupRequest : groupRequestList) {
            BatchResult result = BatchResult.builder().uniqueKey(groupRequest.getInlongGroupId()).operationTarget(OperationTarget.GROUP).build();
            try {
                this.save(groupRequest, operator);
                result.setSuccess(true);
            }
            catch (Exception e) {
                LOGGER.error("failed to save inlong group for groupId={}", (Object)groupRequest.getInlongGroupId(), (Object)e);
                result.setSuccess(false);
                result.setErrMsg(e.getMessage());
            }
            resultList.add(result);
        }
        return resultList;
    }

    @Override
    public Boolean exist(String groupId) {
        Preconditions.expectNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        InlongGroupEntity entity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        LOGGER.debug("success to check inlong group {}, exist? {}", (Object)groupId, (Object)(entity != null ? 1 : 0));
        return entity != null;
    }

    private boolean isScheduleInfoExist(InlongGroupEntity entity) {
        return InlongConstants.DATASYNC_OFFLINE_MODE.equals(entity.getInlongGroupMode()) && this.scheduleOperator.scheduleInfoExist(entity.getInlongGroupId()) != false;
    }

    @Override
    public InlongGroupInfo get(String groupId) {
        Preconditions.expectNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            LOGGER.error("inlong group not found by groupId={}", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongGroupOperator instance = this.groupOperatorFactory.getInstance(entity.getMqType());
        InlongGroupInfo groupInfo = instance.getFromEntity(entity);
        List extEntityList = this.groupExtMapper.selectByGroupId(groupId);
        List extList = CommonBeanUtils.copyListProperties((List)extEntityList, InlongGroupExtInfo::new);
        groupInfo.setExtList(extList);
        List streamExtEntities = this.streamExtMapper.selectByRelatedId(groupId, null);
        BaseSortConf sortConf = this.buildSortConfig(streamExtEntities);
        groupInfo.setSortConf(sortConf);
        if (InlongConstants.DATASYNC_OFFLINE_MODE.equals(entity.getInlongGroupMode())) {
            this.fillInScheduleInfo(entity, groupInfo);
        }
        LOGGER.debug("success to get inlong group for groupId={}", (Object)groupId);
        return groupInfo;
    }

    private void fillInScheduleInfo(InlongGroupEntity entity, InlongGroupInfo groupInfo) {
        if (this.isScheduleInfoExist(entity)) {
            ScheduleInfo scheduleInfo = this.scheduleOperator.getScheduleInfo(entity.getInlongGroupId());
            int groupVersion = groupInfo.getVersion();
            CommonBeanUtils.copyProperties((Object)scheduleInfo, (Object)groupInfo);
            groupInfo.setVersion(Integer.valueOf(groupVersion));
        }
    }

    @Override
    public String getTenant(String groupId, String operator) {
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        String tenant = groupEntity.getTenant();
        if (Objects.equals("public", tenant)) {
            return tenant;
        }
        InlongTenantInfo tenantInfo = this.tenantService.getByName(tenant);
        if (tenantInfo == null) {
            String errMsg = String.format("tenant=[%s] not found", tenant);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongRoleInfo inlongRoleInfo = this.inlongRoleService.getByUsername(operator);
        TenantUserRoleEntity tenantRoleInfo = this.tenantUserRoleEntityMapper.selectByUsernameAndTenant(operator, tenant);
        if (inlongRoleInfo == null && tenantRoleInfo == null) {
            String errMsg = String.format("user=[%s] has no privilege for tenant=[%s]", operator, tenant);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        return tenant;
    }

    @Override
    public InlongGroupCountResponse countGroupByUser(String operator, Integer inlongGroupMode, String mqType) {
        InlongGroupCountResponse countVO = new InlongGroupCountResponse();
        List statusCount = this.groupMapper.countGroupByUser(operator, inlongGroupMode, mqType);
        for (Map map : statusCount) {
            int status = (Integer)map.get("status");
            long count = (Long)map.get("count");
            countVO.setTotalCount(countVO.getTotalCount() + count);
            if (status == GroupStatus.CONFIG_ING.getCode()) {
                countVO.setWaitAssignCount(countVO.getWaitAssignCount() + count);
                continue;
            }
            if (status == GroupStatus.TO_BE_APPROVAL.getCode()) {
                countVO.setWaitApproveCount(countVO.getWaitApproveCount() + count);
                continue;
            }
            if (status != GroupStatus.APPROVE_REJECTED.getCode()) continue;
            countVO.setRejectCount(countVO.getRejectCount() + count);
        }
        LOGGER.debug("success to count inlong group for operator={}", (Object)operator);
        return countVO;
    }

    @Override
    public InlongGroupTopicInfo getTopic(String groupId) {
        InlongGroupInfo groupInfo = this.get(groupId);
        InlongGroupOperator groupOperator = this.groupOperatorFactory.getInstance(groupInfo.getMqType());
        InlongGroupTopicInfo topicInfo = groupOperator.getTopic(groupInfo);
        topicInfo.setInlongGroupId(groupId);
        String clusterTag = groupInfo.getInlongClusterTag();
        topicInfo.setInlongClusterTag(clusterTag);
        List<ClusterInfo> clusterInfos = this.clusterService.listByTagAndType(clusterTag, groupInfo.getMqType());
        topicInfo.setClusterInfos(clusterInfos);
        LOGGER.debug("success to get topic for groupId={}, result={}", (Object)groupId, (Object)topicInfo);
        return topicInfo;
    }

    @Override
    public InlongGroupTopicInfo getBackupTopic(String groupId) {
        InlongGroupExtEntity extEntity = this.groupExtMapper.selectByUniqueKey(groupId, "backup_cluster_tag");
        if (extEntity == null || StringUtils.isBlank((CharSequence)extEntity.getKeyValue())) {
            LOGGER.warn("not found any backup topic for groupId={}", (Object)groupId);
            return null;
        }
        InlongGroupInfo groupInfo = this.get(groupId);
        InlongGroupOperator groupOperator = this.groupOperatorFactory.getInstance(groupInfo.getMqType());
        InlongGroupTopicInfo backupTopicInfo = groupOperator.getBackupTopic(groupInfo);
        backupTopicInfo.setInlongGroupId(groupId);
        String backupClusterTag = extEntity.getKeyValue();
        backupTopicInfo.setInlongClusterTag(backupClusterTag);
        List<ClusterInfo> clusterInfos = this.clusterService.listByTagAndType(backupClusterTag, groupInfo.getMqType());
        backupTopicInfo.setClusterInfos(clusterInfos);
        LOGGER.debug("success to get backup topic for groupId={}, result={}", (Object)groupId, (Object)backupTopicInfo);
        return backupTopicInfo;
    }

    @Override
    public PageResult<InlongGroupBriefInfo> listBrief(InlongGroupPageRequest request) {
        if (request.getPageSize() > PageRequest.MAX_PAGE_SIZE) {
            LOGGER.warn("list inlong groups, change page size from {} to {}", (Object)request.getPageSize(), (Object)PageRequest.MAX_PAGE_SIZE);
            request.setPageSize(PageRequest.MAX_PAGE_SIZE.intValue());
        }
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page entityPage = (Page)this.groupMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> (InlongGroupBriefInfo)CommonBeanUtils.copyProperties((Object)entity, InlongGroupBriefInfo::new));
        List briefInfos = pageResult.getList();
        if (request.isListSources() && CollectionUtils.isNotEmpty((Collection)briefInfos)) {
            Set groupIds = briefInfos.stream().map(InlongGroupBriefInfo::getInlongGroupId).collect(Collectors.toSet());
            List sourceEntities = this.streamSourceMapper.selectByGroupIds(new ArrayList(groupIds));
            HashMap sourceMap = Maps.newHashMap();
            sourceEntities.forEach(sourceEntity -> {
                StreamSourceOperator operation = this.sourceOperatorFactory.getInstance(sourceEntity.getSourceType());
                StreamSource source = operation.getFromEntity((StreamSourceEntity)sourceEntity);
                sourceMap.computeIfAbsent(sourceEntity.getInlongGroupId(), k -> Lists.newArrayList()).add(source);
            });
            briefInfos.forEach(group -> {
                List sources = sourceMap.getOrDefault(group.getInlongGroupId(), Lists.newArrayList());
                group.setStreamSources(sources);
            });
        }
        LOGGER.debug("success to list inlong group for {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<InlongGroupBriefInfo> listBrief(InlongGroupPageRequest request, UserInfo opInfo) {
        ArrayList<InlongGroupEntity> filterGroupEntities = new ArrayList<InlongGroupEntity>();
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        for (InlongGroupEntity groupEntity : this.groupMapper.selectByCondition(request)) {
            List<String> inCharges;
            if (!opInfo.getAccountType().equals(TenantUserTypeEnum.TENANT_ADMIN.getCode()) && !(inCharges = Arrays.asList(groupEntity.getInCharges().split(","))).contains(opInfo.getName())) continue;
            filterGroupEntities.add(groupEntity);
        }
        List briefInfos = CommonBeanUtils.copyListProperties(filterGroupEntities, InlongGroupBriefInfo::new);
        if (request.isListSources() && CollectionUtils.isNotEmpty((Collection)briefInfos)) {
            Set groupIds = briefInfos.stream().map(InlongGroupBriefInfo::getInlongGroupId).collect(Collectors.toSet());
            List sourceEntities = this.streamSourceMapper.selectByGroupIds(new ArrayList(groupIds));
            HashMap sourceMap = Maps.newHashMap();
            sourceEntities.forEach(sourceEntity -> {
                StreamSourceOperator operation = this.sourceOperatorFactory.getInstance(sourceEntity.getSourceType());
                StreamSource source = operation.getFromEntity((StreamSourceEntity)sourceEntity);
                sourceMap.computeIfAbsent(sourceEntity.getInlongGroupId(), k -> Lists.newArrayList()).add(source);
            });
            briefInfos.forEach(group -> {
                List sources = sourceMap.getOrDefault(group.getInlongGroupId(), Lists.newArrayList());
                group.setStreamSources(sources);
            });
        }
        return briefInfos;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRES_NEW)
    public String update(InlongGroupRequest request, String operator) {
        LOGGER.debug("begin to update inlong group={} by user={}", (Object)request, (Object)operator);
        String groupId = request.getInlongGroupId();
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            LOGGER.error("inlong group not found by groupId={}", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        this.userService.checkUser(entity.getInCharges(), operator, "Current user does not have permission to update group info");
        this.chkUnmodifiableParams(entity, request);
        InlongGroupServiceImpl.doUpdateCheck(entity, request, operator);
        if (request.getEnableZookeeper() == null) {
            request.setEnableZookeeper(this.enableZookeeper ? InlongConstants.ENABLE_ZK : InlongConstants.DISABLE_ZK);
        }
        InlongGroupOperator instance = this.groupOperatorFactory.getInstance(request.getMqType());
        instance.updateOpt(request, operator);
        this.saveOrUpdateExt(groupId, request.getExtList());
        if (InlongConstants.DATASYNC_OFFLINE_MODE.equals(request.getInlongGroupMode())) {
            this.constrainStartAndEndTime(request);
            ScheduleInfoRequest scheduleRequest = (ScheduleInfoRequest)CommonBeanUtils.copyProperties((Object)request, ScheduleInfoRequest::new);
            if (this.scheduleOperator.scheduleInfoExist(groupId).booleanValue()) {
                scheduleRequest.setVersion(this.scheduleOperator.getScheduleInfo(groupId).getVersion());
            }
            this.scheduleOperator.updateAndRegister(scheduleRequest, operator);
        }
        LOGGER.info("success to update inlong group for groupId={} by user={}", (Object)groupId, (Object)operator);
        return groupId;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRES_NEW)
    public Boolean updateStatus(String groupId, Integer status, String operator) {
        GroupStatus nextState;
        LOGGER.info("begin to update group status to [{}] for groupId={} by user={}", new Object[]{status, groupId, operator});
        Preconditions.expectNotNull((Object)groupId, (String)ErrorCodeEnum.GROUP_ID_IS_EMPTY.getMessage());
        InlongGroupEntity entity = this.groupMapper.selectByGroupIdForUpdate(groupId);
        if (entity == null) {
            LOGGER.error("inlong group not found by groupId={}", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        GroupStatus curState = GroupStatus.forCode((int)entity.getStatus());
        if (GroupStatus.notAllowedTransition((GroupStatus)curState, (GroupStatus)(nextState = GroupStatus.forCode((int)status)))) {
            String errorMsg = String.format("Current status=%s is not allowed to transfer to state=%s", curState, nextState);
            LOGGER.error(errorMsg);
            throw new BusinessException(errorMsg);
        }
        this.groupMapper.updateStatus(groupId, status, operator);
        LOGGER.info("success to update group status to [{}] for groupId={} by user={}", new Object[]{status, groupId, operator});
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public void updateAfterApprove(InlongGroupApproveRequest approveRequest, String operator) {
        LOGGER.debug("begin to update inlong group after approve={}", (Object)approveRequest);
        String groupId = approveRequest.getInlongGroupId();
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new BusinessException("inlong group not found with group id=" + groupId);
        }
        if (!Objects.equals(GroupStatus.TO_BE_APPROVAL.getCode(), entity.getStatus())) {
            throw new BusinessException("inlong group status [wait_approval] not allowed to approve again");
        }
        if (StringUtils.isNotBlank((CharSequence)approveRequest.getInlongClusterTag())) {
            entity.setInlongGroupId(groupId);
            entity.setInlongClusterTag(approveRequest.getInlongClusterTag());
            entity.setStatus(GroupStatus.APPROVE_PASSED.getCode());
            if (approveRequest.getDataReportType() != null && !Objects.equals(approveRequest.getDataReportType(), entity.getDataReportType())) {
                entity.setDataReportType(approveRequest.getDataReportType());
            }
            entity.setModifier(operator);
            int rowCount = this.groupMapper.updateByIdentifierSelective(entity);
            if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
                LOGGER.error("inlong group has already updated with group id={}, curVersion={}", (Object)groupId, (Object)entity.getVersion());
                throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
            }
        } else {
            this.updateStatus(groupId, GroupStatus.APPROVE_PASSED.getCode(), operator);
        }
        LOGGER.info("success to update inlong group status after approve for groupId={}", (Object)groupId);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void saveOrUpdateExt(String groupId, List<InlongGroupExtInfo> exts) {
        if (CollectionUtils.isEmpty(exts)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(exts, InlongGroupExtEntity::new);
        for (InlongGroupExtEntity entity : entityList) {
            entity.setInlongGroupId(groupId);
        }
        this.groupExtMapper.insertOnDuplicateKeyUpdate(entityList);
    }

    @Override
    public List<InlongGroupTopicInfo> listTopics(InlongGroupTopicRequest request) {
        LOGGER.info("start to list group topic infos, request={}", (Object)request);
        Preconditions.expectNotEmpty((String)request.getClusterTag(), (String)"cluster tag should not be empty");
        List groupEntities = this.groupMapper.selectByTopicRequest(request);
        ArrayList<InlongGroupTopicInfo> topicInfos = new ArrayList<InlongGroupTopicInfo>();
        for (InlongGroupEntity entity : groupEntities) {
            topicInfos.add(this.getTopic(entity.getInlongGroupId()));
        }
        LOGGER.info("success list group topic infos under clusterTag={}, size={}", (Object)request.getClusterTag(), (Object)topicInfos.size());
        return topicInfos;
    }

    @Override
    public Map<String, Object> detail(String groupId) {
        InlongGroupInfo groupInfo = this.get(groupId);
        InlongGroupOperator instance = this.groupOperatorFactory.getInstance(groupInfo.getMqType());
        return instance.getDetailInfo(groupInfo);
    }

    @Override
    public InlongGroupInfo doDeleteCheck(String groupId, String operator) {
        int count;
        InlongGroupInfo groupInfo = this.get(groupId);
        List<String> inCharges = Arrays.asList(groupInfo.getInCharges().split(","));
        if (!inCharges.contains(operator)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_PERMISSION_DENIED, String.format("user [%s] has no privilege for the inlong group", operator));
        }
        GroupStatus curState = GroupStatus.forCode((int)groupInfo.getStatus());
        if (GroupStatus.notAllowedTransition((GroupStatus)curState, (GroupStatus)GroupStatus.CONFIG_DELETING)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_DELETE_NOT_ALLOWED, String.format("current group status=%s was not allowed to delete", curState));
        }
        if (GroupStatus.deleteStreamFirst((GroupStatus)curState) && InlongConstants.STANDARD_MODE.equals(groupInfo.getInlongGroupMode()) && (count = this.streamService.selectCountByGroupId(groupId)) >= 1) {
            throw new BusinessException(ErrorCodeEnum.GROUP_DELETE_HAS_STREAM, String.format("groupId=%s have [%s] inlong streams, deleted failed", groupId, count));
        }
        return groupInfo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(String groupId, String operator) {
        LOGGER.info("begin to delete inlong group for groupId={} by user={}", (Object)groupId, (Object)operator);
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        if (GroupStatus.allowedDeleteSubInfos((GroupStatus)GroupStatus.forCode((int)entity.getStatus()))) {
            this.streamService.logicDeleteAll(groupId, operator);
        }
        entity.setIsDeleted(entity.getId());
        entity.setStatus(GroupStatus.CONFIG_DELETED.getCode());
        entity.setModifier(operator);
        int rowCount = this.groupMapper.updateByIdentifierSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("inlong group has already updated for groupId={} curVersion={}", (Object)groupId, (Object)entity.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.groupExtMapper.logicDeleteAllByGroupId(groupId);
        if (InlongConstants.DATASYNC_OFFLINE_MODE.equals(entity.getInlongGroupMode())) {
            try {
                this.scheduleOperator.deleteByGroupIdOpt(entity.getInlongGroupId(), operator);
            }
            catch (Exception e) {
                LOGGER.warn("failed to delete schedule info for groupId={}, error msg: {}", (Object)groupId, (Object)e.getMessage());
            }
        }
        LOGGER.info("success to delete group and group ext property for groupId={} by user={}", (Object)groupId, (Object)operator);
        return true;
    }

    private BaseSortConf buildSortConfig(List<InlongStreamExtEntity> extInfos) {
        HashMap<String, String> extMap = new HashMap<String, String>();
        extInfos.forEach(extInfo -> extMap.put(extInfo.getKeyName(), extInfo.getKeyValue()));
        String type = (String)extMap.get("sort.type");
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        BaseSortConf.SortType sortType = BaseSortConf.SortType.forType((String)type);
        switch (sortType) {
            case FLINK: {
                return this.createFlinkSortConfig(extMap);
            }
            case USER_DEFINED: {
                return this.createUserDefinedSortConfig(extMap);
            }
        }
        LOGGER.warn("unsupported sort config for sortType: {}", (Object)sortType);
        return null;
    }

    private FlinkSortConf createFlinkSortConfig(Map<String, String> extMap) {
        FlinkSortConf sortConf = new FlinkSortConf();
        sortConf.setServiceUrl(extMap.get("sort.url"));
        String properties = extMap.get("sort.properties");
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            sortConf.setProperties((Map)JsonUtils.parseObject((String)properties, (TypeReference)new TypeReference<Map<String, String>>(){}));
        } else {
            sortConf.setProperties((Map)Maps.newHashMap());
        }
        String authenticationType = extMap.get("sort.authentication.type");
        if (StringUtils.isNotBlank((CharSequence)authenticationType)) {
            Authentication.AuthType authType = Authentication.AuthType.forType((String)authenticationType);
            Preconditions.expectTrue((authType == Authentication.AuthType.SECRET_AND_TOKEN ? 1 : 0) != 0, (String)"Only support SECRET_AND_TOKEN for flink sort auth");
            String authentication = extMap.get("sort.authentication");
            Map authProperties = (Map)JsonUtils.parseObject((String)authentication, (TypeReference)new TypeReference<Map<String, String>>(){});
            SecretTokenAuthentication secretTokenAuthentication = new SecretTokenAuthentication();
            secretTokenAuthentication.configure(authProperties);
            sortConf.setAuthentication((Authentication)secretTokenAuthentication);
        }
        return sortConf;
    }

    private UserDefinedSortConf createUserDefinedSortConfig(Map<String, String> extMap) {
        UserDefinedSortConf sortConf = new UserDefinedSortConf();
        String sortName = extMap.get("sort.name");
        sortConf.setSortName(sortName);
        String properties = extMap.get("sort.properties");
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            sortConf.setProperties((Map)JsonUtils.parseObject((String)properties, (TypeReference)new TypeReference<Map<String, String>>(){}));
        } else {
            sortConf.setProperties((Map)Maps.newHashMap());
        }
        return sortConf;
    }

    private void chkUnmodifiableParams(InlongGroupEntity entity, InlongGroupRequest request) {
        Preconditions.expectTrue((Objects.equals(entity.getMqType(), request.getMqType()) || Objects.equals(entity.getStatus(), GroupStatus.TO_BE_SUBMIT.getCode()) ? 1 : 0) != 0, (String)"mqType not allowed modify");
        Preconditions.expectEquals((Object)entity.getVersion(), (Object)request.getVersion(), (ErrorCodeEnum)ErrorCodeEnum.CONFIG_EXPIRED, (String)String.format("record has expired with record version=%d, request version=%d", entity.getVersion(), request.getVersion()));
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRES_NEW)
    public Boolean startTagSwitch(String groupId, String clusterTag) {
        LOGGER.info("start to switch cluster tag for group={}, target tag={}", (Object)groupId, (Object)clusterTag);
        InlongGroupInfo groupInfo = this.get(groupId);
        if (InlongConstants.DATASYNC_REALTIME_MODE.equals(groupInfo.getInlongGroupMode())) {
            String errMSg = String.format("no need to switch sync mode group = {}", groupId);
            LOGGER.error(errMSg);
            throw new BusinessException(errMSg);
        }
        List groupExt = groupInfo.getExtList();
        Set keys = groupExt.stream().map(InlongGroupExtInfo::getKeyName).collect(Collectors.toSet());
        if (keys.contains("backup_cluster_tag") || keys.contains("backup_mq_resource")) {
            String errMsg = String.format("switch failed, current group is under switching, group=[%s]", groupId);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupId(groupId);
        if (groupEntity == null) {
            LOGGER.error("inlong group not found by groupId={}", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        TenantClusterTagEntity tenantClusterTag = this.tenantClusterTagMapper.selectByUniqueKey(clusterTag, groupEntity.getTenant());
        if (tenantClusterTag == null) {
            LOGGER.error("tenant cluster not found for tenant={}, clusterTag={}", (Object)groupEntity.getTenant(), (Object)clusterTag);
            throw new BusinessException(ErrorCodeEnum.TENANT_CLUSTER_TAG_NOT_FOUND);
        }
        List<StreamSink> sinks = this.streamSinkService.listSink(groupEntity.getInlongGroupId(), null);
        for (StreamSink sink : sinks) {
            String clusterName = sink.getInlongClusterName();
            List clusterEntity = this.clusterEntityMapper.selectByKey(clusterTag, clusterName, SinkType.relatedSortClusterType((String)sink.getSinkType()));
            if (!CollectionUtils.isEmpty((Collection)clusterEntity) && clusterEntity.size() == 1) continue;
            String errMsg = String.format("find no cluster or multiple cluster with clusterName=[%s]", clusterName);
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND, errMsg);
        }
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        InlongGroupRequest request = groupInfo.genRequest();
        String oldClusterTag = request.getInlongClusterTag();
        request.setInlongClusterTag(clusterTag);
        request.getExtList().add(new InlongGroupExtInfo(null, groupId, "backup_cluster_tag", oldClusterTag));
        request.getExtList().add(new InlongGroupExtInfo(null, groupId, "backup_mq_resource", request.getMqResource()));
        request.getExtList().add(new InlongGroupExtInfo(null, groupId, "cluster_switch_time", LocalDateTime.now().toString()));
        this.update(request, userInfo.getName());
        this.triggerWorkFlow(groupInfo, userInfo);
        LOGGER.info("success to switch cluster tag for group={}, target tag={}", (Object)groupId, (Object)clusterTag);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRES_NEW)
    public Boolean finishTagSwitch(String groupId) {
        LOGGER.info("start to finish switch cluster tag for group={}", (Object)groupId);
        InlongGroupInfo groupInfo = this.get(groupId);
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        GroupStatus curStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        if (GroupStatus.notAllowedUpdate((GroupStatus)curStatus)) {
            String errMsg = String.format("Current status=%s is not allowed to update", curStatus);
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.GROUP_UPDATE_NOT_ALLOWED, errMsg);
        }
        List groupExt = groupInfo.getExtList();
        Map<String, InlongGroupExtInfo> extInfoMap = groupExt.stream().collect(Collectors.toMap(InlongGroupExtInfo::getKeyName, v -> v));
        if (!extInfoMap.containsKey("backup_cluster_tag") || !extInfoMap.containsKey("backup_mq_resource")) {
            String errMsg = String.format("finish switch failed, current group is not under switching, group=[%s]", groupId);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongGroupExtInfo switchTime = extInfoMap.get("cluster_switch_time");
        LocalDateTime switchStartTime = switchTime == null ? LocalDateTime.MIN : LocalDateTime.parse(switchTime.getKeyValue());
        LocalDateTime allowSwitchTime = switchStartTime.plusMinutes(10L);
        if (LocalDateTime.now().isBefore(allowSwitchTime)) {
            String errMsg = String.format("finish switch failed, please retry until={}", allowSwitchTime);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        this.removeExt(extInfoMap.get("backup_cluster_tag"));
        this.removeExt(extInfoMap.get("backup_mq_resource"));
        this.removeExt(extInfoMap.get("cluster_switch_time"));
        this.triggerWorkFlow(groupInfo, userInfo);
        return true;
    }

    private void triggerWorkFlow(InlongGroupInfo groupInfo, UserInfo userInfo) {
        GroupResourceProcessForm processForm = new GroupResourceProcessForm();
        processForm.setGroupInfo(groupInfo);
        List<InlongStreamInfo> streamList = this.streamService.list(groupInfo.getInlongGroupId());
        processForm.setStreamInfos(streamList);
        ProcessEventListener.EXECUTOR_SERVICE.execute(() -> this.workflowService.startAsync(ProcessName.CREATE_GROUP_RESOURCE, userInfo, (ProcessForm)processForm));
    }

    private void removeExt(InlongGroupExtInfo extInfo) {
        if (extInfo == null || extInfo.getId() == null) {
            return;
        }
        this.groupExtMapper.deleteByPrimaryKey(extInfo.getId());
    }

    @Override
    public List<GroupFullInfo> getGroupByClusterTag(String clusterTag) {
        List groupEntities = this.groupMapper.selectByClusterTagWithoutTenant(clusterTag);
        if (CollectionUtils.isEmpty((Collection)groupEntities)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        ArrayList<GroupFullInfo> groupInfoList = new ArrayList<GroupFullInfo>();
        for (InlongGroupEntity groupEntity : groupEntities) {
            InlongGroupOperator instance = this.groupOperatorFactory.getInstance(groupEntity.getMqType());
            InlongGroupInfo groupInfo = instance.getFromEntity(groupEntity);
            List<InlongStreamInfo> streamInfos = this.streamService.list(groupInfo.getInlongGroupId());
            GroupFullInfo groupFullInfo = new GroupFullInfo();
            groupFullInfo.setGroupInfo(groupInfo);
            groupFullInfo.setStreamInfoList(streamInfos);
            groupInfoList.add(groupFullInfo);
        }
        return groupInfoList;
    }

    @Override
    public List<GroupFullInfo> getGroupByBackUpClusterTag(String clusterTag) {
        ArrayList<GroupFullInfo> groupInfoList = new ArrayList<GroupFullInfo>();
        List groupIdList = this.groupExtMapper.selectGroupIdByKeyNameAndValue("backup_cluster_tag", clusterTag);
        if (CollectionUtils.isEmpty((Collection)groupIdList)) {
            return groupInfoList;
        }
        List groupEntities = this.groupMapper.selectByInlongGroupIds(groupIdList);
        if (CollectionUtils.isEmpty((Collection)groupEntities)) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        for (InlongGroupEntity groupEntity : groupEntities) {
            InlongGroupOperator instance = this.groupOperatorFactory.getInstance(groupEntity.getMqType());
            InlongGroupInfo groupInfo = instance.getFromEntity(groupEntity);
            InlongGroupExtEntity backUpMqResource = this.groupExtMapper.selectByUniqueKey(groupEntity.getInlongGroupId(), "backup_mq_resource");
            if (backUpMqResource != null) {
                groupInfo.setMqResource(backUpMqResource.getKeyValue());
            }
            List<InlongStreamInfo> streamInfoList = this.streamService.listBackUp(groupEntity.getInlongGroupId());
            GroupFullInfo groupFullInfo = new GroupFullInfo();
            groupFullInfo.setGroupInfo(groupInfo);
            groupFullInfo.setStreamInfoList(streamInfoList);
            groupInfoList.add(groupFullInfo);
        }
        return groupInfoList;
    }

    @Override
    public Boolean submitOfflineJob(OfflineJobRequest request) {
        String groupId = request.getGroupId();
        InlongGroupInfo groupInfo = this.get(groupId);
        if (groupInfo == null) {
            String msg = String.format("InLong group not found for group=%s", groupId);
            LOGGER.error(msg);
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        List<InlongStreamInfo> streamInfoList = this.streamService.list(groupId);
        if (CollectionUtils.isEmpty(streamInfoList)) {
            LOGGER.warn("No stream info found for group {}, skip submit offline job", (Object)groupId);
            return false;
        }
        streamInfoList.forEach(this::checkBoundedSource);
        this.checkSourceBoundaryType(request.getBoundaryType());
        BoundaryType boundaryType = BoundaryType.getInstance((String)request.getBoundaryType());
        if (boundaryType == null) {
            throw new BusinessException(ErrorCodeEnum.BOUNDARY_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.BOUNDARY_TYPE_NOT_SUPPORTED.getMessage(), request.getBoundaryType()));
        }
        Boundaries boundaries = new Boundaries(request.getLowerBoundary(), request.getUpperBoundary(), boundaryType);
        LOGGER.info("Check bounded source success, start to submitting offline job for group {}", (Object)groupId);
        return this.scheduleOperator.submitOfflineJob(groupId, streamInfoList, boundaries);
    }

    private void checkBoundedSource(InlongStreamInfo streamInfo) {
        streamInfo.getSourceList().forEach(stream -> {
            if (!BoundedSourceType.isBoundedSource(stream.getSourceType())) {
                throw new BusinessException(ErrorCodeEnum.BOUNDED_SOURCE_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.BOUNDED_SOURCE_TYPE_NOT_SUPPORTED.getMessage(), stream.getSourceType()));
            }
        });
    }

    private void checkSourceBoundaryType(String sourceBoundaryType) {
        if (!BoundaryType.isSupportBoundaryType((String)sourceBoundaryType)) {
            throw new BusinessException(ErrorCodeEnum.BOUNDARY_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.BOUNDARY_TYPE_NOT_SUPPORTED.getMessage(), sourceBoundaryType));
        }
    }
}

