/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.tubemq.corebase.balance.ConsumerEvent;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerEventManager {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerEventManager.class);
    private final ConcurrentHashMap<String, LinkedList<ConsumerEvent>> disconnectEventMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LinkedList<ConsumerEvent>> connectEventMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicInteger> groupUnfinishedCountMap = new ConcurrentHashMap();
    private final ConsumerInfoHolder consumerHolder;

    public ConsumerEventManager(ConsumerInfoHolder consumerHolder) {
        this.consumerHolder = consumerHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDisconnectEvent(String consumerId, ConsumerEvent event) {
        LinkedList<Object> eventList = this.disconnectEventMap.get(consumerId);
        if (eventList == null) {
            eventList = new LinkedList();
            LinkedList<Object> tmptList = this.disconnectEventMap.putIfAbsent(consumerId, eventList);
            if (tmptList == null) {
                MasterSrvStatsHolder.incSvrBalDisConConsumerCnt();
            } else {
                eventList = tmptList;
            }
        }
        LinkedList<ConsumerEvent> linkedList = eventList;
        synchronized (linkedList) {
            return eventList.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnectEvent(String consumerId, ConsumerEvent event) {
        LinkedList<Object> eventList = this.connectEventMap.get(consumerId);
        if (eventList == null) {
            eventList = new LinkedList();
            LinkedList<Object> tmptList = this.connectEventMap.putIfAbsent(consumerId, eventList);
            if (tmptList == null) {
                MasterSrvStatsHolder.incSvrBalConEventConsumerCnt();
            } else {
                eventList = tmptList;
            }
        }
        LinkedList<ConsumerEvent> linkedList = eventList;
        synchronized (linkedList) {
            return eventList.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerEvent peek(String consumerId) {
        String group = this.consumerHolder.getGroupName(consumerId);
        if (group != null) {
            ConcurrentHashMap<String, LinkedList<ConsumerEvent>> currentEventMap = this.hasDisconnectEvent(group) ? this.disconnectEventMap : this.connectEventMap;
            LinkedList<ConsumerEvent> eventList = currentEventMap.get(consumerId);
            if (eventList != null) {
                LinkedList<ConsumerEvent> linkedList = eventList;
                synchronized (linkedList) {
                    return eventList.peek();
                }
            }
        } else {
            logger.warn(new StringBuilder(512).append("No group by consumer ").append(consumerId).toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFirst(String consumerId, StringBuilder strBuffer) {
        ConsumerEvent event = null;
        String group = this.consumerHolder.getGroupName(consumerId);
        boolean selDisConnMap = this.hasDisconnectEvent(group);
        ConcurrentHashMap<String, LinkedList<ConsumerEvent>> currentEventMap = selDisConnMap ? this.disconnectEventMap : this.connectEventMap;
        LinkedList<ConsumerEvent> eventList = currentEventMap.get(consumerId);
        if (eventList != null) {
            LinkedList<ConsumerEvent> linkedList = eventList;
            synchronized (linkedList) {
                if (CollectionUtils.isNotEmpty(eventList)) {
                    event = eventList.removeFirst();
                    if (eventList.isEmpty()) {
                        currentEventMap.remove(consumerId);
                        if (selDisConnMap) {
                            MasterSrvStatsHolder.decSvrBalDisConConsumerCnt();
                        } else {
                            MasterSrvStatsHolder.decSvrBalConEventConsumerCnt();
                        }
                    }
                }
            }
        }
        if (event != null) {
            logger.info(strBuffer.append("[Event Removed] rebalanceId=").append(event.getRebalanceId()).append(",clientId=").append(consumerId).toString());
            strBuffer.delete(0, strBuffer.length());
        }
    }

    public int getUnfinishedCount(String groupName) {
        if (groupName == null) {
            return 0;
        }
        AtomicInteger unfinishedCount = this.groupUnfinishedCountMap.get(groupName);
        if (unfinishedCount == null) {
            return 0;
        }
        return unfinishedCount.get();
    }

    public void updateUnfinishedCountMap(Set<String> groupHasUnfinishedEvent) {
        if (groupHasUnfinishedEvent.isEmpty()) {
            this.groupUnfinishedCountMap.clear();
        } else {
            for (String oldGroup : this.groupUnfinishedCountMap.keySet()) {
                if (oldGroup == null || groupHasUnfinishedEvent.contains(oldGroup)) continue;
                this.groupUnfinishedCountMap.remove(oldGroup);
            }
            for (String newGroup : groupHasUnfinishedEvent) {
                AtomicInteger newCount;
                if (newGroup == null) continue;
                AtomicInteger unfinishedCount = this.groupUnfinishedCountMap.get(newGroup);
                if (unfinishedCount == null && (unfinishedCount = this.groupUnfinishedCountMap.putIfAbsent(newGroup, newCount = new AtomicInteger(0))) == null) {
                    unfinishedCount = newCount;
                }
                unfinishedCount.incrementAndGet();
            }
        }
    }

    public void removeAll(String consumerId) {
        LinkedList<ConsumerEvent> eventInfos = this.disconnectEventMap.remove(consumerId);
        if (eventInfos != null) {
            MasterSrvStatsHolder.decSvrBalDisConConsumerCnt();
        }
        if ((eventInfos = this.connectEventMap.remove(consumerId)) != null) {
            MasterSrvStatsHolder.decSvrBalConEventConsumerCnt();
        }
    }

    public boolean hasEvent() {
        for (Map.Entry<String, LinkedList<ConsumerEvent>> entry : this.disconnectEventMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return true;
        }
        for (Map.Entry<String, LinkedList<ConsumerEvent>> entry : this.connectEventMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDisconnectEvent(String group) {
        List<String> consumerIdList = this.consumerHolder.getConsumerIdList(group);
        if (CollectionUtils.isNotEmpty(consumerIdList)) {
            for (String consumerId : consumerIdList) {
                List eventList;
                if (consumerId == null || (eventList = (List)this.disconnectEventMap.get(consumerId)) == null) continue;
                List list = eventList;
                synchronized (list) {
                    if (CollectionUtils.isNotEmpty((Collection)eventList)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Set<String> getUnProcessedIdSet() {
        HashSet<String> consumerIdSet = new HashSet<String>();
        for (Map.Entry<String, LinkedList<ConsumerEvent>> entry : this.disconnectEventMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            consumerIdSet.add(entry.getKey());
        }
        for (Map.Entry<String, LinkedList<ConsumerEvent>> entry : this.connectEventMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            consumerIdSet.add(entry.getKey());
        }
        return consumerIdSet;
    }

    public void clear() {
        this.disconnectEventMap.clear();
        this.connectEventMap.clear();
    }

    public String toString() {
        return "ConsumerEventManager [disconnectEventMap=" + this.disconnectEventMap + ", connectEventMap=" + this.connectEventMap + "]";
    }
}

