/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.KeyBuilderUtils;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.TopicDeployMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsTopicDeployMapperImpl
implements TopicDeployMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsTopicDeployMapperImpl.class);
    private final ConcurrentHashMap<String, TopicDeployEntity> topicDeployCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ConcurrentHashSet<String>> brokerId2RecordCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashSet<String>> topicName2RecordCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ConcurrentHashSet<String>> brokerId2TopicNameCache = new ConcurrentHashMap();

    @Override
    public boolean addTopicDeployConf(TopicDeployEntity entity, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity curEntity = this.topicDeployCache.get(entity.getRecordKey());
        if (curEntity != null) {
            if (curEntity.isValidTopicStatus()) {
                result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for brokerId-topicName(").append(curEntity.getRecordKey()).append(")!").toString());
            } else {
                result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Softly deleted record found for brokerId-topicName(").append(curEntity.getRecordKey()).append("), please resume or remove it first!").toString());
            }
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (!this.isValidSysTopicConf(entity, strBuff, result)) {
            return result.isSuccess();
        }
        if (!entity.isValidTopicStatus() && (entity.isAcceptPublish() || entity.isAcceptSubscribe())) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The values of acceptPublish and acceptSubscribe must be false").append(" when add brokerId-topicName(").append(entity.getRecordKey()).append(") record!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(entity, strBuff, result)) {
            this.putRecord2Caches(entity);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updTopicDeployConf(TopicDeployEntity entity, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity curEntity = this.topicDeployCache.get(entity.getRecordKey());
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found topic deploy configure for brokerId-topicName(").append(entity.getRecordKey()).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        TopicDeployEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(entity);
        if (!newEntity.updModifyInfo(entity.getDataVerId(), entity.getTopicId(), entity.getBrokerPort(), entity.getBrokerIp(), entity.getDeployStatus(), entity.getTopicProps())) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Topic deploy configure not changed!");
            return result.isSuccess();
        }
        if (!this.isValidSysTopicConf(newEntity, strBuff, result)) {
            return result.isSuccess();
        }
        if (!this.isValidValuesChange(newEntity, curEntity, strBuff, result)) {
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.putRecord2Caches(newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean updTopicDeployStatus(BaseEntity opEntity, int brokerId, String topicName, TopicStatus topicStatus, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity curEntity = this.getTopicConf(brokerId, topicName);
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found topic deploy configure for brokerId-topicName(").append(brokerId).append("-").append(topicName).append(")!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        TopicDeployEntity newEntity = curEntity.clone();
        newEntity.updBaseModifyInfo(opEntity);
        if (!newEntity.updModifyInfo(opEntity.getDataVerId(), -2, -2, null, topicStatus, null)) {
            result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Topic deploy configure not changed!");
            return result.isSuccess();
        }
        if (!this.isValidValuesChange(newEntity, curEntity, strBuff, result)) {
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.putRecord2Caches(newEntity);
            result.setSuccResult(null);
        }
        return result.isSuccess();
    }

    @Override
    public boolean delTopicDeployConf(String recordKey, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity curEntity = this.topicDeployCache.get(recordKey);
        if (curEntity == null) {
            result.setSuccResult(null);
            return result.isSuccess();
        }
        if (curEntity.isAcceptPublish() || curEntity.isAcceptSubscribe()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The values of acceptPublish and acceptSubscribe must be false").append(" before delete brokerId-topicName(").append(curEntity.getRecordKey()).append(") record!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        this.delConfigFromPersistent(recordKey, strBuff);
        this.delRecordFromCaches(recordKey);
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public boolean delTopicConfByBrokerId(Integer brokerId, StringBuilder strBuff, ProcessResult result) {
        ConcurrentHashSet<String> recordKeySet = this.brokerId2RecordCache.get(brokerId);
        if (recordKeySet == null || recordKeySet.isEmpty()) {
            result.setSuccResult(null);
            return result.isSuccess();
        }
        for (String recordKey : recordKeySet) {
            TopicDeployEntity curEntity = this.topicDeployCache.get(recordKey);
            if (curEntity == null || !curEntity.isAcceptPublish() && !curEntity.isAcceptSubscribe()) continue;
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The values of acceptPublish and acceptSubscribe must be false").append(" before delete brokerId-topicName(").append(curEntity.getRecordKey()).append(") record!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        for (String recordKey : recordKeySet) {
            this.delConfigFromPersistent(recordKey, strBuff);
            this.delRecordFromCaches(recordKey);
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public boolean hasConfiguredTopics(int brokerId) {
        ConcurrentHashSet<String> keySet = this.brokerId2RecordCache.get(brokerId);
        return keySet != null && !keySet.isEmpty();
    }

    @Override
    public boolean isTopicDeployed(String topicName) {
        ConcurrentHashSet<String> deploySet = this.topicName2RecordCache.get(topicName);
        return deploySet != null && !deploySet.isEmpty();
    }

    @Override
    public List<TopicDeployEntity> getTopicConf(TopicDeployEntity qryEntity) {
        ArrayList<TopicDeployEntity> retEntities = new ArrayList<TopicDeployEntity>();
        if (qryEntity == null) {
            retEntities.addAll(this.topicDeployCache.values());
        } else {
            for (TopicDeployEntity entity : this.topicDeployCache.values()) {
                if (entity == null || !entity.isMatched(qryEntity, true)) continue;
                retEntities.add(entity);
            }
        }
        return retEntities;
    }

    @Override
    public TopicDeployEntity getTopicConf(int brokerId, String topicName) {
        String recordKey = KeyBuilderUtils.buildTopicConfRecKey((int)brokerId, (String)topicName);
        return this.topicDeployCache.get(recordKey);
    }

    @Override
    public TopicDeployEntity getTopicConfByeRecKey(String recordKey) {
        return this.topicDeployCache.get(recordKey);
    }

    @Override
    public Map<String, List<TopicDeployEntity>> getTopicConfMap(Set<String> topicNameSet, Set<Integer> brokerIdSet, TopicDeployEntity qryEntity) {
        HashMap<String, List<TopicDeployEntity>> retEntityMap = new HashMap<String, List<TopicDeployEntity>>();
        Set<String> matchedKeySet = this.getMatchedRecords(topicNameSet, brokerIdSet);
        if (matchedKeySet == null) {
            for (TopicDeployEntity entry : this.topicDeployCache.values()) {
                if (entry == null || qryEntity != null && !entry.isMatched(qryEntity, true)) continue;
                List items = retEntityMap.computeIfAbsent(entry.getTopicName(), k -> new ArrayList());
                items.add(entry);
            }
        } else {
            for (String recKey : matchedKeySet) {
                TopicDeployEntity entry = this.topicDeployCache.get(recKey);
                if (entry == null || qryEntity != null && !entry.isMatched(qryEntity, true)) continue;
                List items = retEntityMap.computeIfAbsent(entry.getTopicName(), k -> new ArrayList());
                items.add(entry);
            }
        }
        return retEntityMap;
    }

    @Override
    public Map<Integer, List<TopicDeployEntity>> getTopicDeployInfoMap(Set<String> topicNameSet, Set<Integer> brokerIdSet) {
        Set<String> matchedKeySet;
        HashMap<Integer, List<TopicDeployEntity>> retEntityMap = new HashMap<Integer, List<TopicDeployEntity>>();
        if (brokerIdSet != null) {
            for (Integer brokerId : brokerIdSet) {
                retEntityMap.put(brokerId, new ArrayList());
            }
        }
        if ((matchedKeySet = this.getMatchedRecords(topicNameSet, brokerIdSet)) == null) {
            matchedKeySet = new HashSet<String>(this.topicDeployCache.keySet());
        }
        for (String recordKey : matchedKeySet) {
            TopicDeployEntity entity = this.topicDeployCache.get(recordKey);
            if (entity == null) continue;
            List items = retEntityMap.computeIfAbsent(entity.getBrokerId(), k -> new ArrayList());
            items.add(entity);
        }
        return retEntityMap;
    }

    @Override
    public Map<String, List<TopicDeployEntity>> getTopicConfMapByTopicAndBrokerIds(Set<String> topicSet, Set<Integer> brokerIdSet) {
        HashMap<String, List<TopicDeployEntity>> retEntityMap = new HashMap<String, List<TopicDeployEntity>>();
        Set<String> matchedKeySet = this.getMatchedRecords(topicSet, brokerIdSet);
        if (matchedKeySet == null) {
            for (TopicDeployEntity entity : this.topicDeployCache.values()) {
                if (entity == null) continue;
                List itemLst = retEntityMap.computeIfAbsent(entity.getTopicName(), k -> new ArrayList());
                itemLst.add(entity);
            }
        } else {
            for (String key : matchedKeySet) {
                TopicDeployEntity tmpEntity = this.topicDeployCache.get(key);
                if (tmpEntity == null) continue;
                List itemLst = retEntityMap.computeIfAbsent(tmpEntity.getTopicName(), k -> new ArrayList());
                itemLst.add(tmpEntity);
            }
        }
        return retEntityMap;
    }

    @Override
    public Map<String, TopicDeployEntity> getConfiguredTopicInfo(int brokerId) {
        HashMap<String, TopicDeployEntity> retEntityMap = new HashMap<String, TopicDeployEntity>();
        ConcurrentHashSet<String> records = this.brokerId2RecordCache.get(brokerId);
        if (records == null || records.isEmpty()) {
            return retEntityMap;
        }
        for (String key : records) {
            TopicDeployEntity tmpEntity = this.topicDeployCache.get(key);
            if (tmpEntity == null) continue;
            retEntityMap.put(tmpEntity.getTopicName(), tmpEntity);
        }
        return retEntityMap;
    }

    @Override
    public Map<Integer, Set<String>> getConfiguredTopicInfo(Set<Integer> brokerIdSet) {
        HashMap<Integer, Set<String>> retEntityMap = new HashMap<Integer, Set<String>>();
        if (brokerIdSet == null || brokerIdSet.isEmpty()) {
            for (Map.Entry<Integer, ConcurrentHashSet<String>> entry : this.brokerId2TopicNameCache.entrySet()) {
                if (entry.getKey() == null) continue;
                HashSet topicSet = new HashSet();
                if (entry.getValue() != null) {
                    topicSet.addAll((Collection)entry.getValue());
                }
                retEntityMap.put(entry.getKey(), topicSet);
            }
        } else {
            for (Integer brokerId : brokerIdSet) {
                if (brokerId == null) continue;
                HashSet<String> topicSet = new HashSet<String>();
                ConcurrentHashSet<String> deploySet = this.brokerId2TopicNameCache.get(brokerId);
                if (deploySet != null) {
                    topicSet.addAll((Collection<String>)deploySet);
                }
                retEntityMap.put(brokerId, topicSet);
            }
        }
        return retEntityMap;
    }

    @Override
    public Map<String, Map<Integer, String>> getTopicBrokerInfo(Set<String> topicNameSet) {
        HashMap<String, Map<Integer, String>> retEntityMap = new HashMap<String, Map<Integer, String>>();
        if (topicNameSet == null || topicNameSet.isEmpty()) {
            for (TopicDeployEntity entry : this.topicDeployCache.values()) {
                if (entry == null) continue;
                Map brokerInfoMap = retEntityMap.computeIfAbsent(entry.getTopicName(), k -> new HashMap());
                brokerInfoMap.put(entry.getBrokerId(), entry.getBrokerIp());
            }
        } else {
            for (String topicName : topicNameSet) {
                if (topicName == null) continue;
                Map brokerInfoMap = retEntityMap.computeIfAbsent(topicName, k -> new HashMap());
                ConcurrentHashSet<String> keySet = this.topicName2RecordCache.get(topicName);
                if (keySet == null) continue;
                for (String key : keySet) {
                    TopicDeployEntity entry = this.topicDeployCache.get(key);
                    if (entry == null) continue;
                    brokerInfoMap.put(entry.getBrokerId(), entry.getBrokerIp());
                }
            }
        }
        return retEntityMap;
    }

    @Override
    public Set<Integer> getDeployedBrokerIdByTopic(Set<String> topicNameSet) {
        HashSet<Integer> retSet = new HashSet<Integer>();
        if (topicNameSet == null || topicNameSet.isEmpty()) {
            return retSet;
        }
        for (String topicName : topicNameSet) {
            ConcurrentHashSet<String> keySet;
            if (topicName == null || (keySet = this.topicName2RecordCache.get(topicName)) == null) continue;
            for (String key : keySet) {
                TopicDeployEntity entry = this.topicDeployCache.get(key);
                if (entry == null) continue;
                retSet.add(entry.getBrokerId());
            }
        }
        return retSet;
    }

    @Override
    public Set<String> getDeployedTopicSet() {
        return new HashSet<String>(this.topicName2RecordCache.keySet());
    }

    protected void clearCachedData() {
        this.topicName2RecordCache.clear();
        this.brokerId2RecordCache.clear();
        this.brokerId2TopicNameCache.clear();
        this.topicDeployCache.clear();
    }

    protected void putRecord2Caches(TopicDeployEntity entity) {
        ConcurrentHashSet<String> tmpSet;
        this.topicDeployCache.put(entity.getRecordKey(), entity);
        ConcurrentHashSet<String> keySet = this.topicName2RecordCache.get(entity.getTopicName());
        if (keySet == null) {
            tmpSet = new ConcurrentHashSet<String>();
            keySet = this.topicName2RecordCache.putIfAbsent(entity.getTopicName(), tmpSet);
            if (keySet == null) {
                keySet = tmpSet;
            }
        }
        keySet.add((Object)entity.getRecordKey());
        keySet = this.brokerId2RecordCache.get(entity.getBrokerId());
        if (keySet == null) {
            tmpSet = new ConcurrentHashSet();
            keySet = this.brokerId2RecordCache.putIfAbsent(entity.getBrokerId(), tmpSet);
            if (keySet == null) {
                keySet = tmpSet;
            }
        }
        keySet.add((Object)entity.getRecordKey());
        keySet = this.brokerId2TopicNameCache.get(entity.getBrokerId());
        if (keySet == null) {
            tmpSet = new ConcurrentHashSet<String>();
            keySet = this.brokerId2TopicNameCache.putIfAbsent(entity.getBrokerId(), tmpSet);
            if (keySet == null) {
                keySet = tmpSet;
            }
        }
        keySet.add((Object)entity.getTopicName());
    }

    protected abstract boolean putConfig2Persistent(TopicDeployEntity var1, StringBuilder var2, ProcessResult var3);

    protected abstract boolean delConfigFromPersistent(String var1, StringBuilder var2);

    private void delRecordFromCaches(String recordKey) {
        TopicDeployEntity curEntity = this.topicDeployCache.remove(recordKey);
        if (curEntity == null) {
            return;
        }
        ConcurrentHashSet<String> keySet = this.topicName2RecordCache.get(curEntity.getTopicName());
        if (keySet != null) {
            keySet.remove((Object)recordKey);
            if (keySet.isEmpty()) {
                this.topicName2RecordCache.remove(curEntity.getTopicName(), new ConcurrentHashSet());
            }
        }
        if ((keySet = this.brokerId2RecordCache.get(curEntity.getBrokerId())) != null) {
            keySet.remove((Object)recordKey);
            if (keySet.isEmpty()) {
                this.brokerId2RecordCache.remove(curEntity.getBrokerId(), new ConcurrentHashSet());
            }
        }
        if ((keySet = this.brokerId2TopicNameCache.get(curEntity.getBrokerId())) != null) {
            keySet.remove((Object)curEntity.getTopicName());
            if (keySet.isEmpty()) {
                this.brokerId2TopicNameCache.remove(curEntity.getBrokerId(), new ConcurrentHashSet());
            }
        }
    }

    private Set<String> getMatchedRecords(Set<String> topicNameSet, Set<Integer> brokerIdSet) {
        ConcurrentHashSet<String> keySet;
        HashSet<String> topicKeySet = null;
        HashSet<String> brokerKeySet = null;
        HashSet<String> matchedKeySet = null;
        if (topicNameSet != null && !topicNameSet.isEmpty()) {
            topicKeySet = new HashSet<String>();
            for (String topicName : topicNameSet) {
                keySet = this.topicName2RecordCache.get(topicName);
                if (keySet == null || keySet.isEmpty()) continue;
                topicKeySet.addAll((Collection<String>)keySet);
            }
            if (topicKeySet.isEmpty()) {
                return Collections.emptySet();
            }
        }
        if (brokerIdSet != null && !brokerIdSet.isEmpty()) {
            brokerKeySet = new HashSet<String>();
            for (Integer brokerId : brokerIdSet) {
                keySet = this.brokerId2RecordCache.get(brokerId);
                if (keySet == null || keySet.isEmpty()) continue;
                brokerKeySet.addAll((Collection<String>)keySet);
            }
            if (brokerKeySet.isEmpty()) {
                return Collections.emptySet();
            }
        }
        if (topicKeySet != null || brokerKeySet != null) {
            if (topicKeySet == null) {
                matchedKeySet = new HashSet<String>(brokerKeySet);
            } else if (brokerKeySet == null) {
                matchedKeySet = new HashSet(topicKeySet);
            } else {
                matchedKeySet = new HashSet();
                for (String record : topicKeySet) {
                    if (!brokerKeySet.contains(record)) continue;
                    matchedKeySet.add(record);
                }
            }
        }
        return matchedKeySet;
    }

    private boolean isValidValuesChange(TopicDeployEntity newEntity, TopicDeployEntity curEntity, StringBuilder strBuff, ProcessResult result) {
        if (newEntity.getNumPartitions() != -2 && newEntity.getNumPartitions() < curEntity.getNumPartitions()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), strBuff.append("Partition number less than before,").append(" new value is ").append(newEntity.getNumPartitions()).append(", current value is ").append(curEntity.getNumPartitions()).append("in brokerId-topicName(").append(curEntity.getRecordKey()).append(") record!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (newEntity.getNumTopicStores() != -2 && newEntity.getNumTopicStores() < curEntity.getNumTopicStores()) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), strBuff.append("TopicStores number less than before,").append(" new value is ").append(newEntity.getNumTopicStores()).append(", current value is ").append(curEntity.getNumTopicStores()).append("in brokerId-topicName(").append(curEntity.getRecordKey()).append(") record!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (newEntity.getTopicStatus() == curEntity.getTopicStatus()) {
            if (!newEntity.isValidTopicStatus()) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("Softly deleted record cannot be changed,").append(" please resume or hard remove for brokerId-topicName(").append(newEntity.getRecordKey()).append(") record!").toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            return true;
        }
        if (curEntity.isValidTopicStatus() && !newEntity.isValidTopicStatus()) {
            if (curEntity.isAcceptPublish() || curEntity.isAcceptSubscribe()) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The values of acceptPublish and acceptSubscribe must be false").append(" before change status of brokerId-topicName(").append(curEntity.getRecordKey()).append(") record!").toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            if (newEntity.getTopicStatus().getCode() > TopicStatus.STATUS_TOPIC_SOFT_DELETE.getCode()) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("Please softly deleted the brokerId-topicName(").append(newEntity.getRecordKey()).append(") record first!").toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            return true;
        }
        if (!curEntity.isValidTopicStatus() && !newEntity.isValidTopicStatus()) {
            if (!(curEntity.getTopicStatus() == TopicStatus.STATUS_TOPIC_SOFT_DELETE && newEntity.getTopicStatus() == TopicStatus.STATUS_TOPIC_SOFT_REMOVE || curEntity.getTopicStatus() == TopicStatus.STATUS_TOPIC_SOFT_REMOVE && newEntity.getTopicStatus() == TopicStatus.STATUS_TOPIC_HARD_REMOVE)) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("Illegal transfer status from ").append(curEntity.getTopicStatus().getDescription()).append(" to ").append(newEntity.getTopicStatus().getDescription()).append(" for the brokerId-topicName(").append(newEntity.getRecordKey()).append(") record!").toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            if (newEntity.isAcceptPublish() || newEntity.isAcceptSubscribe()) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The values of acceptPublish and acceptSubscribe must be false").append(" before change status of brokerId-topicName(").append(newEntity.getRecordKey()).append(") record!").toString());
                strBuff.delete(0, strBuff.length());
                return result.isSuccess();
            }
            return true;
        }
        if (!curEntity.isValidTopicStatus() && newEntity.isValidTopicStatus()) {
            if (curEntity.getTopicStatus() != TopicStatus.STATUS_TOPIC_SOFT_DELETE) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("Illegal transfer status from ").append(curEntity.getTopicStatus().getDescription()).append(" to ").append(newEntity.getTopicStatus().getDescription()).append(" for the brokerId-topicName(").append(newEntity.getRecordKey()).append(") record!").toString());
                strBuff.delete(0, strBuff.length());
                return !result.isSuccess();
            }
            if (newEntity.isAcceptPublish() || newEntity.isAcceptSubscribe()) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("The values of acceptPublish and acceptSubscribe must be false").append(" before change status of brokerId-topicName(").append(newEntity.getRecordKey()).append(") record!").toString());
                strBuff.delete(0, strBuff.length());
                return !result.isSuccess();
            }
            return false;
        }
        return false;
    }

    private boolean isValidSysTopicConf(TopicDeployEntity deployEntity, StringBuilder strBuff, ProcessResult result) {
        if (!"__offset_history__".equals(deployEntity.getTopicName())) {
            return true;
        }
        if (deployEntity.getNumTopicStores() != 1) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), strBuff.append("For system topic").append("__offset_history__").append(", the TopicStores value(").append(1).append(") cannot be changed!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        if (deployEntity.getNumPartitions() != 10) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), strBuff.append("For system topic").append("__offset_history__").append(", the Partition value(").append(10).append(") cannot be changed!").toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        return true;
    }
}

