/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.common.utils.RowLock;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.ConfigObserver;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.BrokerConfigMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.ClusterConfigMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.ConsumeCtrlMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.GroupResCtrlMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.MetaConfigMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.TopicCtrlMapper;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.TopicDeployMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsMetaConfigMapperImpl
implements MetaConfigMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsMetaConfigMapperImpl.class);
    protected final MasterConfig masterConfig;
    protected final AtomicInteger srvStatus = new AtomicInteger(0);
    protected volatile boolean isMaster = false;
    protected final AtomicLong masterSinceTime = new AtomicLong(Long.MAX_VALUE);
    private final RowLock metaRowLock;
    private static final ClusterSettingEntity defClusterSetting = new ClusterSettingEntity().fillDefaultValue();
    protected ClusterConfigMapper clusterConfigMapper;
    protected BrokerConfigMapper brokerConfigMapper;
    protected TopicDeployMapper topicDeployMapper;
    protected TopicCtrlMapper topicCtrlMapper;
    protected GroupResCtrlMapper groupResCtrlMapper;
    protected ConsumeCtrlMapper consumeCtrlMapper;
    private final List<ConfigObserver> eventObservers = new ArrayList<ConfigObserver>();

    public AbsMetaConfigMapperImpl(MasterConfig masterConfig) {
        this.masterConfig = masterConfig;
        this.metaRowLock = new RowLock("MetaData-RowLock", masterConfig.getRowLockWaitDurMs());
    }

    @Override
    public void regMetaConfigObserver(ConfigObserver eventObserver) {
        if (eventObserver != null) {
            this.eventObservers.add(eventObserver);
        }
    }

    @Override
    public boolean checkStoreStatus(boolean checkIsMaster, ProcessResult result) {
        if (!this.isServiceStarted()) {
            result.setFailResult(DataOpErrCode.DERR_STORE_STOPPED.getCode(), "Meta store service stopped!");
            return result.isSuccess();
        }
        if (checkIsMaster && !this.isMasterNow()) {
            result.setFailResult(DataOpErrCode.DERR_STORE_NOT_MASTER.getCode(), "Current node not active, please send your request to the active Node!");
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOrUpdClusterDefSetting(BaseEntity opEntity, int brokerPort, int brokerTlsPort, int brokerWebPort, int maxMsgSizeMB, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlInfo, TopicPropGroup topicProps, StringBuilder strBuff, ProcessResult result) {
        ClusterSettingEntity newEntity;
        ClusterSettingEntity curEntity;
        Integer lid = null;
        boolean isAddOp = false;
        String printPrefix = "[updClusterConfig], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)"clusterConfig#"), true);
            curEntity = this.clusterConfigMapper.getClusterConfig();
            if (curEntity == null) {
                isAddOp = true;
                printPrefix = "[addClusterConfig], ";
                newEntity = new ClusterSettingEntity(opEntity);
                newEntity.fillDefaultValue();
                newEntity.updModifyInfo(opEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, maxMsgSizeMB, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, topicProps);
            } else {
                newEntity = curEntity.clone();
                newEntity.updBaseModifyInfo(opEntity);
                if (!newEntity.updModifyInfo(opEntity.getDataVerId(), brokerPort, brokerTlsPort, brokerWebPort, maxMsgSizeMB, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlInfo, topicProps)) {
                    result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Cluster configure not changed!");
                    boolean bl = result.isSuccess();
                    return bl;
                }
            }
            this.clusterConfigMapper.addUpdClusterConfig(newEntity, strBuff, result);
        }
        catch (Throwable e) {
            boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
            return bl;
        }
        finally {
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        if (result.isSuccess()) {
            if (isAddOp) {
                strBuff.append(printPrefix).append(newEntity.getCreateUser()).append(" added cluster configure: ").append(newEntity);
            } else {
                strBuff.append(printPrefix).append(newEntity.getModifyUser()).append(" updated cluster configure: from ").append(curEntity).append(" to ").append(newEntity);
            }
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public ClusterSettingEntity getClusterDefSetting(boolean isMustConf) {
        ClusterSettingEntity curClsSetting = this.clusterConfigMapper.getClusterConfig();
        if (!isMustConf && curClsSetting == null) {
            curClsSetting = defClusterSetting;
        }
        return curClsSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOrUpdBrokerConfig(boolean isAddOp, BrokerConfEntity entity, StringBuilder strBuff, ProcessResult result) {
        BrokerConfEntity newEntity;
        Integer lid = null;
        BrokerConfEntity curEntity = null;
        String printPrefix = "[addBrokerConf], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)String.valueOf(entity.getBrokerId())), true);
            if (isAddOp) {
                newEntity = new BrokerConfEntity(entity, entity.getBrokerId(), entity.getBrokerIp(), this.getClusterDefSetting(false));
                newEntity.updModifyInfo(entity.getDataVerId(), entity.getBrokerPort(), entity.getBrokerTLSPort(), entity.getBrokerWebPort(), entity.getRegionId(), entity.getGroupId(), entity.getManageStatus(), entity.getTopicProps());
                this.brokerConfigMapper.addBrokerConf(newEntity, strBuff, result);
            } else {
                printPrefix = "[updBrokerConf], ";
                curEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(entity.getBrokerId());
                this.brokerConfigMapper.updBrokerConf(entity, strBuff, result);
            }
            newEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(entity.getBrokerId());
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        catch (Throwable e) {
            try {
                boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                throw throwable;
            }
        }
        if (result.isSuccess()) {
            if (isAddOp) {
                strBuff.append(printPrefix).append(entity.getCreateUser()).append(" added broker configure: ").append(newEntity);
            } else {
                strBuff.append(printPrefix).append(entity.getModifyUser()).append(" updated broker configure from ").append(curEntity).append(" to ").append(newEntity);
            }
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeBrokerConfStatus(BaseEntity opEntity, int brokerId, ManageStatus newMngStatus, StringBuilder strBuff, ProcessResult result) {
        BrokerConfEntity newEntity;
        BrokerConfEntity curEntity;
        Integer lid = null;
        String printPrefix = "[updBrokerConf], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)String.valueOf(brokerId)), true);
            curEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(brokerId);
            this.brokerConfigMapper.updBrokerMngStatus(opEntity, brokerId, newMngStatus, strBuff, result);
            newEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(brokerId);
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        catch (Throwable e) {
            try {
                boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                throw throwable;
            }
        }
        if (result.isSuccess()) {
            strBuff.append(printPrefix).append(opEntity.getModifyUser()).append(" updated broker configure from ").append(curEntity).append(" to ").append(newEntity);
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean delBrokerConfInfo(String operator, int brokerId, boolean rsvData, StringBuilder strBuff, ProcessResult result) {
        block18: {
            block19: {
                block17: {
                    block16: {
                        lid = null;
                        printPrefix = "[delBrokerConf], ";
                        lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)String.valueOf(brokerId)), true);
                        curEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(brokerId);
                        if (curEntity != null) break block16;
                        result.setSuccResult(null);
                        var9_9 = result.isSuccess();
                        if (lid != null) {
                            this.metaRowLock.releaseRowLock(lid);
                        }
                        return var9_9;
                    }
                    if (!curEntity.getManageStatus().isOnlineStatus()) break block17;
                    result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("Illegal manage status, please offline the broker(").append(WebFieldDef.BROKERID.name).append("=").append(curEntity.getBrokerId()).append(") first!").toString());
                    strBuff.delete(0, strBuff.length());
                    var9_10 = result.isSuccess();
                    if (lid != null) {
                        this.metaRowLock.releaseRowLock(lid);
                    }
                    return var9_10;
                }
                if (this.topicDeployMapper.getConfiguredTopicInfo(curEntity.getBrokerId()).isEmpty()) break block18;
                if (!rsvData) ** GOTO lbl39
                if (this.topicDeployMapper.delTopicConfByBrokerId(brokerId, strBuff, result)) break block19;
                var9_11 = result.isSuccess();
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                return var9_11;
            }
            strBuff.append("[delTopicDeployByBrokerId], ").append(operator).append(" deleted topic deploy configure: ").append(brokerId);
            AbsMetaConfigMapperImpl.logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
            break block18;
lbl39:
            // 1 sources

            result.setFailResult(DataOpErrCode.DERR_UNCLEANED.getCode(), strBuff.append("Illegal operate conditions, the broker(").append(curEntity.getBrokerId()).append(")'s topic deploy configure uncleaned, please delete them first!").toString());
            strBuff.delete(0, strBuff.length());
            var9_12 = result.isSuccess();
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
            return var9_12;
        }
        try {
            this.brokerConfigMapper.delBrokerConf(brokerId, strBuff, result);
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        catch (Throwable e) {
            try {
                var10_14 = this.logExceptionInfo(e, printPrefix, strBuff, result);
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                return var10_14;
            }
            catch (Throwable var11_15) {
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                throw var11_15;
            }
        }
        if (result.isSuccess()) {
            strBuff.append(printPrefix).append(operator).append(" deleted broker configure: ").append(curEntity);
            AbsMetaConfigMapperImpl.logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public Map<Integer, BrokerConfEntity> getBrokerConfInfo(BrokerConfEntity qryEntity) {
        return this.brokerConfigMapper.getBrokerConfInfo(qryEntity);
    }

    @Override
    public Map<Integer, BrokerConfEntity> getBrokerConfInfo(Set<Integer> brokerIdSet, Set<String> brokerIpSet, BrokerConfEntity qryEntity) {
        return this.brokerConfigMapper.getBrokerConfInfo(brokerIdSet, brokerIpSet, qryEntity);
    }

    @Override
    public BrokerConfEntity getBrokerConfByBrokerId(int brokerId) {
        return this.brokerConfigMapper.getBrokerConfByBrokerId(brokerId);
    }

    @Override
    public BrokerConfEntity getBrokerConfByBrokerIp(String brokerIp) {
        return this.brokerConfigMapper.getBrokerConfByBrokerIp(brokerIp);
    }

    @Override
    public boolean addOrUpdTopicCtrlConf(boolean isAddOp, TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        return this.innAddOrUpdTopicCtrlConf(true, isAddOp, entity, strBuff, result);
    }

    @Override
    public boolean insertTopicCtrlConf(BaseEntity opEntity, String topicName, EnableStatus enableTopicAuth, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity entity = new TopicCtrlEntity(opEntity, topicName);
        entity.updModifyInfo(opEntity.getDataVerId(), -2, -2, enableTopicAuth);
        return this.innAddOrUpdTopicCtrlConf(false, false, entity, strBuff, result);
    }

    @Override
    public boolean insertTopicCtrlConf(TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        return this.innAddOrUpdTopicCtrlConf(false, false, entity, strBuff, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delTopicCtrlConf(String operator, String topicName, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity curEntity;
        Integer lid = null;
        String printPrefix = "[delTopicCtrlConf], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)topicName), true);
            curEntity = this.topicCtrlMapper.getTopicCtrlConf(topicName);
            if (curEntity == null) {
                result.setSuccResult(null);
                boolean bl = result.isSuccess();
                return bl;
            }
            if (this.topicDeployMapper.isTopicDeployed(topicName)) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("TopicName ").append(topicName).append(" is in use, please delete deploy configure first!").toString());
                strBuff.delete(0, strBuff.length());
                boolean bl = result.isSuccess();
                return bl;
            }
            if (this.consumeCtrlMapper.isTopicNameInUse(topicName)) {
                result.setFailResult(DataOpErrCode.DERR_ILLEGAL_STATUS.getCode(), strBuff.append("TopicName ").append(topicName).append(" is in use, please delete the consume control first!").toString());
                strBuff.delete(0, strBuff.length());
                boolean bl = result.isSuccess();
                return bl;
            }
            this.topicCtrlMapper.delTopicCtrlConf(topicName, strBuff, result);
        }
        catch (Throwable e) {
            boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
            return bl;
        }
        finally {
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        if (result.isSuccess()) {
            strBuff.append(printPrefix).append(operator).append(" deleted topic control configure: ").append(curEntity);
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public TopicCtrlEntity getTopicCtrlByTopicName(String topicName) {
        return this.topicCtrlMapper.getTopicCtrlConf(topicName);
    }

    @Override
    public int getTopicMaxMsgSizeInMB(String topicName) {
        ClusterSettingEntity clusterSettingEntity = this.getClusterDefSetting(false);
        int maxMsgSizeInMB = clusterSettingEntity.getMaxMsgSizeInMB();
        TopicCtrlEntity topicCtrlEntity = this.topicCtrlMapper.getTopicCtrlConf(topicName);
        if (topicCtrlEntity != null && topicCtrlEntity.getMaxMsgSizeInMB() != -2) {
            maxMsgSizeInMB = topicCtrlEntity.getMaxMsgSizeInMB();
        }
        return maxMsgSizeInMB;
    }

    @Override
    public List<TopicCtrlEntity> queryTopicCtrlConf(TopicCtrlEntity qryEntity) {
        return this.topicCtrlMapper.getTopicCtrlConf(qryEntity);
    }

    @Override
    public Map<String, TopicCtrlEntity> getTopicCtrlConf(Set<String> topicNameSet, TopicCtrlEntity qryEntity) {
        return this.topicCtrlMapper.getTopicCtrlConf(topicNameSet, qryEntity);
    }

    @Override
    public Map<String, Integer> getMaxMsgSizeInBByTopics(int defMaxMsgSizeInB, Set<String> topicNameSet) {
        return this.topicCtrlMapper.getMaxMsgSizeInBByTopics(defMaxMsgSizeInB, topicNameSet);
    }

    private boolean addTopicCtrlConfIfAbsent(BaseEntity opEntity, String topicName, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity entity = new TopicCtrlEntity(opEntity, topicName, -2, -2);
        return this.innAddOrUpdTopicCtrlConf(false, true, entity, strBuff, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean innAddOrUpdTopicCtrlConf(boolean chkConsistent, boolean isAddOpOrOnlyAdd, TopicCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        TopicCtrlEntity newEntity;
        TopicCtrlEntity curEntity;
        Integer lid = null;
        boolean addRecord = true;
        String printPrefix = "[addTopicCtrlConf], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)entity.getTopicName()), true);
            curEntity = this.topicCtrlMapper.getTopicCtrlConf(entity.getTopicName());
            if (curEntity == null) {
                if (chkConsistent && !isAddOpOrOnlyAdd) {
                    result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found topic control configure for topicName(").append(entity.getTopicName()).append(")!").toString());
                    strBuff.delete(0, strBuff.length());
                    boolean bl = result.isSuccess();
                    if (lid != null) {
                        this.metaRowLock.releaseRowLock(lid);
                    }
                    return bl;
                }
                entity.fillEmptyValues(this.getClusterDefSetting(false));
                this.topicCtrlMapper.addTopicCtrlConf(entity, strBuff, result);
            } else {
                if (isAddOpOrOnlyAdd) {
                    if (chkConsistent) {
                        result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for topicName(").append(entity.getTopicName()).append(")!").toString());
                        strBuff.delete(0, strBuff.length());
                    } else {
                        result.setSuccResult(null);
                    }
                    boolean bl = result.isSuccess();
                    if (lid != null) {
                        this.metaRowLock.releaseRowLock(lid);
                    }
                    return bl;
                }
                addRecord = false;
                printPrefix = "[udpTopicCtrlConf], ";
                this.topicCtrlMapper.updTopicCtrlConf(entity, strBuff, result);
            }
            newEntity = this.topicCtrlMapper.getTopicCtrlConf(entity.getTopicName());
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        catch (Throwable e) {
            try {
                boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                throw throwable;
            }
        }
        if (result.isSuccess()) {
            if (addRecord) {
                strBuff.append(printPrefix).append(entity.getCreateUser()).append(" added topic control configure: ").append(newEntity);
            } else {
                strBuff.append(printPrefix).append(entity.getModifyUser()).append(" updated topic control configure from ").append(curEntity).append(" to ").append(newEntity);
            }
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public void addSystemTopicDeploy(int brokerId, int brokerPort, String brokerIp, StringBuilder strBuff) {
        BaseEntity opEntity = new BaseEntity("systemSelf", new Date());
        TopicPropGroup topicPropInfo = new TopicPropGroup();
        topicPropInfo.setNumTopicStores(1);
        topicPropInfo.setNumPartitions(10);
        TopicDeployEntity entity = new TopicDeployEntity(opEntity, brokerId, "__offset_history__");
        entity.updModifyInfo(opEntity.getDataVerId(), -2, brokerPort, brokerIp, TopicStatus.STATUS_TOPIC_OK, topicPropInfo);
        this.addOrUpdTopicDeployInfo(true, entity, strBuff, new ProcessResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addOrUpdTopicDeployInfo(boolean isAddOp, TopicDeployEntity entity, StringBuilder strBuff, ProcessResult result) {
        block28: {
            printPrefix = "[addTopicDeployConf], ";
            topicLockId = null;
            brokerLockId = null;
            opEntity = new BaseEntity("systemSelf", new Date());
            this.addTopicCtrlConfIfAbsent(opEntity, entity.getTopicName(), strBuff, result);
            try {
                topicLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)entity.getTopicName()), true);
                try {
                    brokerLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)String.valueOf(entity.getBrokerId())), true);
                    brokerEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(entity.getBrokerId());
                    if (brokerEntity == null) {
                        result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found broker configure by brokerId=").append(entity.getBrokerId()).append(", please create the broker's configure first!").toString());
                        strBuff.delete(0, strBuff.length());
                        var12_11 = result.isSuccess();
                        if (brokerLockId != null) {
                            this.metaRowLock.releaseRowLock(brokerLockId);
                        }
                        if (topicLockId != null) {
                            this.metaRowLock.releaseRowLock(topicLockId);
                        }
                        return var12_11;
                    }
                }
                catch (Throwable var13_18) {
                    if (brokerLockId != null) {
                        this.metaRowLock.releaseRowLock(brokerLockId);
                    }
                    throw var13_18;
                }
            }
            catch (Throwable e) {
                try {
                    var12_15 = this.logExceptionInfo(e, printPrefix, strBuff, result);
                    if (topicLockId != null) {
                        this.metaRowLock.releaseRowLock(topicLockId);
                    }
                    return var12_15;
                }
                catch (Throwable var14_19) {
                    if (topicLockId != null) {
                        this.metaRowLock.releaseRowLock(topicLockId);
                    }
                    throw var14_19;
                }
            }
            {
                curEntity = this.topicDeployMapper.getTopicConfByeRecKey(entity.getRecordKey());
                if (!isAddOp) ** GOTO lbl61
                if (curEntity == null) ** GOTO lbl-1000
                if (curEntity.isValidTopicStatus()) {
                    result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for brokerId-topicName(").append(curEntity.getRecordKey()).append(")!").toString());
                } else {
                    result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Softly deleted record found for brokerId-topicName(").append(curEntity.getRecordKey()).append("), please resume or remove it first!").toString());
                }
                strBuff.delete(0, strBuff.length());
                var12_12 = result.isSuccess();
                if (brokerLockId != null) {
                    this.metaRowLock.releaseRowLock(brokerLockId);
                }
                if (topicLockId != null) {
                    this.metaRowLock.releaseRowLock(topicLockId);
                }
                return var12_12;
            }
lbl-1000:
            // 1 sources

            {
                newProps = this.getClusterDefSetting(false).getClsDefTopicProps().clone();
                newProps.updModifyInfo(brokerEntity.getTopicProps());
                newEntity = new TopicDeployEntity(entity, entity.getBrokerId(), entity.getTopicName(), newProps);
                newEntity.updModifyInfo(entity.getDataVerId(), entity.getTopicId(), brokerEntity.getBrokerPort(), brokerEntity.getBrokerIp(), entity.getTopicStatus(), entity.getTopicProps());
                this.topicDeployMapper.addTopicDeployConf(newEntity, strBuff, result);
                ** GOTO lbl74
lbl61:
                // 1 sources

                printPrefix = "[updTopicDeployConf], ";
                if (curEntity != null) ** GOTO lbl-1000
                result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found topic deploy configure for brokerId-topicName(").append(entity.getRecordKey()).append(")!").toString());
                strBuff.delete(0, strBuff.length());
                var12_14 = result.isSuccess();
                if (brokerLockId != null) {
                    this.metaRowLock.releaseRowLock(brokerLockId);
                }
                if (topicLockId != null) {
                    this.metaRowLock.releaseRowLock(topicLockId);
                }
                return var12_14;
            }
lbl-1000:
            // 1 sources

            {
                this.topicDeployMapper.updTopicDeployConf(entity, strBuff, result);
lbl74:
                // 2 sources

                newEntity = this.topicDeployMapper.getTopicConfByeRecKey(entity.getRecordKey());
                if (brokerLockId == null) break block28;
                this.metaRowLock.releaseRowLock(brokerLockId);
            }
        }
        if (topicLockId != null) {
            this.metaRowLock.releaseRowLock(topicLockId);
        }
        if (result.isSuccess()) {
            if (isAddOp) {
                strBuff.append(printPrefix).append(entity.getCreateUser()).append(" added topic deploy configure: ").append(newEntity);
            } else {
                strBuff.append(printPrefix).append(entity.getModifyUser()).append(" updated topic deploy configure from ").append(curEntity).append(" to ").append(newEntity);
            }
            AbsMetaConfigMapperImpl.logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updTopicDeployStatusInfo(BaseEntity opEntity, int brokerId, String topicName, TopicStatus topicStatus, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity newEntity;
        TopicDeployEntity curEntity;
        String printPrefix = "[updTopicDeployConf], ";
        Integer topicLockId = null;
        Integer brokerLockId = null;
        try {
            block22: {
                block21: {
                    block20: {
                        topicLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)topicName), true);
                        try {
                            brokerLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)String.valueOf(brokerId)), true);
                            BrokerConfEntity brokerEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(brokerId);
                            if (brokerEntity != null) break block20;
                            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found broker configure by brokerId=").append(brokerId).append(", please create the broker's configure first!").toString());
                            strBuff.delete(0, strBuff.length());
                            boolean bl = result.isSuccess();
                            if (brokerLockId != null) {
                                this.metaRowLock.releaseRowLock(brokerLockId);
                            }
                            return bl;
                        }
                        catch (Throwable throwable) {
                            if (brokerLockId != null) {
                                this.metaRowLock.releaseRowLock(brokerLockId);
                            }
                            throw throwable;
                        }
                    }
                    curEntity = this.topicDeployMapper.getTopicConf(brokerId, topicName);
                    if (curEntity != null) break block21;
                    result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found topic deploy configure for brokerId-topicName(").append(brokerId).append("-").append(topicName).append(")!").toString());
                    strBuff.delete(0, strBuff.length());
                    boolean bl = result.isSuccess();
                    if (brokerLockId != null) {
                        this.metaRowLock.releaseRowLock(brokerLockId);
                    }
                    return bl;
                }
                if (curEntity.getTopicStatus() != topicStatus) break block22;
                result.setSuccResult(null);
                boolean bl = result.isSuccess();
                if (brokerLockId != null) {
                    this.metaRowLock.releaseRowLock(brokerLockId);
                }
                return bl;
            }
            this.topicDeployMapper.updTopicDeployStatus(opEntity, brokerId, topicName, topicStatus, strBuff, result);
            newEntity = this.topicDeployMapper.getTopicConfByeRecKey(curEntity.getRecordKey());
            if (brokerLockId != null) {
                this.metaRowLock.releaseRowLock(brokerLockId);
            }
        }
        catch (Throwable e) {
            boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
            return bl;
        }
        finally {
            if (topicLockId != null) {
                this.metaRowLock.releaseRowLock(topicLockId);
            }
        }
        if (result.isSuccess()) {
            strBuff.append(printPrefix).append(opEntity.getModifyUser()).append(" updated topic deploy configure from ").append(curEntity).append(" to ").append(newEntity);
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delTopicDeployInfo(String operator, int brokerId, String topicName, StringBuilder strBuff, ProcessResult result) {
        TopicDeployEntity curEntity;
        String printPrefix = "[delTopicDeployConf], ";
        Integer topicLockId = null;
        Integer brokerLockId = null;
        try {
            block18: {
                block17: {
                    topicLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)topicName), true);
                    try {
                        brokerLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)String.valueOf(brokerId)), true);
                        BrokerConfEntity brokerEntity = this.brokerConfigMapper.getBrokerConfByBrokerId(brokerId);
                        if (brokerEntity != null) break block17;
                        result.setSuccResult(null);
                        boolean bl = result.isSuccess();
                        if (brokerLockId != null) {
                            this.metaRowLock.releaseRowLock(brokerLockId);
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        if (brokerLockId != null) {
                            this.metaRowLock.releaseRowLock(brokerLockId);
                        }
                        throw throwable;
                    }
                }
                curEntity = this.topicDeployMapper.getTopicConf(brokerId, topicName);
                if (curEntity != null) break block18;
                result.setSuccResult(null);
                boolean bl = result.isSuccess();
                if (brokerLockId != null) {
                    this.metaRowLock.releaseRowLock(brokerLockId);
                }
                return bl;
            }
            this.topicDeployMapper.delTopicDeployConf(curEntity.getRecordKey(), strBuff, result);
            if (brokerLockId != null) {
                this.metaRowLock.releaseRowLock(brokerLockId);
            }
        }
        catch (Throwable e) {
            boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
            return bl;
        }
        finally {
            if (topicLockId != null) {
                this.metaRowLock.releaseRowLock(topicLockId);
            }
        }
        if (result.isSuccess()) {
            logger.info(strBuff.append(printPrefix).append(operator).append(" deleted topic deploy configure: ").append(curEntity).toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public Map<String, List<TopicDeployEntity>> getTopicDeployInfoMap(Set<String> topicNameSet, Set<Integer> brokerIdSet, TopicDeployEntity qryEntity) {
        return this.topicDeployMapper.getTopicConfMap(topicNameSet, brokerIdSet, qryEntity);
    }

    @Override
    public Map<Integer, List<TopicDeployEntity>> getTopicDeployInfoMap(Set<String> topicNameSet, Set<Integer> brokerIdSet) {
        Map<Integer, BrokerConfEntity> qryBrokerInfoMap = this.brokerConfigMapper.getBrokerConfInfo(brokerIdSet, null, null);
        if (qryBrokerInfoMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.topicDeployMapper.getTopicDeployInfoMap(topicNameSet, qryBrokerInfoMap.keySet());
    }

    @Override
    public Map<String, List<TopicDeployEntity>> getTopicConfInfoByTopicAndBrokerIds(Set<String> topicNameSet, Set<Integer> brokerIdSet) {
        return this.topicDeployMapper.getTopicConfMapByTopicAndBrokerIds(topicNameSet, brokerIdSet);
    }

    @Override
    public Map<String, TopicDeployEntity> getConfiguredTopicInfo(int brokerId) {
        return this.topicDeployMapper.getConfiguredTopicInfo(brokerId);
    }

    @Override
    public TopicDeployEntity getConfiguredTopicInfo(int brokerId, String topicName) {
        return this.topicDeployMapper.getTopicConf(brokerId, topicName);
    }

    @Override
    public Map<Integer, Set<String>> getConfiguredTopicInfo(Set<Integer> brokerIdSet) {
        return this.topicDeployMapper.getConfiguredTopicInfo(brokerIdSet);
    }

    @Override
    public Map<String, Map<Integer, String>> getTopicBrokerInfo(Set<String> topicNameSet) {
        return this.topicDeployMapper.getTopicBrokerInfo(topicNameSet);
    }

    @Override
    public Set<Integer> getDeployedBrokerIdByTopic(Set<String> topicNameSet) {
        return this.topicDeployMapper.getDeployedBrokerIdByTopic(topicNameSet);
    }

    @Override
    public Set<String> getDeployedTopicSet() {
        return this.topicDeployMapper.getDeployedTopicSet();
    }

    @Override
    public boolean addOrUpdGroupResCtrlConf(boolean isAddOp, GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        return this.addOrUpdGroupCtrlConf(true, isAddOp, entity, strBuff, result);
    }

    @Override
    public boolean insertGroupCtrlConf(BaseEntity opEntity, String groupName, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlRuleInfo, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity newEntity = new GroupResCtrlEntity(opEntity, groupName);
        newEntity.updModifyInfo(opEntity.getDataVerId(), null, -2, qryPriorityId, flowCtrlEnable, flowRuleCnt, flowCtrlRuleInfo);
        return this.addOrUpdGroupCtrlConf(false, false, newEntity, strBuff, result);
    }

    @Override
    public boolean insertGroupCtrlConf(BaseEntity opEntity, String groupName, EnableStatus resChkEnable, int allowedB2CRate, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity newEntity = new GroupResCtrlEntity(opEntity, groupName);
        newEntity.updModifyInfo(opEntity.getDataVerId(), resChkEnable, allowedB2CRate, -2, null, -2, null);
        return this.addOrUpdGroupCtrlConf(false, false, newEntity, strBuff, result);
    }

    @Override
    public boolean insertGroupCtrlConf(GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        return this.addOrUpdGroupCtrlConf(false, false, entity, strBuff, result);
    }

    private boolean addGroupCtrlConfIfAbsent(BaseEntity opEntity, String groupName, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity resCtrlEntity = this.groupResCtrlMapper.getGroupResCtrlConf(groupName);
        if (resCtrlEntity != null) {
            result.setSuccResult(null);
            return true;
        }
        resCtrlEntity = new GroupResCtrlEntity(opEntity, groupName);
        resCtrlEntity.fillDefaultValue();
        return this.addOrUpdGroupCtrlConf(false, true, resCtrlEntity, strBuff, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addOrUpdGroupCtrlConf(boolean chkConsistent, boolean isAddOpOrOnlyAdd, GroupResCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity newEntity;
        GroupResCtrlEntity curEntity;
        Integer lid = null;
        boolean addRecord = true;
        String printPrefix = "[addGroupCtrlConf], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)entity.getGroupName()), true);
            curEntity = this.groupResCtrlMapper.getGroupResCtrlConf(entity.getGroupName());
            if (curEntity == null) {
                if (chkConsistent && !isAddOpOrOnlyAdd) {
                    result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found group control configure for groupName(").append(entity.getGroupName()).append(")!").toString());
                    strBuff.delete(0, strBuff.length());
                    boolean bl = result.isSuccess();
                    if (lid != null) {
                        this.metaRowLock.releaseRowLock(lid);
                    }
                    return bl;
                }
                entity.fillEmptyValues();
                this.groupResCtrlMapper.addGroupResCtrlConf(entity, strBuff, result);
            } else {
                if (isAddOpOrOnlyAdd) {
                    if (chkConsistent) {
                        result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for groupName(").append(entity.getGroupName()).append(")!").toString());
                        strBuff.delete(0, strBuff.length());
                    } else {
                        result.setSuccResult(null);
                    }
                    boolean bl = result.isSuccess();
                    if (lid != null) {
                        this.metaRowLock.releaseRowLock(lid);
                    }
                    return bl;
                }
                addRecord = false;
                printPrefix = "[updGroupCtrlConf], ";
                this.groupResCtrlMapper.updGroupResCtrlConf(entity, strBuff, result);
            }
            newEntity = this.groupResCtrlMapper.getGroupResCtrlConf(entity.getGroupName());
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        catch (Throwable e) {
            try {
                boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (lid != null) {
                    this.metaRowLock.releaseRowLock(lid);
                }
                throw throwable;
            }
        }
        if (result.isSuccess()) {
            if (addRecord) {
                strBuff.append(printPrefix).append(entity.getCreateUser()).append(" added group control configure: ").append(newEntity);
            } else {
                strBuff.append(printPrefix).append(entity.getModifyUser()).append(" updated group control configure from ").append(curEntity).append(" to ").append(newEntity);
            }
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delGroupCtrlConf(String operator, String groupName, StringBuilder strBuff, ProcessResult result) {
        GroupResCtrlEntity curEntity;
        Integer lid = null;
        String printPrefix = "[delGroupCtrlConf], ";
        try {
            lid = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)groupName), true);
            curEntity = this.groupResCtrlMapper.getGroupResCtrlConf(groupName);
            if (curEntity == null) {
                result.setFailResult(null);
                boolean bl = result.isSuccess();
                return bl;
            }
            if (this.consumeCtrlMapper.isGroupNameInUse(groupName)) {
                result.setFailResult(DataOpErrCode.DERR_CONDITION_LACK.getCode(), strBuff.append("Group ").append(groupName).append(" has consume control configures,").append(", please delete consume control configures first!").toString());
                strBuff.delete(0, strBuff.length());
                boolean bl = result.isSuccess();
                return bl;
            }
            this.groupResCtrlMapper.delGroupResCtrlConf(groupName, strBuff, result);
        }
        catch (Throwable e) {
            boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
            return bl;
        }
        finally {
            if (lid != null) {
                this.metaRowLock.releaseRowLock(lid);
            }
        }
        if (result.isSuccess()) {
            strBuff.append(printPrefix).append(operator).append(" deleted group control configure: ").append(curEntity);
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public Map<String, GroupResCtrlEntity> getGroupCtrlConf(Set<String> groupSet, GroupResCtrlEntity qryEntity) {
        return this.groupResCtrlMapper.getGroupResCtrlConf(groupSet, qryEntity);
    }

    @Override
    public GroupResCtrlEntity getGroupCtrlConf(String groupName) {
        return this.groupResCtrlMapper.getGroupResCtrlConf(groupName);
    }

    @Override
    public boolean addOrUpdConsumeCtrlInfo(boolean isAddOp, GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        return this.addOrUpdConsumeCtrlConf(true, isAddOp, entity, strBuff, result);
    }

    @Override
    public boolean insertConsumeCtrlInfo(BaseEntity opEntity, String groupName, String topicName, EnableStatus enableCsm, String disReason, EnableStatus enableFlt, String fltCondStr, StringBuilder strBuff, ProcessResult result) {
        GroupConsumeCtrlEntity entity = new GroupConsumeCtrlEntity(opEntity, groupName, topicName);
        entity.updModifyInfo(opEntity.getDataVerId(), enableCsm, disReason, enableFlt, fltCondStr);
        return this.addOrUpdConsumeCtrlConf(false, false, entity, strBuff, result);
    }

    @Override
    public boolean insertConsumeCtrlInfo(GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        return this.addOrUpdConsumeCtrlConf(false, false, entity, strBuff, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addOrUpdConsumeCtrlConf(boolean chkConsistent, boolean isAddOpOrOnlyAdd, GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        block24: {
            addRecord = true;
            topicLockId = null;
            groupLockId = null;
            printPrefix = "[addConsumeCtrlConf], ";
            opEntity = new BaseEntity("systemSelf", new Date());
            this.addTopicCtrlConfIfAbsent(opEntity, entity.getTopicName(), strBuff, result);
            this.addGroupCtrlConfIfAbsent(opEntity, entity.getGroupName(), strBuff, result);
            try {
                topicLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)entity.getTopicName()), true);
                try {
                    groupLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)entity.getGroupName()), true);
                    curEntity = this.consumeCtrlMapper.getGroupConsumeCtrlConfByRecKey(entity.getRecordKey());
                    if (curEntity != null) ** GOTO lbl46
                    if (chkConsistent && !isAddOpOrOnlyAdd) {
                        result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), strBuff.append("Not found consume control for groupName-topicName(").append(entity.getRecordKey()).append(")!").toString());
                        strBuff.delete(0, strBuff.length());
                        var13_12 = result.isSuccess();
                        if (groupLockId != null) {
                            this.metaRowLock.releaseRowLock(groupLockId);
                        }
                        if (topicLockId != null) {
                            this.metaRowLock.releaseRowLock(topicLockId);
                        }
                        return var13_12;
                    }
                }
                catch (Throwable var14_16) {
                    if (groupLockId != null) {
                        this.metaRowLock.releaseRowLock(groupLockId);
                    }
                    throw var14_16;
                }
            }
            catch (Throwable e) {
                try {
                    var14_17 = this.logExceptionInfo(e, printPrefix, strBuff, result);
                    if (topicLockId != null) {
                        this.metaRowLock.releaseRowLock(topicLockId);
                    }
                    return var14_17;
                }
                catch (Throwable var15_18) {
                    if (topicLockId != null) {
                        this.metaRowLock.releaseRowLock(topicLockId);
                    }
                    throw var15_18;
                }
            }
            {
                entity.fillEmptyValues();
                this.consumeCtrlMapper.addGroupConsumeCtrlConf(entity, strBuff, result);
                ** GOTO lbl63
lbl46:
                // 1 sources

                if (!isAddOpOrOnlyAdd) ** GOTO lbl-1000
                if (chkConsistent) {
                    result.setFailResult(DataOpErrCode.DERR_EXISTED.getCode(), strBuff.append("Existed record found for groupName-topicName(").append(entity.getRecordKey()).append(")!").toString());
                    strBuff.delete(0, strBuff.length());
                } else {
                    result.setSuccResult(null);
                }
                var13_13 = result.isSuccess();
                if (groupLockId != null) {
                    this.metaRowLock.releaseRowLock(groupLockId);
                }
                if (topicLockId != null) {
                    this.metaRowLock.releaseRowLock(topicLockId);
                }
                return var13_13;
            }
lbl-1000:
            // 1 sources

            {
                addRecord = false;
                printPrefix = "[updConsumeCtrlConf], ";
                this.consumeCtrlMapper.updGroupConsumeCtrlConf(entity, strBuff, result);
lbl63:
                // 2 sources

                newEntity = this.consumeCtrlMapper.getGroupConsumeCtrlConfByRecKey(entity.getRecordKey());
                if (groupLockId == null) break block24;
                this.metaRowLock.releaseRowLock(groupLockId);
            }
        }
        if (topicLockId != null) {
            this.metaRowLock.releaseRowLock(topicLockId);
        }
        if (result.isSuccess()) {
            if (addRecord) {
                strBuff.append(printPrefix).append(entity.getCreateUser()).append(" added consume control configure: ").append(newEntity);
            } else {
                strBuff.append(printPrefix).append(entity.getModifyUser()).append(" updated consume control configure from ").append(curEntity).append(" to ").append(newEntity);
            }
            AbsMetaConfigMapperImpl.logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delConsumeCtrlConf(String operator, String groupName, String topicName, StringBuilder strBuff, ProcessResult result) {
        GroupConsumeCtrlEntity curEntity;
        Integer topicLockId = null;
        Integer groupLockId = null;
        String printPrefix = "[delConsumeCtrlConf], ";
        try {
            topicLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)topicName), true);
            try {
                groupLockId = this.metaRowLock.getLock(null, StringUtils.getBytesUtf8((String)groupName), true);
                curEntity = this.consumeCtrlMapper.getConsumeCtrlByGroupAndTopic(groupName, topicName);
                if (curEntity == null) {
                    result.setSuccResult(null);
                    boolean bl = result.isSuccess();
                    return bl;
                }
                this.consumeCtrlMapper.delGroupConsumeCtrlConf(groupName, topicName, strBuff, result);
            }
            finally {
                if (groupLockId != null) {
                    this.metaRowLock.releaseRowLock(groupLockId);
                }
            }
        }
        catch (Throwable e) {
            boolean bl = this.logExceptionInfo(e, printPrefix, strBuff, result);
            return bl;
        }
        finally {
            if (topicLockId != null) {
                this.metaRowLock.releaseRowLock(topicLockId);
            }
        }
        if (result.isSuccess()) {
            strBuff.append(printPrefix).append(operator).append(" deleted consume control configure: ").append(curEntity);
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
        return result.isSuccess();
    }

    @Override
    public List<GroupConsumeCtrlEntity> getConsumeCtrlByTopic(String topicName) {
        return this.consumeCtrlMapper.getConsumeCtrlByTopicName(topicName);
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlByTopic(Set<String> topicSet) {
        return this.consumeCtrlMapper.getConsumeCtrlByTopicName(topicSet);
    }

    @Override
    public GroupConsumeCtrlEntity getConsumeCtrlByGroupAndTopic(String groupName, String topicName) {
        return this.consumeCtrlMapper.getConsumeCtrlByGroupAndTopic(groupName, topicName);
    }

    @Override
    public Set<String> getDisableTopicByGroupName(String groupName) {
        HashSet<String> disTopicSet = new HashSet<String>();
        List<GroupConsumeCtrlEntity> qryResult = this.consumeCtrlMapper.getConsumeCtrlByGroupName(groupName);
        if (qryResult.isEmpty()) {
            return disTopicSet;
        }
        for (GroupConsumeCtrlEntity ctrlEntity : qryResult) {
            if (ctrlEntity == null || ctrlEntity.getConsumeEnable() != EnableStatus.STATUS_DISABLE) continue;
            disTopicSet.add(ctrlEntity.getTopicName());
        }
        return disTopicSet;
    }

    @Override
    public List<GroupConsumeCtrlEntity> getConsumeCtrlByGroupName(String groupName) {
        return this.consumeCtrlMapper.getConsumeCtrlByGroupName(groupName);
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getConsumeCtrlByGroupName(Set<String> groupSet) {
        return this.consumeCtrlMapper.getConsumeCtrlByGroupName(groupSet);
    }

    @Override
    public Map<String, List<GroupConsumeCtrlEntity>> getGroupConsumeCtrlConf(Set<String> groupSet, Set<String> topicSet, GroupConsumeCtrlEntity qryEntry) {
        return this.consumeCtrlMapper.getConsumeCtrlInfoMap(groupSet, topicSet, qryEntry);
    }

    @Override
    public boolean isGroupInUse(String groupName) {
        return this.consumeCtrlMapper.isGroupNameInUse(groupName);
    }

    @Override
    public boolean isTopicInUse(String topicName) {
        return this.consumeCtrlMapper.isTopicNameInUse(topicName);
    }

    protected boolean isServiceStarted() {
        return this.srvStatus.get() == 2;
    }

    protected abstract void initMetaStore(StringBuilder var1);

    protected void reloadMetaStore(StringBuilder strBuff) {
        for (ConfigObserver observer : this.eventObservers) {
            observer.clearCacheData();
        }
        this.clusterConfigMapper.loadConfig(strBuff);
        this.brokerConfigMapper.loadConfig(strBuff);
        this.topicDeployMapper.loadConfig(strBuff);
        this.topicCtrlMapper.loadConfig(strBuff);
        this.groupResCtrlMapper.loadConfig(strBuff);
        this.consumeCtrlMapper.loadConfig(strBuff);
        for (ConfigObserver observer : this.eventObservers) {
            observer.reloadCacheData();
        }
    }

    protected void closeMetaStore() {
        this.brokerConfigMapper.close();
        this.topicDeployMapper.close();
        this.groupResCtrlMapper.close();
        this.topicCtrlMapper.close();
        this.consumeCtrlMapper.close();
        this.clusterConfigMapper.close();
    }

    private boolean logExceptionInfo(Throwable e, String printPrefix, StringBuilder strBuff, ProcessResult result) {
        strBuff.delete(0, strBuff.length());
        strBuff.append(printPrefix).append("failed to lock meta-lock.");
        logger.warn(strBuff.toString(), e);
        result.setFailResult(DataOpErrCode.DERR_STORE_LOCK_FAILURE.getCode(), strBuff.toString());
        strBuff.delete(0, strBuff.length());
        return result.isSuccess();
    }
}

