/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.InlongGroupContext;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;

@Parameters(commandDescription="Suspend resource by group id")
public class SuspendCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public SuspendCommand() {
        super("suspend");
        this.jcommander.addCommand("group", (Object)new SuspendGroup());
    }

    @Parameters(commandDescription="Suspend the inlong group task")
    private static class SuspendGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--group", "-g"}, required=true, description="inlong group id")
        private String inlongGroupId;

        private SuspendGroup() {
        }

        @Override
        void run() {
            try {
                InlongClientImpl inlongClient = ClientUtils.getClient();
                InlongGroup group = inlongClient.getGroup(this.inlongGroupId);
                InlongGroupContext context = group.suspend();
                if (!SimpleGroupStatus.STOPPED.equals((Object)context.getStatus())) {
                    throw new Exception("Suspend group failed, current status: " + context.getStatus());
                }
                System.out.println("Suspend group success!");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

