/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.inner.client.InlongStreamClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantRoleClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSinkClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSourceClient;
import org.apache.inlong.manager.client.api.inner.client.StreamTransformClient;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.client.cli.util.PrintUtils;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.user.TenantRoleInfo;
import org.apache.inlong.manager.pojo.user.UserInfo;

@Parameters(commandDescription="Display details of one resource")
public class DescribeCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public DescribeCommand() {
        super("describe");
        this.jcommander.addCommand("stream", (Object)new DescribeStream());
        this.jcommander.addCommand("group", (Object)new DescribeGroup());
        this.jcommander.addCommand("sink", (Object)new DescribeSink());
        this.jcommander.addCommand("source", (Object)new DescribeSource());
        this.jcommander.addCommand("transform", (Object)new DescribeTransform());
        this.jcommander.addCommand("cluster", (Object)new DescribeCluster());
        this.jcommander.addCommand("cluster-tag", (Object)new DescribeClusterTag());
        this.jcommander.addCommand("cluster-node", (Object)new DescribeClusterNode());
        this.jcommander.addCommand("user", (Object)new DescribeUser());
        this.jcommander.addCommand("tenant", (Object)new DescribeTenant());
        this.jcommander.addCommand("tenant-role", (Object)new DescribeTenantRole());
    }

    @Parameters(commandDescription="Get tenant role details")
    private static class DescribeTenantRole
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="tenant role id")
        private int id;

        private DescribeTenantRole() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongTenantRoleClient tenantRoleClient = ClientUtils.clientFactory.getInlongTenantRoleClient();
                TenantRoleInfo tenantRoleInfo = tenantRoleClient.get(this.id);
                PrintUtils.printJson(tenantRoleInfo);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get tenant details")
    private static class DescribeTenant
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-name", "--name"}, required=true, description="tenant name")
        private String name;

        private DescribeTenant() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongTenantClient tenantClient = ClientUtils.clientFactory.getInlongTenantClient();
                InlongTenantInfo tenantInfo = tenantClient.getTenantByName(this.name);
                PrintUtils.printJson(tenantInfo);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get user details")
    private static class DescribeUser
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="user id")
        private int userId;

        private DescribeUser() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                UserClient userClient = ClientUtils.clientFactory.getUserClient();
                UserInfo userInfo = userClient.getById(Integer.valueOf(this.userId));
                PrintUtils.printJson(userInfo);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get cluster node details")
    private static class DescribeClusterNode
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="cluster node id")
        private int nodeId;

        private DescribeClusterNode() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                ClusterNodeResponse nodeInfo = clusterClient.getNode(Integer.valueOf(this.nodeId));
                PrintUtils.printJson(nodeInfo);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get cluster tag details")
    private static class DescribeClusterTag
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="cluster tag id")
        private int tagId;

        private DescribeClusterTag() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                ClusterTagResponse tagInfo = clusterClient.getTag(Integer.valueOf(this.tagId));
                PrintUtils.printJson(tagInfo);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get cluster details")
    private static class DescribeCluster
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="cluster id")
        private int clusterId;

        private DescribeCluster() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                ClusterInfo clusterInfo = clusterClient.get(Integer.valueOf(this.clusterId));
                PrintUtils.printJson(clusterInfo);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get transform details")
    private static class DescribeTransform
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String groupId;
        @Parameter(names={"-s", "--stream"}, required=true, description="inlong stream id")
        private String streamId;

        private DescribeTransform() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                StreamTransformClient transformClient = ClientUtils.clientFactory.getTransformClient();
                List transforms = transformClient.listTransform(this.groupId, this.streamId).getList();
                transforms.forEach(PrintUtils::printJson);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get source details")
    private static class DescribeSource
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--stream"}, required=true, description="inlong stream id")
        private String stream;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String group;
        @Parameter(names={"-t", "--type"}, description="sink type")
        private String type;

        private DescribeSource() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                StreamSourceClient sourceClient = ClientUtils.clientFactory.getSourceClient();
                List sources = sourceClient.listSources(this.group, this.stream, this.type);
                sources.forEach(PrintUtils::printJson);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get sink details")
    private static class DescribeSink
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--stream"}, required=true, description="inlong stream id")
        private String stream;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String group;

        private DescribeSink() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                StreamSinkClient sinkClient = ClientUtils.clientFactory.getSinkClient();
                List streamSinks = sinkClient.listSinks(this.group, this.stream);
                streamSinks.forEach(PrintUtils::printJson);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get group details")
    private static class DescribeGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-s", "--status"}, description="inlong group status")
        private int status;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String group;
        @Parameter(names={"-n", "--num"}, description="the number displayed")
        private int pageSize;

        private DescribeGroup() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongGroupClient groupClient = ClientUtils.clientFactory.getGroupClient();
                InlongGroupPageRequest pageRequest = new InlongGroupPageRequest();
                pageRequest.setKeyword(this.group);
                PageResult pageInfo = groupClient.listGroups(pageRequest);
                pageInfo.getList().forEach(PrintUtils::printJson);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Get stream details")
    private static class DescribeStream
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-g", "--group"}, required=true, description="inlong group id")
        private String groupId;

        private DescribeStream() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongStreamClient streamClient = ClientUtils.clientFactory.getStreamClient();
                List streamInfos = streamClient.listStreamInfo(this.groupId);
                streamInfos.forEach(PrintUtils::printJson);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

