/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"from_unix_time", "form_unixtime"}, parameter="(Numeric numeric,String formatStr)", descriptions={"- Return \"\" if 'numeric' is NULL;", "- Return a representation of the numeric argument as a value in string.", "Note: 'formatStr' defaults to 'yyyy-MM-dd HH:mm:ss'. numeric is an internal timestamp value representing seconds since \u20181970-01-01 00:00:00\u2019 UTC, such as produced by the UNIX_TIMESTAMP() function."}, examples={"from_unix_time(44) = \"1970-01-01 08:00:44\""})
public class FromUnixTimeFunction
implements ValueParser {
    private ValueParser numericParser;
    private ValueParser stringParser;
    private static final Map<String, DateTimeFormatter> OUTPUT_FORMATTERS = new ConcurrentHashMap<String, DateTimeFormatter>();
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public FromUnixTimeFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.numericParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() == 2) {
            this.stringParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numericObj = this.numericParser.parse(sourceData, rowIndex, context);
        BigDecimal unixTimestamp = OperatorTools.parseBigDecimal(numericObj);
        String formatPattern = this.stringParser != null ? OperatorTools.parseString(this.stringParser.parse(sourceData, rowIndex, context)) : DEFAULT_FORMAT;
        LocalDateTime utcDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(unixTimestamp.longValue()), ZoneOffset.UTC);
        LocalDateTime localDateTime = utcDateTime.atZone(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(this.getDateTimeFormatter(formatPattern));
    }

    private DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter formatter = OUTPUT_FORMATTERS.get(pattern);
        if (formatter == null) {
            formatter = DateTimeFormatter.ofPattern(pattern);
            OUTPUT_FORMATTERS.put(pattern, formatter);
        }
        return formatter;
    }
}

