/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"elt"}, parameter="(Integer index, Expr expr1[, Expr expr2, ...])", descriptions={"- Return \"\" if 'index' is NULL or out of range;", "- Return the index-th('index' starts from 1) expression."}, examples={"elt(2, 'a', 'b', 'c') = \"b\""})
public class EltFunction
implements ValueParser {
    private ValueParser indexParser;
    private List<ValueParser> exprParsers;

    public EltFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.indexParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.exprParsers = new ArrayList<ValueParser>();
        for (int i = 1; i < expressions.size(); ++i) {
            this.exprParsers.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object indexObject = this.indexParser.parse(sourceData, rowIndex, context);
        if (indexObject == null) {
            return null;
        }
        int index = OperatorTools.parseBigDecimal(indexObject).intValue();
        if (index < 1 || index > this.exprParsers.size()) {
            return null;
        }
        return this.exprParsers.get(index - 1).parse(sourceData, rowIndex, context);
    }
}

