/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.pojo;

import java.util.Locale;

public enum ProtocolType {
    CSV("csv"),
    KV("kv"),
    PB("pb"),
    JSON("json"),
    UNKNOWN("n");

    private final String type;

    private ProtocolType(String type) {
        this.type = type;
    }

    public static ProtocolType forType(String type) {
        for (ProtocolType dataType : ProtocolType.values()) {
            if (!dataType.getType().equals(type.toLowerCase(Locale.ROOT))) continue;
            return dataType;
        }
        throw new IllegalArgumentException("Unsupported protocol type for " + type);
    }

    public static ProtocolType convert(String value) {
        for (ProtocolType v : ProtocolType.values()) {
            if (!v.getType().equals(value.toLowerCase(Locale.ROOT))) continue;
            return v;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name() + ":" + this.type;
    }

    public String getType() {
        return this.type;
    }
}

