/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.sql;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.sql.SqlSourceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSourceDTO {
    private static final Logger log = LoggerFactory.getLogger(SqlSourceDTO.class);
    @ApiModelProperty(value="sql", required=true)
    private String sql;
    @ApiModelProperty(value="Cycle unit")
    private String cycleUnit;
    @ApiModelProperty(value="Whether retry")
    private Boolean retry = false;
    @ApiModelProperty(value="Data start time")
    private String dataTimeFrom;
    @ApiModelProperty(value="Data end time")
    private String dataTimeTo;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Max instance count")
    private Integer maxInstanceCount;
    @ApiModelProperty(value="Jdbc url")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="jdbc password")
    private String jdbcPassword;
    @ApiModelProperty(value="Fetch size")
    private Integer fetchSize;
    @ApiModelProperty(value="Column separator of data source ")
    private String dataSeparator;
    @ApiModelProperty(value="Audit version")
    private String auditVersion;

    public static SqlSourceDTO getFromRequest(@NotNull SqlSourceRequest sqlSourceRequest, String extParams) {
        SqlSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? SqlSourceDTO.getFromJson(extParams) : new SqlSourceDTO();
        return (SqlSourceDTO)CommonBeanUtils.copyProperties((Object)sqlSourceRequest, (Object)dto, (boolean)true);
    }

    public static SqlSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (SqlSourceDTO)JsonUtils.parseObject((String)extParams, SqlSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of SqlSource failure: %s", e.getMessage()));
        }
    }

    public static SqlSourceDTOBuilder builder() {
        return new SqlSourceDTOBuilder();
    }

    public SqlSourceDTO(String sql, String cycleUnit, Boolean retry, String dataTimeFrom, String dataTimeTo, String timeOffset, Integer maxInstanceCount, String jdbcUrl, String username, String jdbcPassword, Integer fetchSize, String dataSeparator, String auditVersion) {
        this.sql = sql;
        this.cycleUnit = cycleUnit;
        this.retry = retry;
        this.dataTimeFrom = dataTimeFrom;
        this.dataTimeTo = dataTimeTo;
        this.timeOffset = timeOffset;
        this.maxInstanceCount = maxInstanceCount;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.jdbcPassword = jdbcPassword;
        this.fetchSize = fetchSize;
        this.dataSeparator = dataSeparator;
        this.auditVersion = auditVersion;
    }

    public SqlSourceDTO() {
    }

    public String getSql() {
        return this.sql;
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public String getDataTimeFrom() {
        return this.dataTimeFrom;
    }

    public String getDataTimeTo() {
        return this.dataTimeTo;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public Integer getMaxInstanceCount() {
        return this.maxInstanceCount;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getAuditVersion() {
        return this.auditVersion;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public void setDataTimeFrom(String dataTimeFrom) {
        this.dataTimeFrom = dataTimeFrom;
    }

    public void setDataTimeTo(String dataTimeTo) {
        this.dataTimeTo = dataTimeTo;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setMaxInstanceCount(Integer maxInstanceCount) {
        this.maxInstanceCount = maxInstanceCount;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setAuditVersion(String auditVersion) {
        this.auditVersion = auditVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlSourceDTO)) {
            return false;
        }
        SqlSourceDTO other = (SqlSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$retry = this.getRetry();
        Boolean other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        Integer this$maxInstanceCount = this.getMaxInstanceCount();
        Integer other$maxInstanceCount = other.getMaxInstanceCount();
        if (this$maxInstanceCount == null ? other$maxInstanceCount != null : !((Object)this$maxInstanceCount).equals(other$maxInstanceCount)) {
            return false;
        }
        Integer this$fetchSize = this.getFetchSize();
        Integer other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !((Object)this$fetchSize).equals(other$fetchSize)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$cycleUnit = this.getCycleUnit();
        String other$cycleUnit = other.getCycleUnit();
        if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
            return false;
        }
        String this$dataTimeFrom = this.getDataTimeFrom();
        String other$dataTimeFrom = other.getDataTimeFrom();
        if (this$dataTimeFrom == null ? other$dataTimeFrom != null : !this$dataTimeFrom.equals(other$dataTimeFrom)) {
            return false;
        }
        String this$dataTimeTo = this.getDataTimeTo();
        String other$dataTimeTo = other.getDataTimeTo();
        if (this$dataTimeTo == null ? other$dataTimeTo != null : !this$dataTimeTo.equals(other$dataTimeTo)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$jdbcPassword = this.getJdbcPassword();
        String other$jdbcPassword = other.getJdbcPassword();
        if (this$jdbcPassword == null ? other$jdbcPassword != null : !this$jdbcPassword.equals(other$jdbcPassword)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$auditVersion = this.getAuditVersion();
        String other$auditVersion = other.getAuditVersion();
        return !(this$auditVersion == null ? other$auditVersion != null : !this$auditVersion.equals(other$auditVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        Integer $maxInstanceCount = this.getMaxInstanceCount();
        result = result * 59 + ($maxInstanceCount == null ? 43 : ((Object)$maxInstanceCount).hashCode());
        Integer $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : ((Object)$fetchSize).hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $cycleUnit = this.getCycleUnit();
        result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
        String $dataTimeFrom = this.getDataTimeFrom();
        result = result * 59 + ($dataTimeFrom == null ? 43 : $dataTimeFrom.hashCode());
        String $dataTimeTo = this.getDataTimeTo();
        result = result * 59 + ($dataTimeTo == null ? 43 : $dataTimeTo.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $jdbcPassword = this.getJdbcPassword();
        result = result * 59 + ($jdbcPassword == null ? 43 : $jdbcPassword.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $auditVersion = this.getAuditVersion();
        result = result * 59 + ($auditVersion == null ? 43 : $auditVersion.hashCode());
        return result;
    }

    public String toString() {
        return "SqlSourceDTO(sql=" + this.getSql() + ", cycleUnit=" + this.getCycleUnit() + ", retry=" + this.getRetry() + ", dataTimeFrom=" + this.getDataTimeFrom() + ", dataTimeTo=" + this.getDataTimeTo() + ", timeOffset=" + this.getTimeOffset() + ", maxInstanceCount=" + this.getMaxInstanceCount() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", jdbcPassword=" + this.getJdbcPassword() + ", fetchSize=" + this.getFetchSize() + ", dataSeparator=" + this.getDataSeparator() + ", auditVersion=" + this.getAuditVersion() + ")";
    }

    public static class SqlSourceDTOBuilder {
        private String sql;
        private String cycleUnit;
        private Boolean retry;
        private String dataTimeFrom;
        private String dataTimeTo;
        private String timeOffset;
        private Integer maxInstanceCount;
        private String jdbcUrl;
        private String username;
        private String jdbcPassword;
        private Integer fetchSize;
        private String dataSeparator;
        private String auditVersion;

        SqlSourceDTOBuilder() {
        }

        public SqlSourceDTOBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public SqlSourceDTOBuilder cycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
            return this;
        }

        public SqlSourceDTOBuilder retry(Boolean retry) {
            this.retry = retry;
            return this;
        }

        public SqlSourceDTOBuilder dataTimeFrom(String dataTimeFrom) {
            this.dataTimeFrom = dataTimeFrom;
            return this;
        }

        public SqlSourceDTOBuilder dataTimeTo(String dataTimeTo) {
            this.dataTimeTo = dataTimeTo;
            return this;
        }

        public SqlSourceDTOBuilder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public SqlSourceDTOBuilder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public SqlSourceDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public SqlSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SqlSourceDTOBuilder jdbcPassword(String jdbcPassword) {
            this.jdbcPassword = jdbcPassword;
            return this;
        }

        public SqlSourceDTOBuilder fetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public SqlSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public SqlSourceDTOBuilder auditVersion(String auditVersion) {
            this.auditVersion = auditVersion;
            return this;
        }

        public SqlSourceDTO build() {
            return new SqlSourceDTO(this.sql, this.cycleUnit, this.retry, this.dataTimeFrom, this.dataTimeTo, this.timeOffset, this.maxInstanceCount, this.jdbcUrl, this.username, this.jdbcPassword, this.fetchSize, this.dataSeparator, this.auditVersion);
        }

        public String toString() {
            return "SqlSourceDTO.SqlSourceDTOBuilder(sql=" + this.sql + ", cycleUnit=" + this.cycleUnit + ", retry=" + this.retry + ", dataTimeFrom=" + this.dataTimeFrom + ", dataTimeTo=" + this.dataTimeTo + ", timeOffset=" + this.timeOffset + ", maxInstanceCount=" + this.maxInstanceCount + ", jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", jdbcPassword=" + this.jdbcPassword + ", fetchSize=" + this.fetchSize + ", dataSeparator=" + this.dataSeparator + ", auditVersion=" + this.auditVersion + ")";
        }
    }
}

