/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.kafka;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;

@ApiModel(value="Kafka source request")
@JsonTypeDefine(value="KAFKA")
public class KafkaSourceRequest
extends SourceRequest {
    @ApiModelProperty(value="Kafka topic")
    private String topic;
    @ApiModelProperty(value="Kafka consumer group")
    private String groupId;
    @ApiModelProperty(value="Kafka servers address, such as: 127.0.0.1:9092")
    private String bootstrapServers;
    @ApiModelProperty(value="Limit the amount of data read per second", notes="Greater than or equal to 0, equal to zero means no limit")
    private String recordSpeedLimit;
    @ApiModelProperty(value="Limit the number of bytes read per second", notes="Greater than or equal to 0, equal to zero means no limit")
    private String byteSpeedLimit;
    @ApiModelProperty(value="Topic partition offset", notes="For example,'partition:0,offset:42;partition:1,offset:300' indicates offset 42 for partition 0 and offset 300 for partition 1.")
    private String partitionOffsets;
    @ApiModelProperty(value="timestamp is millis")
    private String timestampMillis;
    @ApiModelProperty(value="The strategy of auto offset reset", notes="including earliest, latest (the default), none")
    private String autoOffsetReset;
    @ApiModelProperty(value="database pattern used for filter in canal format")
    private String databasePattern;
    @ApiModelProperty(value="table pattern used for filter in canal format")
    private String tablePattern;
    @ApiModelProperty(value="ignore parse errors, true: ignore parse error; false: not ignore parse error; default true")
    private Boolean ignoreParseErrors;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard = "SQL";
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="KV separator")
    private String kvSeparator;
    @ApiModelProperty(value="Data field escape symbol")
    private String dataEscapeChar;
    @ApiModelProperty(value="The message body wrap  wrap type, including: RAW, INLONG_MSG_V0, INLONG_MSG_V1, etc")
    private String wrapType;

    public KafkaSourceRequest() {
        this.setSourceType("KAFKA");
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getRecordSpeedLimit() {
        return this.recordSpeedLimit;
    }

    public String getByteSpeedLimit() {
        return this.byteSpeedLimit;
    }

    public String getPartitionOffsets() {
        return this.partitionOffsets;
    }

    public String getTimestampMillis() {
        return this.timestampMillis;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public Boolean getIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getKvSeparator() {
        return this.kvSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public String getWrapType() {
        return this.wrapType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setRecordSpeedLimit(String recordSpeedLimit) {
        this.recordSpeedLimit = recordSpeedLimit;
    }

    public void setByteSpeedLimit(String byteSpeedLimit) {
        this.byteSpeedLimit = byteSpeedLimit;
    }

    public void setPartitionOffsets(String partitionOffsets) {
        this.partitionOffsets = partitionOffsets;
    }

    public void setTimestampMillis(String timestampMillis) {
        this.timestampMillis = timestampMillis;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setIgnoreParseErrors(Boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setKvSeparator(String kvSeparator) {
        this.kvSeparator = kvSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setWrapType(String wrapType) {
        this.wrapType = wrapType;
    }

    @Override
    public String toString() {
        return "KafkaSourceRequest(super=" + super.toString() + ", topic=" + this.getTopic() + ", groupId=" + this.getGroupId() + ", bootstrapServers=" + this.getBootstrapServers() + ", recordSpeedLimit=" + this.getRecordSpeedLimit() + ", byteSpeedLimit=" + this.getByteSpeedLimit() + ", partitionOffsets=" + this.getPartitionOffsets() + ", timestampMillis=" + this.getTimestampMillis() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", ignoreParseErrors=" + this.getIgnoreParseErrors() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", primaryKey=" + this.getPrimaryKey() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", kvSeparator=" + this.getKvSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", wrapType=" + this.getWrapType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceRequest)) {
            return false;
        }
        KafkaSourceRequest other = (KafkaSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreParseErrors = this.getIgnoreParseErrors();
        Boolean other$ignoreParseErrors = other.getIgnoreParseErrors();
        if (this$ignoreParseErrors == null ? other$ignoreParseErrors != null : !((Object)this$ignoreParseErrors).equals(other$ignoreParseErrors)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$recordSpeedLimit = this.getRecordSpeedLimit();
        String other$recordSpeedLimit = other.getRecordSpeedLimit();
        if (this$recordSpeedLimit == null ? other$recordSpeedLimit != null : !this$recordSpeedLimit.equals(other$recordSpeedLimit)) {
            return false;
        }
        String this$byteSpeedLimit = this.getByteSpeedLimit();
        String other$byteSpeedLimit = other.getByteSpeedLimit();
        if (this$byteSpeedLimit == null ? other$byteSpeedLimit != null : !this$byteSpeedLimit.equals(other$byteSpeedLimit)) {
            return false;
        }
        String this$partitionOffsets = this.getPartitionOffsets();
        String other$partitionOffsets = other.getPartitionOffsets();
        if (this$partitionOffsets == null ? other$partitionOffsets != null : !this$partitionOffsets.equals(other$partitionOffsets)) {
            return false;
        }
        String this$timestampMillis = this.getTimestampMillis();
        String other$timestampMillis = other.getTimestampMillis();
        if (this$timestampMillis == null ? other$timestampMillis != null : !this$timestampMillis.equals(other$timestampMillis)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$kvSeparator = this.getKvSeparator();
        String other$kvSeparator = other.getKvSeparator();
        if (this$kvSeparator == null ? other$kvSeparator != null : !this$kvSeparator.equals(other$kvSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        String this$wrapType = this.getWrapType();
        String other$wrapType = other.getWrapType();
        return !(this$wrapType == null ? other$wrapType != null : !this$wrapType.equals(other$wrapType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreParseErrors = this.getIgnoreParseErrors();
        result = result * 59 + ($ignoreParseErrors == null ? 43 : ((Object)$ignoreParseErrors).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $recordSpeedLimit = this.getRecordSpeedLimit();
        result = result * 59 + ($recordSpeedLimit == null ? 43 : $recordSpeedLimit.hashCode());
        String $byteSpeedLimit = this.getByteSpeedLimit();
        result = result * 59 + ($byteSpeedLimit == null ? 43 : $byteSpeedLimit.hashCode());
        String $partitionOffsets = this.getPartitionOffsets();
        result = result * 59 + ($partitionOffsets == null ? 43 : $partitionOffsets.hashCode());
        String $timestampMillis = this.getTimestampMillis();
        result = result * 59 + ($timestampMillis == null ? 43 : $timestampMillis.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $kvSeparator = this.getKvSeparator();
        result = result * 59 + ($kvSeparator == null ? 43 : $kvSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        String $wrapType = this.getWrapType();
        result = result * 59 + ($wrapType == null ? 43 : $wrapType.hashCode());
        return result;
    }
}

