/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeStrategyFactory;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.extract.MySqlExtractNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MySQLBinlogProvider
implements ExtractNodeProvider {
    @Autowired
    private FieldTypeStrategyFactory fieldTypeStrategyFactory;

    @Override
    public Boolean accept(String sourceType) {
        return "MYSQL_BINLOG".equals(sourceType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        MySQLBinlogSource binlogSource = (MySQLBinlogSource)streamNodeInfo;
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(binlogSource.getSourceType());
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(binlogSource.getFieldList(), binlogSource.getSourceName(), fieldTypeMappingStrategy);
        Map<String, String> properties = this.parseProperties(binlogSource.getProperties());
        String database = binlogSource.getDatabaseWhiteList();
        String primaryKey = binlogSource.getPrimaryKey();
        String hostName = binlogSource.getHostname();
        String username = binlogSource.getUser();
        String password = binlogSource.getPassword();
        Integer port = binlogSource.getPort();
        Integer serverId = null;
        if (binlogSource.getServerId() != null && binlogSource.getServerId() > 0) {
            serverId = binlogSource.getServerId();
        }
        String tables = binlogSource.getTableWhiteList();
        List tableNames = Splitter.on((String)",").splitToList((CharSequence)tables);
        String serverTimeZone = binlogSource.getServerTimezone();
        if (binlogSource.isAllMigration()) {
            properties.put("migrate-all", "true");
        }
        if (binlogSource.isOnlyIncremental()) {
            properties.put("scan.startup.mode", "latest-offset");
        }
        return new MySqlExtractNode(binlogSource.getSourceName(), binlogSource.getSourceName(), fieldInfos, null, properties, primaryKey, tableNames, hostName, username, password, database, port, serverId, Boolean.valueOf(true), serverTimeZone);
    }

    @Override
    public List<FieldInfo> getMetaFields() {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        fieldInfos.add(0, (FieldInfo)new MetaFieldInfo(MetaField.AUDIT_DATA_TIME.name(), MetaField.AUDIT_DATA_TIME));
        return fieldInfos;
    }

    @Override
    public List<StreamField> addStreamMetaFields(List<StreamField> streamFields) {
        List fieldNames = streamFields.stream().map(StreamField::getFieldName).collect(Collectors.toList());
        if (!fieldNames.contains(MetaField.AUDIT_DATA_TIME.name())) {
            streamFields.add(0, new StreamField(0, "long", MetaField.AUDIT_DATA_TIME.name(), "data_time", null, 1, MetaField.AUDIT_DATA_TIME.name()));
        }
        return streamFields;
    }
}

