/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterRequest;

@ApiModel(value="Pulsar cluster info")
public class PulsarClusterDTO {
    @ApiModelProperty(value="Pulsar admin URL, such as: http://127.0.0.1:8080")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar service URL, is the 'url' field of the cluster")
    private String serviceUrl;
    @ApiModelProperty(value="Pulsar tenant, default is 'public'")
    private String pulsarTenant;
    private String messageQueueHandler;

    public static PulsarClusterDTO getFromRequest(PulsarClusterRequest request, String extParams) {
        PulsarClusterDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? PulsarClusterDTO.getFromJson(extParams) : new PulsarClusterDTO();
        dto.setServiceUrl(request.getUrl());
        return (PulsarClusterDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static PulsarClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (PulsarClusterDTO)JsonUtils.parseObject((String)extParams, PulsarClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("parse extParams of Pulsar Cluster failure: %s", e.getMessage()));
        }
    }

    private static String $default$messageQueueHandler() {
        return "org.apache.inlong.dataproxy.sink.mq.pulsar.PulsarHandler";
    }

    public static PulsarClusterDTOBuilder builder() {
        return new PulsarClusterDTOBuilder();
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPulsarTenant() {
        return this.pulsarTenant;
    }

    public String getMessageQueueHandler() {
        return this.messageQueueHandler;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPulsarTenant(String pulsarTenant) {
        this.pulsarTenant = pulsarTenant;
    }

    public void setMessageQueueHandler(String messageQueueHandler) {
        this.messageQueueHandler = messageQueueHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarClusterDTO)) {
            return false;
        }
        PulsarClusterDTO other = (PulsarClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$pulsarTenant = this.getPulsarTenant();
        String other$pulsarTenant = other.getPulsarTenant();
        if (this$pulsarTenant == null ? other$pulsarTenant != null : !this$pulsarTenant.equals(other$pulsarTenant)) {
            return false;
        }
        String this$messageQueueHandler = this.getMessageQueueHandler();
        String other$messageQueueHandler = other.getMessageQueueHandler();
        return !(this$messageQueueHandler == null ? other$messageQueueHandler != null : !this$messageQueueHandler.equals(other$messageQueueHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $pulsarTenant = this.getPulsarTenant();
        result = result * 59 + ($pulsarTenant == null ? 43 : $pulsarTenant.hashCode());
        String $messageQueueHandler = this.getMessageQueueHandler();
        result = result * 59 + ($messageQueueHandler == null ? 43 : $messageQueueHandler.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarClusterDTO(adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", pulsarTenant=" + this.getPulsarTenant() + ", messageQueueHandler=" + this.getMessageQueueHandler() + ")";
    }

    public PulsarClusterDTO() {
        this.messageQueueHandler = PulsarClusterDTO.$default$messageQueueHandler();
    }

    public PulsarClusterDTO(String adminUrl, String serviceUrl, String pulsarTenant, String messageQueueHandler) {
        this.adminUrl = adminUrl;
        this.serviceUrl = serviceUrl;
        this.pulsarTenant = pulsarTenant;
        this.messageQueueHandler = messageQueueHandler;
    }

    public static class PulsarClusterDTOBuilder {
        private String adminUrl;
        private String serviceUrl;
        private String pulsarTenant;
        private boolean messageQueueHandler$set;
        private String messageQueueHandler$value;

        PulsarClusterDTOBuilder() {
        }

        public PulsarClusterDTOBuilder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarClusterDTOBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public PulsarClusterDTOBuilder pulsarTenant(String pulsarTenant) {
            this.pulsarTenant = pulsarTenant;
            return this;
        }

        public PulsarClusterDTOBuilder messageQueueHandler(String messageQueueHandler) {
            this.messageQueueHandler$value = messageQueueHandler;
            this.messageQueueHandler$set = true;
            return this;
        }

        public PulsarClusterDTO build() {
            String messageQueueHandler$value = this.messageQueueHandler$value;
            if (!this.messageQueueHandler$set) {
                messageQueueHandler$value = PulsarClusterDTO.$default$messageQueueHandler();
            }
            return new PulsarClusterDTO(this.adminUrl, this.serviceUrl, this.pulsarTenant, messageQueueHandler$value);
        }

        public String toString() {
            return "PulsarClusterDTO.PulsarClusterDTOBuilder(adminUrl=" + this.adminUrl + ", serviceUrl=" + this.serviceUrl + ", pulsarTenant=" + this.pulsarTenant + ", messageQueueHandler$value=" + this.messageQueueHandler$value + ")";
        }
    }
}

