/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunctionBase;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.internal.InternalWindowProcessFunction;
import org.apache.flink.table.runtime.operators.window.internal.MergingWindowSet;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public class MergingWindowProcessFunction<K, W extends Window>
extends InternalWindowProcessFunction<K, W> {
    private static final long serialVersionUID = -2866771637946397223L;
    private final MergingWindowAssigner<W> windowAssigner;
    private final TypeSerializer<W> windowSerializer;
    private transient MergingWindowSet<W> mergingWindows;
    private transient MergingFunctionImpl mergingFunction;
    private List<W> reuseActualWindows;

    public MergingWindowProcessFunction(MergingWindowAssigner<W> windowAssigner, NamespaceAggsHandleFunctionBase<W> windowAggregator, TypeSerializer<W> windowSerializer, long allowedLateness) {
        super(windowAssigner, windowAggregator, allowedLateness);
        this.windowAssigner = windowAssigner;
        this.windowSerializer = windowSerializer;
    }

    @Override
    public void open(InternalWindowProcessFunction.Context<K, W> ctx) throws Exception {
        super.open(ctx);
        MapStateDescriptor mappingStateDescriptor = new MapStateDescriptor("session-window-mapping", this.windowSerializer, this.windowSerializer);
        MapState windowMapping = (MapState)ctx.getPartitionedState(mappingStateDescriptor);
        this.mergingWindows = new MergingWindowSet<W>(this.windowAssigner, windowMapping);
        this.mergingFunction = new MergingFunctionImpl();
    }

    @Override
    public Collection<W> assignStateNamespace(RowData inputRow, long timestamp) throws Exception {
        Collection elementWindows = this.windowAssigner.assignWindows(inputRow, timestamp);
        this.mergingWindows.initializeCache(this.ctx.currentKey());
        this.reuseActualWindows = new ArrayList<W>(1);
        for (Window window : elementWindows) {
            Window actualWindow = this.mergingWindows.addWindow(window, this.mergingFunction);
            if (this.isWindowLate(actualWindow)) {
                this.mergingWindows.retireWindow(actualWindow);
                continue;
            }
            this.reuseActualWindows.add(actualWindow);
        }
        ArrayList<Window> affectedWindows = new ArrayList<Window>(this.reuseActualWindows.size());
        for (Window actual : this.reuseActualWindows) {
            affectedWindows.add(this.mergingWindows.getStateWindow(actual));
        }
        return affectedWindows;
    }

    @Override
    public Collection<W> assignActualWindows(RowData inputRow, long timestamp) throws Exception {
        return this.reuseActualWindows;
    }

    @Override
    public void prepareAggregateAccumulatorForEmit(W window) throws Exception {
        W stateWindow = this.mergingWindows.getStateWindow(window);
        RowData acc = this.ctx.getWindowAccumulators(stateWindow);
        if (acc == null) {
            acc = this.windowAggregator.createAccumulators();
        }
        this.windowAggregator.setAccumulators(stateWindow, acc);
    }

    @Override
    public void cleanWindowIfNeeded(W window, long currentTime) throws Exception {
        if (this.isCleanupTime(window, currentTime)) {
            this.ctx.clearTrigger(window);
            W stateWindow = this.mergingWindows.getStateWindow(window);
            this.ctx.clearWindowState(stateWindow);
            this.mergingWindows.initializeCache(this.ctx.currentKey());
            this.mergingWindows.retireWindow(window);
        }
    }

    private class MergingFunctionImpl
    implements MergingWindowSet.MergeFunction<W> {
        private MergingFunctionImpl() {
        }

        @Override
        public void merge(W mergeResult, Collection<W> mergedWindows, W stateWindowResult, Collection<W> stateWindowsToBeMerged) throws Exception {
            long mergeResultMaxTs = TimeWindowUtil.toEpochMillsForTimer(((Window)mergeResult).maxTimestamp(), MergingWindowProcessFunction.this.ctx.getShiftTimeZone());
            if (MergingWindowProcessFunction.this.windowAssigner.isEventTime() && mergeResultMaxTs + MergingWindowProcessFunction.this.allowedLateness <= MergingWindowProcessFunction.this.ctx.currentWatermark()) {
                throw new UnsupportedOperationException("The end timestamp of an event-time window cannot become earlier than the current watermark by merging. Current watermark: " + MergingWindowProcessFunction.this.ctx.currentWatermark() + " window: " + mergeResult);
            }
            if (!MergingWindowProcessFunction.this.windowAssigner.isEventTime() && mergeResultMaxTs <= MergingWindowProcessFunction.this.ctx.currentProcessingTime()) {
                throw new UnsupportedOperationException("The end timestamp of a processing-time window cannot become earlier than the current processing time by merging. Current processing time: " + MergingWindowProcessFunction.this.ctx.currentProcessingTime() + " window: " + mergeResult);
            }
            MergingWindowProcessFunction.this.ctx.onMerge(mergeResult, stateWindowsToBeMerged);
            for (Window m : mergedWindows) {
                MergingWindowProcessFunction.this.ctx.clearTrigger(m);
                MergingWindowProcessFunction.this.ctx.deleteCleanupTimer(m);
            }
            if (!stateWindowsToBeMerged.isEmpty()) {
                RowData targetAcc = MergingWindowProcessFunction.this.ctx.getWindowAccumulators(stateWindowResult);
                if (targetAcc == null) {
                    targetAcc = MergingWindowProcessFunction.this.windowAggregator.createAccumulators();
                }
                MergingWindowProcessFunction.this.windowAggregator.setAccumulators(stateWindowResult, targetAcc);
                for (Window w : stateWindowsToBeMerged) {
                    RowData acc = MergingWindowProcessFunction.this.ctx.getWindowAccumulators(w);
                    if (acc != null) {
                        MergingWindowProcessFunction.this.windowAggregator.merge(w, acc);
                    }
                    MergingWindowProcessFunction.this.ctx.clearWindowState(w);
                    MergingWindowProcessFunction.this.ctx.clearPreviousState(w);
                }
                targetAcc = MergingWindowProcessFunction.this.windowAggregator.getAccumulators();
                MergingWindowProcessFunction.this.ctx.setWindowAccumulators(stateWindowResult, targetAcc);
            }
        }
    }
}

