/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;

public abstract class UnboundedPrecedingOverFrame
implements OverWindowFrame {
    private GeneratedAggsHandleFunction aggsHandleFunction;
    AggsHandleFunction processor;
    RowData accValue;
    ResettableExternalBuffer.BufferIterator inputIterator;
    BinaryRowData nextRow;

    public UnboundedPrecedingOverFrame(GeneratedAggsHandleFunction aggsHandleFunction) {
        this.aggsHandleFunction = aggsHandleFunction;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        ClassLoader cl = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(cl);
        this.processor.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.aggsHandleFunction = null;
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        if (this.inputIterator != null) {
            this.inputIterator.close();
        }
        this.inputIterator = rows.newIterator();
        if (this.inputIterator.advanceNext()) {
            this.nextRow = this.inputIterator.getRow().copy();
        }
        this.processor.setAccumulators(this.processor.createAccumulators());
    }
}

