/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.logcollection.LogAbstractTask;
import org.apache.inlong.agent.plugin.task.logcollection.local.FileScanner;
import org.apache.inlong.agent.plugin.task.logcollection.local.WatchEntity;
import org.apache.inlong.agent.plugin.utils.regex.DateUtils;
import org.apache.inlong.agent.plugin.utils.regex.PathDateExpression;
import org.apache.inlong.agent.plugin.utils.regex.PatternUtil;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.apache.inlong.agent.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTask
extends LogAbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTask.class);
    private final Map<String, WatchEntity> watchers = new ConcurrentHashMap<String, WatchEntity>();
    private final Set<String> watchFailedDirs = new HashSet<String>();
    public static final int CORE_THREAD_MAX_GAP_TIME_MS = 60000;
    private boolean realTime = false;
    private Set<String> originPatterns;
    private long lastScanTime = 0L;
    public final long SCAN_INTERVAL = 60000L;
    private volatile long coreThreadUpdateTime = 0L;

    @Override
    protected int getInstanceLimit() {
        return this.taskProfile.getInt("task.fileTask.maxFileCount");
    }

    @Override
    protected void initTask() {
        super.initTask();
        this.timeOffset = this.taskProfile.get("task.fileTask.timeOffset", "");
        this.retry = this.taskProfile.isRetry();
        this.originPatterns = Stream.of(this.taskProfile.get("task.fileTask.dir.patterns").split(",")).collect(Collectors.toSet());
        if (this.taskProfile.getCycleUnit().compareToIgnoreCase("R") == 0) {
            this.realTime = true;
        }
        if (this.retry) {
            this.initRetryTask(this.taskProfile);
        } else {
            this.watchInit();
        }
    }

    private boolean initRetryTask(TaskProfile profile) {
        String dataTimeFrom = profile.get("task.fileTask.dataTimeFrom", "");
        String dataTimeTo = profile.get("task.fileTask.dataTimeTo", "");
        try {
            this.startTime = DateTransUtils.timeStrConvertToMillSec((String)dataTimeFrom, (String)profile.getCycleUnit());
            this.endTime = DateTransUtils.timeStrConvertToMillSec((String)dataTimeTo, (String)profile.getCycleUnit());
        }
        catch (ParseException e) {
            LOGGER.error("retry task time error start {} end {}", new Object[]{dataTimeFrom, dataTimeTo, e});
            return false;
        }
        return true;
    }

    public boolean isProfileValid(TaskProfile profile) {
        boolean ret;
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey("task.fileTask.cycleUnit")) {
            LOGGER.error("task profile needs file cycle unit");
            return false;
        }
        if (!profile.hasKey("task.cycleUnit")) {
            LOGGER.error("task profile needs cycle unit");
            return false;
        }
        if (profile.get("task.cycleUnit").compareTo(profile.get("task.fileTask.cycleUnit")) != 0) {
            LOGGER.error("task profile cycle unit must be consistent");
            return false;
        }
        if (!profile.hasKey("task.timeZone")) {
            LOGGER.error("task profile needs time zone");
            return false;
        }
        boolean bl = ret = profile.hasKey("task.fileTask.dir.patterns") && profile.hasKey("task.fileTask.maxFileCount");
        if (!ret) {
            LOGGER.error("task profile needs file keys");
            return false;
        }
        if (profile.getCycleUnit().compareToIgnoreCase("R") != 0 && !profile.hasKey("task.fileTask.timeOffset")) {
            LOGGER.error("task profile needs time offset");
            return false;
        }
        return !profile.isRetry() || this.initRetryTask(profile);
    }

    private void watchInit() {
        this.originPatterns.forEach(pathPattern -> this.addPathPattern((String)pathPattern));
    }

    public void addPathPattern(String originPattern) {
        ArrayList<String> directories = PatternUtil.cutDirectoryByWildcardAndDateExpression(originPattern);
        String basicStaticPath = directories.get(0);
        LOGGER.info("dataName {} watchPath {}", new Object[]{originPattern, basicStaticPath});
        if (!new File(basicStaticPath).exists()) {
            LOGGER.warn("DIRECTORY_NOT_FOUND_ERROR" + basicStaticPath);
            this.watchFailedDirs.add(originPattern);
            return;
        }
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            WatchEntity entity = new WatchEntity(watchService, originPattern, this.taskProfile.getCycleUnit());
            entity.registerRecursively();
            this.watchers.put(originPattern, entity);
            this.watchFailedDirs.remove(originPattern);
        }
        catch (IOException e) {
            if (e.toString().contains("Too many open files") || e.toString().contains("\u6253\u5f00\u7684\u6587\u4ef6\u8fc7\u591a")) {
                LOGGER.error("WATCH_DIR_ERROR", (Throwable)e);
            } else {
                LOGGER.error("WATCH_DIR_ERROR", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("addPathPattern:", (Throwable)e);
        }
    }

    @Override
    protected void releaseTask() {
        this.releaseWatchers(this.watchers);
    }

    private void releaseWatchers(Map<String, WatchEntity> watchers) {
        while (this.running) {
            if (AgentUtils.getCurrentTime() - this.coreThreadUpdateTime > 60000L) {
                LOGGER.error("core thread not update, maybe it has broken");
                break;
            }
            AgentUtils.silenceSleepInMs((long)1000L);
        }
        watchers.forEach((taskId, watcher) -> {
            try {
                watcher.getWatchService().close();
            }
            catch (IOException e) {
                LOGGER.error("close watch service failed taskId {}", (Object)e, taskId);
            }
        });
    }

    @Override
    protected void runForNormal() {
        if (AgentUtils.getCurrentTime() - this.lastScanTime > 60000L) {
            this.scanExistingFile();
            this.lastScanTime = AgentUtils.getCurrentTime();
        }
        this.runForWatching();
        this.dealWithEventMap();
    }

    @Override
    protected void scanExistingFile() {
        this.originPatterns.forEach(originPattern -> {
            List<FileScanner.BasicFileInfo> fileInfos = this.scanExistingFileByPattern((String)originPattern);
            LOGGER.info("taskId {} scan {} get file count {}", new Object[]{this.getTaskId(), originPattern, fileInfos.size()});
            fileInfos.forEach(fileInfo -> {
                String fileName = fileInfo.fileName;
                Long fileUpdateTime = FileUtils.getFileLastModifyTime((String)fileName);
                this.addToEvenMap(fileName, fileInfo.dataTime, fileUpdateTime, this.taskProfile.getCycleUnit());
                if (this.retry) {
                    ++this.instanceCount;
                }
            });
        });
    }

    private List<FileScanner.BasicFileInfo> scanExistingFileByPattern(String originPattern) {
        if (this.realTime) {
            return FileScanner.scanTaskBetweenTimes(originPattern, "H", this.timeOffset, this.startTime, this.endTime, this.retry);
        }
        return FileScanner.scanTaskBetweenTimes(originPattern, this.taskProfile.getCycleUnit(), this.timeOffset, this.startTime, this.endTime, this.retry);
    }

    private void runForWatching() {
        HashSet<String> tmpWatchFailedDirs = new HashSet<String>(this.watchFailedDirs);
        for (String string : tmpWatchFailedDirs) {
            this.addPathPattern(string);
        }
        for (Map.Entry entry : this.watchers.entrySet()) {
            this.dealWithWatchEntity((String)entry.getKey());
        }
    }

    @Override
    protected void dealWithEventMap() {
        this.removeTimeoutEvent(this.eventMap, this.retry);
        if (this.realTime) {
            this.dealWithEventMapRealTime();
        } else {
            this.dealWithEventMapWithCycle();
        }
    }

    private void dealWithEventMapRealTime() {
        for (String dataTime : this.eventMap.keySet()) {
            this.dealEventMapByDataTime(dataTime, true);
        }
    }

    public synchronized void dealWithWatchEntity(String originPattern) {
        WatchEntity entity = this.watchers.get(originPattern);
        if (entity == null) {
            LOGGER.error("Can't find the watch entity for originPattern: " + originPattern);
            return;
        }
        try {
            entity.removeDeletedWatchDir();
            for (int i = 0; i < entity.getTotalPathSize(); ++i) {
                WatchKey key = entity.getWatchService().poll();
                if (key == null) {
                    return;
                }
                this.dealWithWatchKey(entity, key);
            }
        }
        catch (Exception e) {
            LOGGER.error("deal with creation event error: ", (Throwable)e);
        }
    }

    private void dealWithWatchKey(WatchEntity entity, WatchKey key) throws IOException {
        Path contextPath = entity.getPath(key);
        LOGGER.info("Find creation events in path: {}", (Object)contextPath.toAbsolutePath());
        for (WatchEvent<?> watchEvent : key.pollEvents()) {
            Path child = this.resolvePathFromEvent(watchEvent, contextPath);
            if (child == null) continue;
            if (Files.isDirectory(child, new LinkOption[0])) {
                LOGGER.info("The find creation event is triggered by a directory: {}", (Object)child.getFileName());
                entity.registerRecursively(child);
                continue;
            }
            this.handleFilePath(child, entity);
        }
        this.resetWatchKey(entity, key, contextPath);
    }

    private Path resolvePathFromEvent(WatchEvent<?> watchEvent, Path contextPath) {
        WatchEvent.Kind<?> kind = watchEvent.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            LOGGER.error("An event is unclear and lost");
            return null;
        }
        WatchEvent<?> watchEventPath = watchEvent;
        Path eventPath = (Path)watchEventPath.context();
        return contextPath.resolve(eventPath);
    }

    private void handleFilePath(Path filePath, WatchEntity entity) {
        String newFileName = filePath.toFile().getAbsolutePath();
        LOGGER.info("new file {} {}", (Object)newFileName, (Object)entity.getPattern());
        Matcher matcher = entity.getPattern().matcher(newFileName);
        if (matcher.matches() || matcher.lookingAt()) {
            LOGGER.info("matched file {} {}", (Object)newFileName, (Object)entity.getPattern());
            String dataTime = this.getDataTimeFromFileName(newFileName, entity.getDateExpression());
            if (!this.checkFileNameForTime(newFileName, entity)) {
                LOGGER.error("File Timeout {} {}", (Object)newFileName, (Object)dataTime);
                return;
            }
            Long fileUpdateTime = FileUtils.getFileLastModifyTime((String)newFileName);
            this.addToEvenMap(newFileName, dataTime, fileUpdateTime, this.taskProfile.getCycleUnit());
        }
    }

    private boolean checkFileNameForTime(String newFileName, WatchEntity entity) {
        PathDateExpression dateExpression = entity.getDateExpression();
        if (dateExpression.getLongestDatePattern().length() != 0) {
            String dataTime = this.getDataTimeFromFileName(newFileName, dateExpression);
            LOGGER.info("file {}, fileTime {}", (Object)newFileName, (Object)dataTime);
            if (!DateUtils.isValidCreationTime(dataTime, entity.getCycleUnit(), this.timeOffset)) {
                return false;
            }
        }
        return true;
    }

    private String getDataTimeFromFileName(String fileName, PathDateExpression dateExpression) {
        String fileTime = DateUtils.getDateTime(fileName, dateExpression);
        return fileTime.replaceAll("\\D", "");
    }

    private void resetWatchKey(WatchEntity entity, WatchKey key, Path contextPath) {
        key.reset();
        if (!key.isValid()) {
            LOGGER.warn("Invalid Watcher {}", (Object)contextPath.getFileName());
            try {
                WatchService oldService = entity.getWatchService();
                oldService.close();
                WatchService watchService = FileSystems.getDefault().newWatchService();
                entity.clearKeys();
                entity.clearPathToKeys();
                entity.setWatchService(watchService);
                entity.registerRecursively();
            }
            catch (IOException e) {
                LOGGER.error("Restart a new watcher runs into error: ", (Throwable)e);
            }
        }
    }
}

