/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.executors;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.entry.TopicTaskEntry;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.repository.TopicTaskRepository;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.apache.inlong.tubemq.manager.service.interfaces.TopicService;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpBrokerInfoList;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpTopicInfoList;
import org.apache.inlong.tubemq.manager.utils.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AddTopicExecutor {
    private static final Logger log = LoggerFactory.getLogger(AddTopicExecutor.class);
    public static final int MAX_CONFIG_TOPIC_NUM = 100;
    @Autowired
    NodeService nodeService;
    @Autowired
    MasterRepository masterRepository;
    @Value(value="${manager.max.configurable.broker.size:50}")
    private int maxConfigurableBrokerSize;
    @Value(value="${manager.max.config.topic.retry.time:50}")
    private int maxRetryTimes = 5000;
    @Autowired
    TopicTaskRepository topicTaskRepository;
    @Autowired
    TopicService topicService;
    @Autowired
    MasterService masterService;

    @Async(value="asyncExecutor")
    public void addTopicConfig(Long clusterId, List<TopicTaskEntry> topicTasks) {
        if (CollectionUtils.isEmpty(topicTasks)) {
            return;
        }
        List taskParts = ListUtils.partition(topicTasks, (int)100);
        MasterEntry masterNode = this.masterService.getMasterNode(clusterId);
        TubeHttpBrokerInfoList brokerInfoList = this.nodeService.requestBrokerStatus(masterNode);
        if (ValidateUtils.isNull(brokerInfoList)) {
            return;
        }
        for (List taskPart : taskParts) {
            Map<String, TopicTaskEntry> topicEntryMap = taskPart.stream().collect(Collectors.toMap(TopicTaskEntry::getTopicName, topicTaskEntry -> topicTaskEntry, (v1, v2) -> v2));
            this.doConfigTopics(topicEntryMap, masterNode, brokerInfoList);
        }
    }

    private void doConfigTopics(Map<String, TopicTaskEntry> topicEntryMap, MasterEntry masterNode, TubeHttpBrokerInfoList brokerInfoList) {
        this.handleAddingTopic(masterNode, brokerInfoList, topicEntryMap);
        this.updateConfigResult(masterNode, topicEntryMap);
    }

    private void updateConfigResult(MasterEntry masterEntry, Map<String, TopicTaskEntry> pendingTopic) {
        TubeHttpBrokerInfoList brokerInfoList = this.nodeService.requestBrokerStatus(masterEntry);
        if (ValidateUtils.isNull(brokerInfoList)) {
            return;
        }
        for (String topic : pendingTopic.keySet()) {
            TubeHttpTopicInfoList topicInfoList = this.topicService.requestTopicConfigInfo(masterEntry, topic);
            if (ValidateUtils.isNull(topicInfoList)) continue;
            HashSet<Integer> topicBrokerSet = new HashSet<Integer>(topicInfoList.getTopicBrokerIdList());
            List<Integer> allBrokerIdList = brokerInfoList.getAllBrokerIdList();
            TopicTaskEntry topicTask = pendingTopic.get(topic);
            this.updateTopicRepo(topicBrokerSet, allBrokerIdList, topicTask);
        }
    }

    private void updateTopicRepo(Set<Integer> topicBrokerSet, List<Integer> allBrokerIdList, TopicTaskEntry topicTask) {
        if (!topicBrokerSet.containsAll(allBrokerIdList)) {
            Integer retryTimes = topicTask.getConfigRetryTimes() + 1;
            topicTask.setConfigRetryTimes(retryTimes);
            this.topicTaskRepository.save(topicTask);
        }
    }

    private void handleAddingTopic(MasterEntry masterEntry, TubeHttpBrokerInfoList brokerInfoList, Map<String, TopicTaskEntry> pendingTopic) {
        HashSet<String> brandNewTopics = new HashSet<String>();
        for (String topic : pendingTopic.keySet()) {
            TubeHttpTopicInfoList topicInfoList = this.topicService.requestTopicConfigInfo(masterEntry, topic);
            if (ValidateUtils.isNull(topicInfoList)) {
                return;
            }
            List<Integer> topicBrokerList = topicInfoList.getTopicBrokerIdList();
            if (topicBrokerList.isEmpty()) {
                brandNewTopics.add(topic);
                continue;
            }
            this.handleAddingExistTopics(masterEntry, brokerInfoList, topic, topicBrokerList);
        }
        this.handleAddingNewTopics(masterEntry, brokerInfoList, brandNewTopics);
    }

    private void handleAddingExistTopics(MasterEntry masterEntry, TubeHttpBrokerInfoList brokerInfoList, String topic, List<Integer> topicBrokerList) {
        List<Integer> configurableBrokerIdList = brokerInfoList.getConfigurableBrokerIdList();
        configurableBrokerIdList.removeAll(topicBrokerList);
        HashSet<String> singleTopic = new HashSet<String>();
        singleTopic.add(topic);
        int maxBrokers = Math.min(this.maxConfigurableBrokerSize, configurableBrokerIdList.size());
        this.nodeService.configBrokersForTopics(masterEntry, singleTopic, configurableBrokerIdList, maxBrokers);
    }

    private void handleAddingNewTopics(MasterEntry masterEntry, TubeHttpBrokerInfoList brokerInfoList, Set<String> brandNewTopics) {
        if (CollectionUtils.isEmpty(brandNewTopics)) {
            return;
        }
        List<Integer> configurableBrokerIdList = brokerInfoList.getConfigurableBrokerIdList();
        int maxBrokers = Math.min(this.maxConfigurableBrokerSize, configurableBrokerIdList.size());
        this.nodeService.configBrokersForTopics(masterEntry, brandNewTopics, configurableBrokerIdList, maxBrokers);
    }
}

